/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.queryplus;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.queryplus.AbstractQueryPlusStatementBuilder;
import com.tangosol.coherence.dslquery.statement.DefaultStatementResult;
import com.tangosol.coherence.dsltools.precedence.OPParser;
import com.tangosol.coherence.dsltools.precedence.OPScanner;
import com.tangosol.coherence.dsltools.precedence.OPToken;
import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.Terms;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.Service;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class ServicesStatementBuilder
extends AbstractQueryPlusStatementBuilder {
    @Override
    public ServicesQueryPlusStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        try {
            AtomicTerm atomicTerm = (AtomicTerm)term.termAt(1);
            String sAction = atomicTerm.getValue();
            return new ServicesQueryPlusStatement(sAction);
        }
        catch (IllegalArgumentException e) {
            throw new CohQLException("Invalid services command - valid syntax is: " + this.getSyntax());
        }
    }

    @Override
    public String getSyntax() {
        return "SERVICES INFO";
    }

    @Override
    public String getDescription() {
        return "Displays information about the Services on this member.";
    }

    @Override
    public AbstractQueryPlusStatementBuilder.AbstractOPToken instantiateOpToken() {
        return new ServicesCommandOPToken();
    }

    public class ServicesQueryPlusStatement
    extends AbstractQueryPlusStatementBuilder.AbstractStatement {
        protected final String f_sAction;

        public ServicesQueryPlusStatement(String sAction) {
            super(ServicesStatementBuilder.this);
            this.f_sAction = sAction;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            if (this.f_sAction.toLowerCase().equals("info")) {
                return this.dumpServiceInfo(ctx);
            }
            return StatementResult.NULL_RESULT;
        }

        public StatementResult dumpServiceInfo(ExecutionContext ctx) {
            Cluster cluster = ctx.getCluster();
            ArrayList<String> listInfo = new ArrayList<String>();
            Enumeration enumServiceNames = cluster.getServiceNames();
            while (enumServiceNames.hasMoreElements()) {
                String serviceName = (String)enumServiceNames.nextElement();
                Service service = cluster.getService(serviceName);
                if (!(service instanceof CacheService)) continue;
                listInfo.add(serviceName);
                CacheService cacheService = (CacheService)service;
                Enumeration cacheNames = cacheService.getCacheNames();
                while (cacheNames.hasMoreElements()) {
                    listInfo.add("\t" + String.valueOf(cacheNames.nextElement()));
                }
            }
            return new DefaultStatementResult(listInfo);
        }
    }

    public class ServicesCommandOPToken
    extends AbstractQueryPlusStatementBuilder.AbstractOPToken {
        public ServicesCommandOPToken() {
            super(ServicesStatementBuilder.this, "services", OPToken.IDENTIFIER_NODE, "servicesCommand");
        }

        @Override
        public Term nud(OPParser parser) {
            OPScanner scanner = parser.getScanner();
            String sAction = scanner.getCurrentAsString();
            if (sAction != null) {
                scanner.advance();
                return Terms.newTerm(this.getFunctor(), AtomicTerm.createString(sAction));
            }
            return super.nud(parser);
        }
    }
}

