/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dsltools.precedence;

import com.tangosol.coherence.dsltools.base.BaseToken;
import com.tangosol.coherence.dsltools.base.BaseTokenScanner;
import com.tangosol.coherence.dsltools.base.BaseTokenStream;
import com.tangosol.coherence.dsltools.base.IdentifierBaseToken;
import com.tangosol.coherence.dsltools.base.LeafBaseToken;
import com.tangosol.coherence.dsltools.base.LiteralBaseToken;
import com.tangosol.coherence.dsltools.base.NestedBaseTokens;
import com.tangosol.coherence.dsltools.base.OperatorBaseToken;
import com.tangosol.coherence.dsltools.base.PunctuationBaseToken;
import com.tangosol.coherence.dsltools.base.SequenceBaseToken;
import com.tangosol.coherence.dsltools.precedence.EndOPToken;
import com.tangosol.coherence.dsltools.precedence.EndOfStatementOPToken;
import com.tangosol.coherence.dsltools.precedence.NestingOPToken;
import com.tangosol.coherence.dsltools.precedence.OPException;
import com.tangosol.coherence.dsltools.precedence.OPToken;
import com.tangosol.coherence.dsltools.precedence.TokenTable;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;

public class OPScanner {
    protected BaseTokenStream m_data;
    protected BaseToken m_current;
    protected OPToken m_currentToken;
    protected TokenTable m_tokenTable;
    protected Set<CharSequence> m_setOperators;
    boolean m_fStrict = false;

    public OPScanner(TokenTable tokenTable, Set<CharSequence> setOperators) {
        this.m_tokenTable = tokenTable;
        this.m_setOperators = setOperators;
    }

    public void scan(String s) {
        this.scan(new StringReader(s));
    }

    public void scan(Reader r) {
        BaseTokenScanner baseScanner = new BaseTokenScanner(r);
        this.m_data = new BaseTokenStream((SequenceBaseToken)baseScanner.scan());
        this.next();
    }

    public void reset() {
        this.m_current = this.m_data.getCurrentToken();
        this.classify();
    }

    public void setStrictness(boolean fStrict) {
        this.m_fStrict = fStrict;
    }

    public OPToken next() {
        this.m_current = this.m_data.next();
        return this.classify();
    }

    public boolean isEnd() {
        return this.m_current == null;
    }

    public boolean isEndOfStatement() {
        return this.m_current == null || this.m_current.match(EndOfStatementOPToken.INSTANCE.getValue());
    }

    public OPToken getCurrent() {
        return this.m_currentToken;
    }

    public BaseToken getCurrentBaseToken() {
        return this.m_current;
    }

    public String getCurrentAsString() {
        if (this.m_current == null || this.m_current.isCompound()) {
            return null;
        }
        return ((LeafBaseToken)this.m_current).getValue();
    }

    public String peekNextAsString() {
        BaseToken token = this.m_data.peek();
        if (token == null || token.isCompound()) {
            return null;
        }
        return ((LeafBaseToken)token).getValue();
    }

    public BaseToken peekNext() {
        return this.m_data.peek();
    }

    public String[] peekNext2AsStrings() {
        BaseToken[] tokens = this.m_data.peek2();
        if (tokens[0] == null || tokens[0].isCompound()) {
            return null;
        }
        if (tokens[1] == null || tokens[1].isCompound()) {
            return null;
        }
        return new String[]{((LeafBaseToken)tokens[0]).getValue(), ((LeafBaseToken)tokens[1]).getValue()};
    }

    public String getCurrentAsStringWithAdvance() {
        String s = this.getCurrentAsString();
        this.next();
        return s;
    }

    public boolean matches(String sWord) {
        return this.matches(sWord, this.m_tokenTable.isIgnoringCase());
    }

    public boolean matches(String sWord, boolean fIgnoreCase) {
        return this.m_current != null && this.m_current.match(sWord, fIgnoreCase);
    }

    public boolean advanceWhenMatching(String sWord) {
        boolean f = this.matches(sWord);
        if (f) {
            this.next();
        }
        return f;
    }

    public OPToken advance(String s) {
        return this.advance(s, this.m_tokenTable.isIgnoringCase());
    }

    public OPToken advance(String s, boolean fIgnoreCase) {
        if (this.matches(s, fIgnoreCase)) {
            return this.next();
        }
        throw new OPException("Unfullfilled expectation \"" + s + "\" not found!");
    }

    public OPToken advance() {
        return this.next();
    }

    public void pushStream(BaseTokenStream ts) {
        ts.setLink(this.m_data);
        this.m_data = ts;
        this.next();
    }

    public void popStream() {
        BaseTokenStream old = this.m_data;
        this.m_data = this.m_data.getLink();
        old.setLink(null);
        this.reset();
    }

    public void enableTokenNamed(String name) {
        this.m_tokenTable.enable(name);
    }

    public void disableTokenNamed(String name) {
        this.m_tokenTable.disable(name);
    }

    protected OPToken classify() {
        try {
            if (this.m_current == null) {
                this.m_currentToken = EndOPToken.INSTANCE;
                return this.m_currentToken;
            }
            if (this.m_current.isNest()) {
                NestedBaseTokens nt = (NestedBaseTokens)this.m_current;
                String start = Character.toString(nt.getNestStart());
                NestingOPToken orig = (NestingOPToken)this.m_tokenTable.lookup(start);
                if (orig == null) {
                    throw new OPException("Unknown Nesting character '" + start + "' found!");
                }
                try {
                    NestingOPToken nestTok = (NestingOPToken)orig.clone();
                    this.m_currentToken = nestTok.setNest(nt);
                    return this.m_currentToken;
                }
                catch (CloneNotSupportedException ex) {
                    throw new OPException("Unexpected Nesting Scanning Failure :" + ex.getMessage());
                }
            }
            if (this.m_current.isPunctuation()) {
                PunctuationBaseToken ptoken = (PunctuationBaseToken)this.m_current;
                this.m_currentToken = this.m_tokenTable.lookup(ptoken.getValue());
                if (this.m_currentToken == null) {
                    if (this.m_fStrict) {
                        throw new OPException("Unknown punctuation \"" + ptoken.getValue() + "\" not found!");
                    }
                    this.m_currentToken = this.m_tokenTable.newIdentifier(ptoken.getValue());
                }
                return this.m_currentToken;
            }
            if (this.m_current.isOperator()) {
                OperatorBaseToken otoken = (OperatorBaseToken)this.m_current;
                this.m_currentToken = this.m_tokenTable.lookup(otoken.getValue());
                if (this.m_currentToken == null) {
                    if (this.m_fStrict) {
                        throw new OPException("Unknown Operator \"" + otoken.getValue() + "\" not found!");
                    }
                    this.m_currentToken = this.m_tokenTable.newIdentifier(otoken.getValue());
                }
                return this.m_currentToken;
            }
            if (this.m_current.isLiteral()) {
                LiteralBaseToken bt = (LiteralBaseToken)this.m_current;
                this.m_currentToken = this.m_tokenTable.newLiteral(bt.getValue(), bt.getType());
                return this.m_currentToken;
            }
            if (this.m_current.isIdentifier()) {
                String id = ((IdentifierBaseToken)this.m_current).getValue();
                this.m_currentToken = this.m_tokenTable.lookup(id);
                if (this.m_currentToken != null) {
                    return this.m_currentToken;
                }
                this.m_currentToken = this.m_tokenTable.newIdentifier(id);
                return this.m_currentToken;
            }
            throw new OPException("Scanner Classification failure on : " + this.m_current.toString());
        }
        catch (IndexOutOfBoundsException ex) {
            this.m_current = null;
            this.m_currentToken = EndOPToken.INSTANCE;
            return this.m_currentToken;
        }
    }
}

