/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dsltools.termtrees;

import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.TermWalker;

public class AtomicTerm
extends Term {
    public static final int STRINGLITERAL = 1;
    public static final int INTEGERLITERAL = 2;
    public static final int LONGLITERAL = 3;
    public static final int FLOATLITERAL = 4;
    public static final int DOUBLELITERAL = 5;
    public static final int BOOLEANLITERAL = 6;
    public static final int NULLLITERAL = 7;
    public static final int SHORTLITERAL = 8;
    public static final int SYMBOLLITERAL = 9;
    String m_sValue;
    int m_nTypeCode;

    public AtomicTerm(String sValue, int nType) {
        this.m_sValue = sValue;
        this.m_nTypeCode = nType;
    }

    public int getTypeCode() {
        return this.m_nTypeCode;
    }

    public String getValue() {
        return this.m_sValue;
    }

    @Override
    public String getFunctor() {
        switch (this.m_nTypeCode) {
            case 1: {
                return "String";
            }
            case 8: {
                return "Short";
            }
            case 2: {
                return "Integer";
            }
            case 4: {
                return "Float";
            }
            case 3: {
                return "Long";
            }
            case 5: {
                return "Double";
            }
            case 6: {
                return "Boolean";
            }
            case 7: {
                return "Null";
            }
            case 9: {
                return "Symbol";
            }
        }
        return null;
    }

    @Override
    public String fullFormString() {
        return this.toString();
    }

    @Override
    public boolean isNumber() {
        return this.m_nTypeCode >= 2 && this.m_nTypeCode <= 5;
    }

    @Override
    public Term withChild(Term t) {
        return new NodeTerm(".list.", (Term)this, t);
    }

    @Override
    public Term[] children() {
        return new Term[0];
    }

    @Override
    public Term termAt(int index) {
        if (index == 0) {
            return new AtomicTerm(this.getFunctor(), 1);
        }
        return null;
    }

    @Override
    public Term findChild(String fn) {
        return null;
    }

    @Override
    public boolean termEqual(Term t) {
        if (t == null) {
            return false;
        }
        if (t.isAtom()) {
            AtomicTerm ta = (AtomicTerm)t;
            if (this.m_nTypeCode == ta.m_nTypeCode) {
                if (this.m_sValue == ta.m_sValue) {
                    return true;
                }
                if (this.m_sValue == null || ta.m_sValue == null) {
                    return false;
                }
                return this.m_sValue.equals(ta.m_sValue);
            }
        }
        return false;
    }

    public Object getObject() {
        String s = this.m_sValue;
        switch (this.m_nTypeCode) {
            case 1: {
                return s;
            }
            case 8: {
                return Short.valueOf(s);
            }
            case 2: {
                return Integer.valueOf(s);
            }
            case 4: {
                return Float.valueOf(s);
            }
            case 3: {
                return Long.valueOf(s);
            }
            case 5: {
                if ("nan".equalsIgnoreCase(s)) {
                    return Double.NaN;
                }
                if ("infinity".equalsIgnoreCase(s)) {
                    return Double.POSITIVE_INFINITY;
                }
                return Double.valueOf(s);
            }
            case 6: {
                return Boolean.valueOf(this.m_sValue);
            }
            case 7: {
                return null;
            }
            case 9: {
                return s;
            }
        }
        return null;
    }

    public Number getNumber() {
        String s = this.m_sValue;
        switch (this.m_nTypeCode) {
            case 8: {
                return Short.valueOf(s);
            }
            case 2: {
                return Integer.valueOf(s);
            }
            case 4: {
                return Float.valueOf(s);
            }
            case 3: {
                return Long.valueOf(s);
            }
            case 5: {
                return Double.valueOf(s);
            }
        }
        return null;
    }

    public Number negativeNumber(Number num) {
        switch (this.m_nTypeCode) {
            case 8: {
                return -num.shortValue();
            }
            case 2: {
                return 0 - num.intValue();
            }
            case 4: {
                return Float.valueOf((float)(0.0 - (double)num.floatValue()));
            }
            case 3: {
                return 0L - num.longValue();
            }
            case 5: {
                return 0.0 - num.doubleValue();
            }
        }
        return null;
    }

    public void negate() {
        this.m_sValue = this.m_sValue.startsWith("-") ? this.m_sValue.substring(1) : "-" + this.m_sValue;
    }

    public boolean isValidNumber() {
        String s = this.m_sValue;
        try {
            switch (this.m_nTypeCode) {
                case 8: {
                    Short.valueOf(s);
                    break;
                }
                case 2: {
                    Integer.valueOf(s);
                    break;
                }
                case 4: {
                    Float.valueOf(s);
                    break;
                }
                case 3: {
                    Long.valueOf(s);
                    break;
                }
                case 5: {
                    Double.valueOf(s);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void accept(TermWalker walker) {
        walker.acceptAtom(this.getFunctor(), this);
    }

    public String toString() {
        int nt = this.m_nTypeCode;
        StringBuffer str = new StringBuffer();
        if (nt == 1) {
            str.append('\"');
        }
        str.append(this.getValue());
        if (nt == 4) {
            str.append('f');
        } else if (nt == 3) {
            str.append('l');
        } else if (nt == 8) {
            str.append('s');
        } else if (nt == 1) {
            str.append('\"');
        }
        return str.toString();
    }

    public static AtomicTerm createString(String value) {
        return new AtomicTerm(value, 1);
    }

    public static AtomicTerm createShort(String value) {
        return new AtomicTerm(value, 8);
    }

    public static AtomicTerm createInteger(String value) {
        return new AtomicTerm(value, 2);
    }

    public static AtomicTerm createLong(String value) {
        return new AtomicTerm(value, 3);
    }

    public static AtomicTerm createFloat(String value) {
        return new AtomicTerm(value, 4);
    }

    public static AtomicTerm createDouble(String value) {
        return new AtomicTerm(value, 5);
    }

    public static AtomicTerm createBoolean(String value) {
        return new AtomicTerm(value, 6);
    }

    public static AtomicTerm createNull(String value) {
        return new AtomicTerm(value, 7);
    }

    public static AtomicTerm createNull() {
        return new AtomicTerm("null", 7);
    }

    public static AtomicTerm createSymbol(String value) {
        return new AtomicTerm(value, 9);
    }
}

