/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.http;

import com.oracle.coherence.common.net.SSLSocketProvider;
import com.oracle.coherence.common.net.SocketProvider;
import com.tangosol.coherence.http.HttpServer;
import com.tangosol.coherence.http.HttpServerStats;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Service;
import com.tangosol.net.Session;
import com.tangosol.net.options.WithClassLoader;
import com.tangosol.net.security.IdentityAsserter;
import com.tangosol.net.security.JAASIdentityAsserter;
import com.tangosol.net.security.UsernameAndPassword;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;

public abstract class AbstractHttpServer
implements HttpServer,
HttpServerStats {
    protected String m_sAuthMethod = "none";
    protected Session m_session;
    protected String m_sAddr = "localhost";
    protected int m_nPort = 0;
    protected Service m_serviceParent;
    protected final Map<String, ResourceConfig> m_mapResourceConfig = new HashMap<String, ResourceConfig>();
    protected SocketProvider m_socketProvider;
    protected IdentityAsserter m_identityAsserter = DEFAULT_IDENTITY_ASSERTER;
    protected boolean m_fStarted;
    private long m_cRequestCount = 0L;
    private long m_ltdTotalRequestTime = 0L;
    private long m_cErrors = 0L;
    private final long[] f_aStatusCodes = new long[5];
    private long m_ldtResetTime = Base.getSafeTimeMillis();
    public static final String DEFAULT_ADDRESS = "localhost";
    public static final int DEFAULT_PORT = 0;
    public static final IdentityAsserter DEFAULT_IDENTITY_ASSERTER = new JAASIdentityAsserter("CoherenceREST");
    public static final String AUTH_BASIC = "basic";
    public static final String AUTH_CERT = "cert";
    public static final String AUTH_CERT_BASIC = "cert+basic";
    public static final String AUTH_NONE = "none";
    public static final String HTTP_BASIC_REALM = "Coherence REST";
    public static final String ATTR_SUBJECT = "__SUBJECT";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    protected static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    protected static final Principal EMPTY_PRINCIPAL = () -> null;
    protected static final String SLASH = "/";
    protected static final char SLASH_CHAR = "/".charAt(0);
    protected static final String DEFAULT_BASIC_AUTH_HEADER_VALUE = "Basic realm=\"Coherence REST\"";

    @Override
    public void setAuthMethod(String sMethod) {
        if (!(AUTH_BASIC.equalsIgnoreCase(sMethod) || AUTH_CERT.equalsIgnoreCase(sMethod) || AUTH_CERT_BASIC.equalsIgnoreCase(sMethod) || AUTH_NONE.equalsIgnoreCase(sMethod))) {
            throw new IllegalArgumentException("unsupported method: " + sMethod);
        }
        this.m_sAuthMethod = sMethod;
    }

    @Override
    public void setSession(Session session) {
        this.m_session = session;
    }

    @Override
    public void setLocalAddress(String sAddr) {
        this.m_sAddr = sAddr;
    }

    @Override
    public String getListenAddress() {
        return this.getLocalAddress();
    }

    @Override
    public int getListenPort() {
        return this.m_nPort;
    }

    @Override
    public void setLocalPort(int nPort) {
        this.m_nPort = nPort;
    }

    @Override
    public void setParentService(Service service) {
        this.m_serviceParent = service;
    }

    @Override
    public void setResourceConfig(ResourceConfig config) {
        this.setResourceConfig(Collections.singletonMap(SLASH, config));
    }

    @Override
    public void setResourceConfig(Map<String, ResourceConfig> mapConfig) {
        this.m_mapResourceConfig.clear();
        this.m_mapResourceConfig.putAll(mapConfig);
    }

    @Override
    public void setSocketProvider(SocketProvider provider) {
        this.m_socketProvider = provider;
    }

    @Override
    public synchronized void start() throws IOException {
        if (!this.m_fStarted) {
            this.startInternal();
            this.m_fStarted = true;
        }
    }

    @Override
    public synchronized void stop() throws IOException {
        if (this.m_fStarted) {
            this.stopInternal();
            this.m_fStarted = false;
        }
    }

    @Override
    public long getRequestCount() {
        return this.m_cRequestCount;
    }

    @Override
    public float getAverageRequestTime() {
        return this.m_cRequestCount == 0L ? 0.0f : (float)this.m_ltdTotalRequestTime / (float)this.m_cRequestCount;
    }

    @Override
    public float getRequestsPerSecond() {
        return this.m_cRequestCount == 0L ? 0.0f : (float)this.m_cRequestCount * 1.0f / ((float)(Base.getSafeTimeMillis() - this.m_ldtResetTime) / 1000.0f);
    }

    @Override
    public long getErrorCount() {
        return this.m_cErrors;
    }

    @Override
    public long getHttpStatusCount(int nPrefix) {
        this.validatePrefix(nPrefix);
        return this.f_aStatusCodes[nPrefix - 1];
    }

    @Override
    public void resetStats() {
        this.m_cRequestCount = 0L;
        this.m_ltdTotalRequestTime = 0L;
        this.m_cErrors = 0L;
        this.m_ldtResetTime = Base.getSafeTimeMillis();
        for (int i = 0; i < this.f_aStatusCodes.length; ++i) {
            this.f_aStatusCodes[i] = 0L;
        }
    }

    protected void incrementRequestCount() {
        ++this.m_cRequestCount;
    }

    protected void logRequestTime(long ltdStartTime) {
        this.m_ltdTotalRequestTime += Base.getLastSafeTimeMillis() - ltdStartTime;
    }

    protected void incrementErrors() {
        ++this.m_cErrors;
    }

    protected void logStatusCount(int nStatusCode) {
        if (nStatusCode >= 100 && nStatusCode <= 600) {
            int n = nStatusCode / 100 - 1;
            this.f_aStatusCodes[n] = this.f_aStatusCodes[n] + 1L;
        }
    }

    private void validatePrefix(int nPrefix) {
        if (nPrefix < 0 || nPrefix > this.f_aStatusCodes.length) {
            throw new IllegalArgumentException("Prefix must be between 0 and " + this.f_aStatusCodes.length);
        }
    }

    protected void dumpStats() {
        StringBuilder sb = new StringBuilder("HTTP statistics: ").append(new Date()).append('\n').append("  Start time:    ").append(new Date(this.m_ldtResetTime)).append('\n').append("Request Count=").append(this.getRequestCount()).append(", Avg Req Time=").append(this.getAverageRequestTime()).append(", Req/sec=").append(this.getRequestsPerSecond()).append(", Errors=").append(this.getErrorCount()).append("\nStatus counts: ");
        for (int i = 0; i < this.f_aStatusCodes.length; ++i) {
            sb.append("Status ").append((i + 1) * 100).append('=').append(this.f_aStatusCodes[i]).append(' ');
        }
        CacheFactory.log(sb.toString(), 3);
    }

    protected abstract void startInternal() throws IOException;

    protected abstract void stopInternal() throws IOException;

    protected abstract Object instantiateContainer(ResourceConfig var1, ServiceLocator var2);

    protected Object createContainer(ResourceConfig resourceConfig) {
        ServiceLocatorFactory factory = ServiceLocatorFactory.getInstance();
        ServiceLocator locator = factory.create(this.getClass().getName());
        DynamicConfiguration config = ((DynamicConfigurationService)locator.getService(DynamicConfigurationService.class, new Annotation[0])).createDynamicConfiguration();
        if (this.getParentService() != null) {
            config.bind((Descriptor)BuilderHelper.createConstantDescriptor((Object)this.getParentService(), null, (Type[])new Type[]{Service.class}));
        }
        config.bind((Descriptor)BuilderHelper.createConstantDescriptor((Object)this.getSession(), null, (Type[])new Type[]{Session.class}));
        config.commit();
        return this.instantiateContainer(resourceConfig, locator);
    }

    protected Subject authenticate(String sAuth) {
        String[] values;
        if (sAuth != null && sAuth.startsWith("Basic ") && (values = AbstractHttpServer.fromBase64(sAuth = sAuth.substring("Basic ".length())).split(":")).length == 2) {
            String sUsername = values[0];
            String sPassword = values[1];
            try {
                return this.getIdentityAsserter().assertIdentity(new UsernameAndPassword(sUsername, sPassword), this.getParentService());
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Subject getSubjectFromSession(SSLSession session) throws SSLPeerUnverifiedException {
        Set<Principal> setPrincipals = Collections.singleton(session.getPeerPrincipal());
        HashSet<Certificate> setCredentials = new HashSet<Certificate>(Arrays.asList(session.getPeerCertificates()));
        return new Subject(true, setPrincipals, setCredentials, Collections.emptySet());
    }

    protected void handleRequest(final ApplicationHandler app, final ContainerRequest request, Subject subject) throws IOException {
        if (subject == null) {
            app.handle(request);
        } else {
            try {
                Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IOException {
                        app.handle(request);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception cause = e.getException();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw (IOException)cause;
            }
        }
    }

    public static String toBase64(byte[] buffer) {
        byte[] result = Base64.getEncoder().encode(buffer);
        try {
            return new String(result, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            return new String(result);
        }
    }

    public static String toBase64(String text) {
        return AbstractHttpServer.toBase64(text.getBytes());
    }

    public static String fromBase64(byte[] buffer) {
        byte[] result = Base64.getDecoder().decode(buffer);
        try {
            return new String(result, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            return new String(result);
        }
    }

    public static String fromBase64(String text) {
        return AbstractHttpServer.fromBase64(text.getBytes());
    }

    public String getLocalAddress() {
        return this.m_sAddr;
    }

    public int getLocalPort() {
        return this.m_nPort;
    }

    public Service getParentService() {
        return this.m_serviceParent;
    }

    public Session getSession() {
        return this.m_session != null ? this.m_session : Session.create(WithClassLoader.autoDetect());
    }

    public SocketProvider getSocketProvider() {
        return this.m_socketProvider;
    }

    public SSLContext getSSLContext() {
        return this.isSecure() ? ((SSLSocketProvider)this.m_socketProvider).getDependencies().getSSLContext() : null;
    }

    public SSLParameters getSSLParameters() {
        return this.isSecure() ? ((SSLSocketProvider)this.m_socketProvider).getDependencies().getSSLParameters() : null;
    }

    public Map<String, ResourceConfig> getResourceConfig() {
        return this.m_mapResourceConfig;
    }

    public IdentityAsserter getIdentityAsserter() {
        return this.m_identityAsserter;
    }

    protected void setIdentityAsserter(IdentityAsserter asserter) {
        this.m_identityAsserter = asserter;
    }

    protected boolean isAuthMethodBasic() {
        String sAuthMethod = this.m_sAuthMethod;
        return AUTH_BASIC.equalsIgnoreCase(sAuthMethod) || AUTH_CERT_BASIC.equalsIgnoreCase(sAuthMethod);
    }

    protected boolean isAuthMethodCert() {
        String sAuthMethod = this.m_sAuthMethod;
        return AUTH_CERT.equalsIgnoreCase(sAuthMethod) || AUTH_CERT_BASIC.equalsIgnoreCase(sAuthMethod);
    }

    protected boolean isAuthMethodNone() {
        return AUTH_NONE.equalsIgnoreCase(this.m_sAuthMethod);
    }

    protected boolean isSecure() {
        return this.m_socketProvider instanceof SSLSocketProvider;
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "{Protocol=" + (this.isSecure() ? "HTTPS" : "HTTP") + ", AuthMethod=" + this.m_sAuthMethod + "}";
    }

    public static class SimpleSecurityContext
    implements SecurityContext {
        private String m_sAuthScheme;
        private Principal m_principal;
        private boolean m_fSecure;

        public SimpleSecurityContext(String sAuthScheme, Principal principal, boolean fSecure) {
            this.m_sAuthScheme = sAuthScheme;
            this.m_principal = principal;
            this.m_fSecure = fSecure;
        }

        public String getAuthenticationScheme() {
            return this.m_sAuthScheme;
        }

        public Principal getUserPrincipal() {
            return this.m_principal;
        }

        public boolean isSecure() {
            return this.m_fSecure;
        }

        public boolean isUserInRole(String sRole) {
            return false;
        }
    }
}

