/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.http;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsExchange;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import com.tangosol.coherence.http.AbstractHttpServer;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.Base;
import com.tangosol.util.DaemonThreadFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

public class DefaultHttpServer
extends AbstractHttpServer {
    protected HttpServer m_server;
    protected String m_sListenAddress;
    protected int m_nListenPort;

    @Override
    protected void startInternal() throws IOException {
        System.setProperty("sun.net.httpserver.nodelay", "true");
        HttpServer server = this.createHttpServer();
        server.start();
        this.m_server = server;
        this.resetStats();
    }

    @Override
    protected void stopInternal() throws IOException {
        this.m_server.stop(0);
        this.m_server = null;
    }

    @Override
    public String getListenAddress() {
        if (this.m_sListenAddress == null) {
            this.m_sListenAddress = this.m_server.getAddress().getHostString();
        }
        return this.m_sListenAddress;
    }

    @Override
    public int getListenPort() {
        if (this.m_nListenPort == 0) {
            this.m_nListenPort = this.m_server.getAddress().getPort();
        }
        return this.m_nListenPort;
    }

    protected HttpServer createHttpServer() throws IOException {
        HttpServer server;
        InetSocketAddress addr = new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
        if (this.isSecure()) {
            HttpsServer sslServer = HttpsServer.create(addr, 0);
            final SSLParameters sslParams = this.getSSLParameters();
            sslServer.setHttpsConfigurator(new HttpsConfigurator(this.getSSLContext()){

                @Override
                public void configure(HttpsParameters params) {
                    params.setSSLParameters(sslParams);
                    params.setNeedClientAuth(DefaultHttpServer.this.isAuthMethodCert());
                }
            });
            server = sslServer;
        } else {
            server = HttpServer.create(addr, 0);
        }
        server.setExecutor(Executors.newCachedThreadPool(new DaemonThreadFactory("DefaultHttpServerThread-")));
        for (Map.Entry<String, ResourceConfig> entry : this.getResourceConfig().entrySet()) {
            HttpHandler handler = (HttpHandler)this.createContainer(entry.getValue());
            if (this.isAuthMethodBasic()) {
                handler = new BasicAuthenticationHandler(handler);
            }
            server.createContext(entry.getKey(), handler);
        }
        return server;
    }

    @Override
    protected Object instantiateContainer(ResourceConfig config, ServiceLocator locator) {
        return new HttpServerContainer(config.getApplication(), locator);
    }

    private class HttpServerContainer
    implements HttpHandler,
    Container {
        private volatile ApplicationHandler m_hApplication;
        private volatile ContainerLifecycleListener m_containerListener;

        HttpServerContainer(Application application, ServiceLocator parentLocator) {
            this.m_hApplication = new ApplicationHandler(application, null, (Object)parentLocator);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange exchange) throws IOException {
            Writer responseWriter = null;
            DefaultHttpServer.this.incrementRequestCount();
            long ldtStart = Base.getLastSafeTimeMillis();
            try {
                URI uriBase;
                URI uriExchange = exchange.getRequestURI();
                String sDecodedBasePath = exchange.getHttpContext().getPath();
                if (!sDecodedBasePath.endsWith("/")) {
                    if (sDecodedBasePath.equals(uriExchange.getPath())) {
                        uriExchange = UriBuilder.fromUri((URI)uriExchange).path("/").build(new Object[0]);
                    }
                    sDecodedBasePath = sDecodedBasePath + "/";
                }
                String sScheme = exchange instanceof HttpsExchange ? "https" : "http";
                Object listHostHeader = exchange.getRequestHeaders().get("Host");
                if (listHostHeader == null) {
                    InetSocketAddress addr = exchange.getLocalAddress();
                    uriBase = new URI(sScheme, null, addr.getHostName(), addr.getPort(), sDecodedBasePath, null, null);
                } else {
                    uriBase = new URI(sScheme + "://" + (String)listHostHeader.get(0) + sDecodedBasePath);
                }
                Subject subject = null;
                String sAuth = null;
                if (DefaultHttpServer.this.isAuthMethodBasic()) {
                    sAuth = "BASIC";
                    subject = (Subject)exchange.getAttribute("__SUBJECT");
                } else if (DefaultHttpServer.this.isSecure() && DefaultHttpServer.this.isAuthMethodCert()) {
                    sAuth = "CLIENT_CERT";
                    SSLSession session = ((HttpsExchange)exchange).getSSLSession();
                    subject = DefaultHttpServer.this.getSubjectFromSession(session);
                }
                ContainerRequest request = new ContainerRequest(uriBase, uriBase.resolve(uriExchange), exchange.getRequestMethod(), (SecurityContext)new AbstractHttpServer.SimpleSecurityContext(sAuth, subject == null ? exchange.getPrincipal() : subject.getPrincipals().iterator().next(), DefaultHttpServer.this.isSecure()), (PropertiesDelegate)new MapPropertiesDelegate());
                request.setEntityStream(exchange.getRequestBody());
                request.getHeaders().putAll((Map)exchange.getRequestHeaders());
                responseWriter = new Writer(exchange);
                request.setWriter((ContainerResponseWriter)responseWriter);
                DefaultHttpServer.this.handleRequest(this.m_hApplication, request, subject);
            }
            catch (Exception e) {
                CacheFactory.log("Caught unhandled exception while processing an HTTP request: " + Base.printStackTrace(e));
                exchange.getResponseHeaders().clear();
                exchange.sendResponseHeaders(500, -1L);
                DefaultHttpServer.this.incrementErrors();
            }
            finally {
                if (responseWriter != null) {
                    responseWriter.commit();
                }
            }
            DefaultHttpServer.this.logRequestTime(ldtStart);
            DefaultHttpServer.this.logStatusCount(exchange.getResponseCode());
        }

        public ResourceConfig getConfiguration() {
            return this.m_hApplication.getConfiguration();
        }

        public ApplicationHandler getApplicationHandler() {
            return this.m_hApplication;
        }

        public void reload() {
            this.reload(this.getConfiguration());
        }

        public void reload(ResourceConfig config) {
            this.m_hApplication.onShutdown((Container)this);
            this.m_hApplication = new ApplicationHandler((Application)config);
            this.m_hApplication.onReload((Container)this);
            this.m_hApplication.onStartup((Container)this);
        }

        void onServerStart() {
            this.m_hApplication.onStartup((Container)this);
        }

        void onServerStop() {
            this.m_hApplication.onShutdown((Container)this);
        }

        private class Writer
        implements ContainerResponseWriter {
            final HttpExchange m_exchange;
            final AtomicBoolean m_closed;

            public Writer(HttpExchange exchange) {
                this.m_exchange = exchange;
                this.m_closed = new AtomicBoolean(false);
            }

            public OutputStream writeResponseStatusAndHeaders(long cbContent, ContainerResponse response) throws ContainerException {
                HttpExchange exchange = this.m_exchange;
                Headers headers = exchange.getResponseHeaders();
                for (Map.Entry entry : response.getStringHeaders().entrySet()) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (String o : (List)entry.getValue()) {
                        list.add(o);
                    }
                    headers.put((String)entry.getKey(), (List<String>)list);
                }
                try {
                    if (response.getStatus() == 204) {
                        exchange.sendResponseHeaders(response.getStatus(), -1L);
                    } else {
                        exchange.sendResponseHeaders(response.getStatus(), this.getResponseLength(cbContent));
                    }
                }
                catch (IOException e) {
                    throw new ContainerException("Error during writing out the response headers.", (Throwable)e);
                }
                return exchange.getResponseBody();
            }

            public void finish() throws IOException {
            }

            public boolean suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler hTimeout) {
                throw new UnsupportedOperationException("Method suspend is not support by the container.");
            }

            public void setSuspendTimeout(long timeout, TimeUnit timeUnit) throws IllegalStateException {
                throw new UnsupportedOperationException("Method setSuspendTimeout is not support by the container.");
            }

            public void failure(Throwable error) {
                try {
                    this.m_exchange.sendResponseHeaders(500, this.getResponseLength(0L));
                }
                catch (IOException e) {
                    CacheFactory.log("Unable to send a failure response: " + Base.printStackTrace(e), 2);
                }
                finally {
                    this.commit();
                    this.rethrow(error);
                }
            }

            public boolean enableResponseBuffering() {
                return true;
            }

            public void commit() {
                if (this.m_closed.compareAndSet(false, true)) {
                    this.m_exchange.close();
                }
            }

            private long getResponseLength(long cb) {
                return cb == 0L ? -1L : (cb < 0L ? 0L : cb);
            }

            private void rethrow(Throwable error) {
                if (error instanceof RuntimeException) {
                    throw (RuntimeException)error;
                }
                throw new ContainerException(error);
            }
        }
    }

    private class BasicAuthenticationHandler
    implements HttpHandler {
        protected final HttpHandler m_handler;

        public BasicAuthenticationHandler(HttpHandler handler) {
            this.m_handler = handler;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String sAuth = exchange.getRequestHeaders().getFirst("Authorization");
            Subject subject = DefaultHttpServer.this.authenticate(sAuth);
            if (subject == null) {
                exchange.getResponseHeaders().set("WWW-Authenticate", "Basic realm=\"Coherence REST\"");
                exchange.sendResponseHeaders(401, -1L);
            } else {
                exchange.setAttribute("__SUBJECT", subject);
                this.m_handler.handle(exchange);
            }
        }
    }
}

