/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.memcached;

import com.oracle.coherence.common.base.Continuation;
import com.tangosol.coherence.memcached.Request;
import com.tangosol.coherence.memcached.RequestHandler;
import com.tangosol.coherence.memcached.Response;
import com.tangosol.coherence.memcached.processor.AddReplaceProcessor;
import com.tangosol.coherence.memcached.processor.AppendPrependProcessor;
import com.tangosol.coherence.memcached.processor.DeleteProcessor;
import com.tangosol.coherence.memcached.processor.GetProcessor;
import com.tangosol.coherence.memcached.processor.IncrDecrProcessor;
import com.tangosol.coherence.memcached.processor.MemcachedAsyncProcessor;
import com.tangosol.coherence.memcached.processor.PutProcessor;
import com.tangosol.coherence.memcached.processor.TouchProcessor;
import com.tangosol.coherence.memcached.server.Connection;
import com.tangosol.coherence.memcached.server.DataHolder;
import com.tangosol.coherence.memcached.server.MemcachedHelper;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.net.Service;
import com.tangosol.net.Session;
import com.tangosol.net.cache.TypeAssertion;
import com.tangosol.net.security.IdentityAsserter;
import com.tangosol.net.security.UsernameAndPassword;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Executor;
import javax.security.auth.Subject;

public class DefaultRequestHandler
implements RequestHandler {
    protected final String f_sCacheName;
    protected NamedCache m_cache;
    protected final boolean f_fBinaryPassThru;
    protected final String f_sAuthMethod;
    protected final Service f_parentService;
    protected Subject m_subject;
    protected final IdentityAsserter f_identityAsserter;
    protected final Executor f_executor;
    protected final Connection.ConnectionFlowControl f_flowControl;
    protected MemcachedAsyncProcessor m_asyncProcessor;
    protected static final byte SEP = 0;
    protected static final int FLAG_SIZE = 4;
    protected static final String NONE_AUTH_METHOD = "NONE";
    protected static final String PLAIN_AUTH_METHOD = "PLAIN";

    public DefaultRequestHandler(String sCacheName, Service parentSvc, String sAuthMethod, boolean fBinaryPassThru, IdentityAsserter asserter, Executor executor, Connection.ConnectionFlowControl flowControl) {
        this.f_sCacheName = sCacheName;
        this.f_parentService = parentSvc;
        this.f_sAuthMethod = sAuthMethod.toUpperCase();
        this.f_fBinaryPassThru = fBinaryPassThru;
        this.f_identityAsserter = asserter;
        this.f_executor = executor;
        this.f_flowControl = flowControl;
        if (this.f_sAuthMethod.equals(NONE_AUTH_METHOD)) {
            this.ensureCache(null);
        }
    }

    @Override
    public Subject getSubject(Request request) {
        int nOpCode = request.getOpCode();
        if (this.f_sAuthMethod.equals(NONE_AUTH_METHOD) || nOpCode == 30 || nOpCode == 32 || nOpCode == 33) {
            return null;
        }
        if (this.m_subject == null) {
            throw new SecurityException("Null subject");
        }
        return this.m_subject;
    }

    @Override
    public void onGet(Request request, Response response) throws IOException {
        this.fireEP(request, response, new GetProcessor(this.f_fBinaryPassThru));
    }

    @Override
    public void onGetComplete(Request request, Response response, Object oReturn) throws IOException {
        int nResponseCode = this.getResponseCode(oReturn);
        response.setResponseCode(nResponseCode);
        if (nResponseCode == Response.ResponseCode.OK.getCode()) {
            DataHolder holder = this.toDataHolder(oReturn);
            ByteBuffer bufExtras = (ByteBuffer)ByteBuffer.allocate(4).clear().mark();
            bufExtras.putInt(holder.getFlag()).reset();
            response.setVersion(this.getVersion(holder)).setExtras(bufExtras).setValue(holder.getValue());
        }
    }

    @Override
    public void onSet(Request request, Response response) throws IOException {
        long lVersion = request.getVersion();
        DataInput inExtras = request.getExtras();
        int nFlag = inExtras.readInt();
        int nExpiry = MemcachedHelper.calculateExpiry(inExtras.readInt());
        this.fireEP(request, response, new PutProcessor(request.getValue(), nFlag, lVersion, nExpiry, this.f_fBinaryPassThru));
    }

    @Override
    public void onSetComplete(Request request, Response response, Object oReturn) throws IOException {
        response.setResponseCode(this.getResponseCode(oReturn)).setVersion(this.getVersion(oReturn));
    }

    @Override
    public void onAdd(Request request, Response response) throws IOException {
        this.addReplace(request, response, true);
    }

    @Override
    public void onAddComplete(Request request, Response response, Object oReturn) throws IOException {
        this.addReplaceComplete(request, response, oReturn);
    }

    @Override
    public void onReplace(Request request, Response response) throws IOException {
        this.addReplace(request, response, false);
    }

    @Override
    public void onReplaceComplete(Request request, Response response, Object oReturn) throws IOException {
        this.addReplaceComplete(request, response, oReturn);
    }

    @Override
    public void onDelete(Request request, Response response) throws IOException {
        this.fireEP(request, response, new DeleteProcessor());
    }

    @Override
    public void onDeleteComplete(Request request, Response response, Object oReturn) throws IOException {
        response.setResponseCode(this.getResponseCode(oReturn));
    }

    @Override
    public void onIncrement(Request request, Response response) throws IOException {
        this.incrDecr(request, response, true);
    }

    @Override
    public void onIncrementComplete(Request request, Response response, Object oReturn) throws IOException {
        this.incrDecrComplete(request, response, oReturn);
    }

    @Override
    public void onDecrement(Request request, Response response) throws IOException {
        this.incrDecr(request, response, false);
    }

    @Override
    public void onDecrementComplete(Request request, Response response, Object oReturn) throws IOException {
        this.incrDecrComplete(request, response, oReturn);
    }

    @Override
    public void onAppend(Request request, Response response) throws IOException {
        this.appendPrepend(request, response, true);
    }

    @Override
    public void onAppendComplete(Request request, Response response, Object oReturn) throws IOException {
        this.appendPrependComplete(request, response, oReturn);
    }

    @Override
    public void onPrepend(Request request, Response response) throws IOException {
        this.appendPrepend(request, response, false);
    }

    @Override
    public void onPrependComplete(Request request, Response response, Object oReturn) throws IOException {
        this.appendPrependComplete(request, response, oReturn);
    }

    @Override
    public void onFlush(Request request, Response response) throws IOException {
        DataInput extras = request.getExtras();
        int nExpiry = extras == null ? 0 : MemcachedHelper.calculateExpiry(extras.readInt());
        AbstractProcessor ep = nExpiry == 0 ? new DeleteProcessor() : new TouchProcessor(nExpiry, true, this.f_fBinaryPassThru);
        this.getCache().invokeAll((Filter)null, new MemcachedAsyncProcessor(this, request, response, ep));
    }

    @Override
    public void onFlushComplete(Request request, Response response, Object oReturn) throws IOException {
        response.setResponseCode(Response.ResponseCode.OK.getCode());
    }

    @Override
    public void onTouch(Request request, Response response) throws IOException {
        DataInput extras = request.getExtras();
        int nExpiry = extras == null ? 0 : MemcachedHelper.calculateExpiry(extras.readInt());
        this.fireEP(request, response, new TouchProcessor(nExpiry, true, this.f_fBinaryPassThru));
    }

    @Override
    public void onTouchComplete(Request request, Response response, Object oReturn) throws IOException {
        response.setResponseCode(this.getResponseCode(oReturn));
    }

    @Override
    public void onGAT(Request request, Response response) throws IOException {
        DataInput inExtras = request.getExtras();
        int nExpiry = MemcachedHelper.calculateExpiry(inExtras.readInt());
        this.fireEP(request, response, new TouchProcessor(nExpiry, false, this.f_fBinaryPassThru));
    }

    @Override
    public void onGATComplete(Request request, Response response, Object oReturn) throws IOException {
        int nResponseCode = this.getResponseCode(oReturn);
        response.setResponseCode(nResponseCode);
        if (nResponseCode == Response.ResponseCode.OK.getCode()) {
            DataHolder holder = this.toDataHolder(oReturn);
            response.setVersion(this.getVersion(holder));
            response.setValue(holder.getValue());
        }
    }

    @Override
    public void onSASLList(Request request, Response response) throws IOException {
        response.setResponseCode(Response.ResponseCode.OK.getCode()).setValue(PLAIN_AUTH_METHOD.getBytes());
    }

    @Override
    public void onSASLAuth(Request request, Response response) throws IOException {
        String sKey = request.getKey();
        short nResponseCode = Response.ResponseCode.OK.getCode();
        if (this.f_sAuthMethod.equals(NONE_AUTH_METHOD)) {
            nResponseCode = Response.ResponseCode.UNKNOWN.getCode();
        } else if (this.f_sAuthMethod.equals(PLAIN_AUTH_METHOD) && sKey.equals(PLAIN_AUTH_METHOD)) {
            try {
                this.m_subject = this.authenticate(request.getValue());
                this.ensureCache(this.m_subject);
            }
            catch (Throwable thr) {
                CacheFactory.log("Memcached authentication failure. " + thr, 1);
                nResponseCode = Response.ResponseCode.AUTH_ERROR.getCode();
            }
        } else {
            nResponseCode = Response.ResponseCode.AUTH_ERROR.getCode();
        }
        response.setResponseCode(nResponseCode);
    }

    @Override
    public void onSASLAuthStep(Request request, Response response) throws IOException {
        response.setResponseCode(Response.ResponseCode.UNKNOWN.getCode());
    }

    @Override
    public void flush() {
        if (this.m_asyncProcessor != null) {
            this.m_asyncProcessor.flush();
        }
    }

    @Override
    public boolean checkBacklog(Continuation<Void> backlogEndedContinuation) {
        MemcachedAsyncProcessor proc = this.m_asyncProcessor;
        return proc != null && proc.checkBacklog(backlogEndedContinuation);
    }

    protected void addReplace(Request request, Response response, boolean fInsert) throws IOException {
        long lVersion = request.getVersion();
        DataInput inExtras = request.getExtras();
        int nFlag = inExtras.readInt();
        int nExpiry = MemcachedHelper.calculateExpiry(inExtras.readInt());
        this.fireEP(request, response, new AddReplaceProcessor(request.getValue(), nFlag, lVersion, nExpiry, fInsert, this.f_fBinaryPassThru));
    }

    protected void addReplaceComplete(Request request, Response response, Object oReturn) throws IOException {
        response.setResponseCode(this.getResponseCode(oReturn)).setVersion(this.getVersion(oReturn));
    }

    protected void incrDecr(Request request, Response response, boolean fIncr) throws IOException {
        long lVersion = request.getVersion();
        DataInput inExtras = request.getExtras();
        long lIncr = inExtras.readLong();
        long lInitial = inExtras.readLong();
        int nExpiry = MemcachedHelper.calculateExpiry(inExtras.readInt());
        this.fireEP(request, response, new IncrDecrProcessor(lInitial, lIncr, fIncr, lVersion, nExpiry, this.f_fBinaryPassThru));
    }

    protected void incrDecrComplete(Request request, Response response, Object oReturn) throws IOException {
        int nResponseCode = this.getResponseCode(oReturn);
        response.setResponseCode(nResponseCode);
        if (nResponseCode == Response.ResponseCode.OK.getCode()) {
            DataHolder holder = this.toDataHolder(oReturn);
            Long lValue = IncrDecrProcessor.getLong(holder.getValue());
            ByteArrayWriteBuffer buf = new ByteArrayWriteBuffer(8);
            buf.getBufferOutput().writeLong(lValue);
            response.setValue(buf.toByteArray()).setVersion(this.getVersion(holder));
        }
    }

    protected void appendPrepend(Request request, Response response, boolean fAppend) throws IOException {
        long lVersion = request.getVersion();
        this.fireEP(request, response, new AppendPrependProcessor(request.getValue(), lVersion, fAppend, this.f_fBinaryPassThru));
    }

    protected void appendPrependComplete(Request request, Response response, Object oReturn) throws IOException {
        int nResponseCode = this.getResponseCode(oReturn);
        response.setResponseCode(nResponseCode).setVersion(this.getVersion(oReturn));
    }

    protected int getResponseCode(Object oValue) {
        if (oValue instanceof Response.ResponseCode) {
            return ((Response.ResponseCode)((Object)oValue)).getCode();
        }
        return Response.ResponseCode.OK.getCode();
    }

    protected long getVersion(Object oValue) {
        long lVersion = 0L;
        if (oValue instanceof DataHolder) {
            lVersion = ((DataHolder)oValue).getVersion();
        } else if (oValue instanceof Long) {
            lVersion = (Long)oValue;
        }
        return lVersion;
    }

    protected DataHolder toDataHolder(Object obj) {
        if (obj instanceof DataHolder) {
            return (DataHolder)obj;
        }
        throw new IllegalArgumentException("Cannot convert " + obj + " to DataHolder");
    }

    protected Subject authenticate(byte[] abPayload) {
        String sPayload = new String(abPayload);
        int of1 = sPayload.indexOf(0);
        int of2 = sPayload.indexOf(0, of1 + 1);
        String sUser = sPayload.substring(of1 + 1, of2);
        String sPwd = sPayload.substring(of2 + 1);
        return this.f_identityAsserter.assertIdentity(new UsernameAndPassword(sUser, sPwd), this.f_parentService);
    }

    protected void ensureCache(final Subject subject) {
        this.f_flowControl.pauseReads();
        this.f_executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("@@@@ Requesting Memcached Cache " + DefaultRequestHandler.this.f_sCacheName + " using subject " + subject);
                    if (subject == null) {
                        System.out.println("@@@@ No Subject Provided");
                        if (DefaultRequestHandler.this.f_parentService instanceof Session) {
                            System.out.println("@@@@ Using Session " + DefaultRequestHandler.this.f_parentService + " class " + DefaultRequestHandler.this.f_parentService.getClass());
                            DefaultRequestHandler.this.m_cache = ((Session)((Object)DefaultRequestHandler.this.f_parentService)).getCache(DefaultRequestHandler.this.f_sCacheName, TypeAssertion.withoutTypeChecking());
                        } else {
                            System.out.println("@@@@ Using Cache Factory");
                            DefaultRequestHandler.this.m_cache = CacheFactory.getCache(DefaultRequestHandler.this.f_sCacheName, TypeAssertion.withoutTypeChecking());
                        }
                    } else {
                        System.out.println("@@@@ Using Subject " + subject);
                        DefaultRequestHandler.this.m_cache = Subject.doAs(subject, new PrivilegedExceptionAction<NamedCache>(){

                            @Override
                            public NamedCache run() throws IOException {
                                return DefaultRequestHandler.this.f_parentService instanceof Session ? ((Session)((Object)DefaultRequestHandler.this.f_parentService)).getCache(DefaultRequestHandler.this.f_sCacheName, TypeAssertion.withoutTypeChecking()) : CacheFactory.getCache(DefaultRequestHandler.this.f_sCacheName, TypeAssertion.withoutTypeChecking());
                            }
                        });
                    }
                    System.out.println("@@@@ Memcached Cache = " + DefaultRequestHandler.this.m_cache);
                }
                catch (Throwable thr) {
                    CacheFactory.log("Memcached adapter failed to get cache " + DefaultRequestHandler.this.f_sCacheName + ": " + Base.printStackTrace(thr), 1);
                }
                finally {
                    DefaultRequestHandler.this.f_flowControl.resumeReads();
                }
            }
        });
    }

    protected void fireEP(Request request, Response response, InvocableMap.EntryProcessor ep) {
        MemcachedAsyncProcessor asyncProcessor = new MemcachedAsyncProcessor(this, request, response, ep);
        this.getCache().invoke(request.getKey(), asyncProcessor);
        this.m_asyncProcessor = asyncProcessor;
    }

    protected NamedCache getCache() {
        if (this.m_cache == null) {
            throw new RuntimeException("Null cache");
        }
        return this.m_cache;
    }
}

