/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.memcached.processor;

import com.tangosol.coherence.memcached.Response;
import com.tangosol.coherence.memcached.server.MemcachedHelper;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class GetProcessor
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    protected boolean m_fBinaryPassThru;

    public GetProcessor() {
    }

    public GetProcessor(boolean fBinaryPassThru) {
        this.m_fBinaryPassThru = fBinaryPassThru;
    }

    @Override
    public Object process(InvocableMap.Entry entry) {
        BinaryEntry binaryEntry = MemcachedHelper.getBinaryEntry(entry);
        Binary binValue = binaryEntry.getBinaryValue();
        if (binValue == null) {
            return Response.ResponseCode.KEYNF;
        }
        BackingMapManagerContext mgrCtx = binaryEntry.getBackingMapContext().getManagerContext();
        return MemcachedHelper.convertToDataHolder(binValue, mgrCtx, this.m_fBinaryPassThru);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_fBinaryPassThru = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeBoolean(this.m_fBinaryPassThru);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_fBinaryPassThru = in.readBoolean(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeBoolean(0, this.m_fBinaryPassThru);
    }
}

