/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.memcached.server;

import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.internal.net.socketbus.SharedBuffer;
import com.oracle.coherence.common.io.BufferManager;
import com.oracle.coherence.common.io.BufferSequence;
import com.tangosol.coherence.memcached.Request;
import com.tangosol.coherence.memcached.Response;
import com.tangosol.coherence.memcached.server.Connection;
import com.tangosol.coherence.memcached.server.DisposableReadBuffer;
import com.tangosol.coherence.memcached.server.MemcachedHelper;
import com.tangosol.coherence.memcached.server.ResponseQueue;
import com.tangosol.internal.io.BufferSequenceWriteBufferPool;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.Base;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class BinaryConnection
implements Connection,
SharedBuffer.Disposer {
    protected Connection.ConnectionFlowControl m_flowControl;
    protected final BufferManager m_bufferManager;
    protected final SocketChannel m_channel;
    protected final int m_nConnId;
    protected boolean m_fHeader = true;
    protected BinaryHeader m_requestHeader;
    protected final ConcurrentLinkedQueue<BinaryResponse> f_delegatedWrites = new ConcurrentLinkedQueue();
    protected final ResponseQueue f_queueResponses = new ResponseQueue();
    protected long m_cbRequired = 24L;
    protected long m_cbReadable;
    protected int m_ofReadable;
    protected long m_cbWritable;
    protected int m_ofWritable;
    protected int m_cBufferWritable;
    protected SharedBuffer[] m_aSharedBuffer = new SharedBuffer[2];
    protected long m_cRequests;
    protected static final int HEADER_LEN = 24;
    protected static final int BUF_SIZE = 16384;

    public BinaryConnection(BufferManager bufMgr, SocketChannel channel, int nConnId) {
        this.m_bufferManager = bufMgr;
        this.m_channel = channel;
        this.m_nConnId = nConnId;
    }

    @Override
    public void setFlowControl(Connection.ConnectionFlowControl flowCtrl) {
        this.m_flowControl = flowCtrl;
    }

    @Override
    public SocketChannel getChannel() {
        return this.m_channel;
    }

    @Override
    public int getId() {
        return this.m_nConnId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Request> read() throws IOException {
        List<Request> list;
        int cBuffer;
        long cbAlloc = this.m_cbRequired - this.m_cbReadable;
        SharedBuffer[] aSharedBuffer = cbAlloc > 0L ? this.ensureCapacity(cbAlloc) : this.m_aSharedBuffer;
        ByteBuffer[] aBuffer = this.getBuffers(aSharedBuffer);
        int of = this.m_ofWritable;
        long cb = this.read(aBuffer, of, cBuffer);
        if (cb <= 0L) return Collections.emptyList();
        for (cBuffer = this.m_cBufferWritable; cBuffer > 0 && !aBuffer[of].hasRemaining(); --cBuffer) {
            aBuffer[of].reset();
            ++of;
        }
        this.m_ofWritable = of;
        this.m_cBufferWritable = cBuffer;
        this.m_cbWritable -= cb;
        long cbReady = this.m_cbReadable += cb;
        if (cbReady < this.m_cbRequired) return Collections.emptyList();
        if (cBuffer <= 0 || aBuffer[of].position() <= 0) return this.onReady(aBuffer);
        ByteBuffer buffLast = aBuffer[of];
        int iPosWrite = buffLast.position();
        try {
            buffLast.limit(iPosWrite).reset();
            list = this.onReady(aBuffer);
            buffLast.mark();
        }
        catch (Throwable throwable) {
            try {
                buffLast.mark();
                buffLast.limit(buffLast.capacity()).position(iPosWrite);
                throw throwable;
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Throwable thr) {
                CacheFactory.log(Base.printStackTrace(thr), 1);
                throw Base.ensureRuntimeException(thr);
            }
        }
        buffLast.limit(buffLast.capacity()).position(iPosWrite);
        return list;
    }

    @Override
    public int write() throws IOException {
        try {
            BinaryResponse response;
            Iterator<BinaryResponse> itr = this.f_delegatedWrites.iterator();
            while (itr.hasNext() && (response = itr.next()).write()) {
                itr.remove();
            }
            return itr.hasNext() ? 4 : 0;
        }
        catch (Throwable thr) {
            throw Base.ensureRuntimeException(thr);
        }
    }

    @Override
    public void dispose(ByteBuffer buffer) {
        this.m_bufferManager.release(buffer);
    }

    protected List<Request> onReady(ByteBuffer[] aBuffer) throws IOException {
        long cbReadable;
        ArrayList<Request> listRequest = new ArrayList<Request>();
        SharedBuffer[] aSharedBuffer = this.m_aSharedBuffer;
        int ofReadable = this.m_ofReadable;
        long cbRequired = this.m_cbRequired;
        for (cbReadable = this.m_cbReadable; cbReadable >= cbRequired; cbReadable -= cbRequired) {
            DisposableReadBuffer readBuffer = null;
            if ((long)aBuffer[ofReadable].remaining() >= cbRequired) {
                ByteBuffer buf = aBuffer[ofReadable];
                int nLimit = buf.limit();
                SharedBuffer.Segment segment = aSharedBuffer[ofReadable].getSegment(buf.position(), (int)cbRequired);
                readBuffer = new DisposableReadBuffer(new SharedBuffer.Segment[]{segment});
                buf.position(buf.position() + (int)cbRequired).limit(nLimit);
            } else {
                int cbAvailable;
                ArrayList<SharedBuffer.Segment> listSegments = new ArrayList<SharedBuffer.Segment>();
                for (long cbTmpRequired = cbRequired; cbTmpRequired > 0L; cbTmpRequired -= (long)cbAvailable) {
                    ByteBuffer buf = aBuffer[ofReadable];
                    int nLimit = buf.limit();
                    cbAvailable = buf.remaining();
                    if (cbTmpRequired > (long)cbAvailable) {
                        listSegments.add(aSharedBuffer[ofReadable].getSegment());
                        ++ofReadable;
                        continue;
                    }
                    listSegments.add(aSharedBuffer[ofReadable].getSegment(buf.position(), (int)cbTmpRequired));
                    buf.position(buf.position() + (int)cbTmpRequired).limit(nLimit);
                }
                SharedBuffer.Segment[] aSegment = listSegments.toArray(new SharedBuffer.Segment[listSegments.size()]);
                readBuffer = new DisposableReadBuffer(aSegment);
            }
            if (this.m_fHeader) {
                BinaryHeader hdr = this.m_requestHeader = new BinaryHeader(readBuffer);
                cbRequired = Math.abs(hdr.getBodyLength());
                this.m_fHeader = false;
                continue;
            }
            BinaryRequest request = new BinaryRequest(this.m_requestHeader, readBuffer, this.m_bufferManager, this);
            listRequest.add(request);
            this.f_queueResponses.add(request.getResponse());
            cbRequired = 24L;
            this.m_fHeader = true;
        }
        this.m_cbRequired = cbRequired;
        if (ofReadable > 0) {
            int cBuffers = aBuffer.length;
            for (int i = 0; i < cBuffers; ++i) {
                if (i < ofReadable) {
                    aSharedBuffer[i].detach();
                } else {
                    aSharedBuffer[i - ofReadable] = aSharedBuffer[i];
                }
                aSharedBuffer[i] = null;
            }
        }
        this.m_ofWritable -= ofReadable;
        this.m_ofReadable = 0;
        this.m_cbReadable = cbReadable;
        return listRequest;
    }

    protected SharedBuffer[] ensureCapacity(long cbReqd) {
        SharedBuffer[] aSharedBuffer = this.m_aSharedBuffer;
        int ofReadable = this.m_ofReadable;
        int ofWritable = this.m_ofWritable;
        long cbWritable = this.m_cbWritable;
        int cBufferWritable = this.m_cBufferWritable;
        int cBuffer = aSharedBuffer.length;
        long cbAlloc = cbReqd - cbWritable;
        if (cbAlloc > 0L) {
            int nBufNeeded = (int)(cbReqd / 16384L) + 1;
            int nBufAvailable = cBuffer - ofWritable;
            if (nBufNeeded > nBufAvailable) {
                SharedBuffer[] aBufferNew = new SharedBuffer[cBuffer * 2];
                System.arraycopy(aSharedBuffer, 0, aBufferNew, 0, cBuffer);
                aSharedBuffer = aBufferNew;
                cBuffer = aSharedBuffer.length;
            }
            BufferManager manager = this.m_bufferManager;
            for (int i = ofWritable; i < cBuffer && aSharedBuffer[i] == null && cbWritable < cbReqd; ++i) {
                ByteBuffer buff = manager.acquirePref(Math.min(Integer.MAX_VALUE, 16384));
                buff.clear().mark();
                int cbBuff = buff.remaining();
                cbAlloc -= Math.min((long)cbBuff, cbAlloc);
                cbWritable += (long)cbBuff;
                ++cBufferWritable;
                aSharedBuffer[i] = new SharedBuffer(buff, this).attach();
            }
        }
        this.m_aSharedBuffer = aSharedBuffer;
        this.m_ofReadable = ofReadable;
        this.m_ofWritable = ofWritable;
        this.m_cbWritable = cbWritable;
        this.m_cBufferWritable = cBufferWritable;
        return aSharedBuffer;
    }

    public void writeResponse(BinaryResponse response) throws IOException {
        if (this.f_delegatedWrites.isEmpty() && response.write()) {
            return;
        }
        this.f_delegatedWrites.add(response);
    }

    protected long read(ByteBuffer[] aBuf, int offset, int length) throws IOException {
        long cb = this.m_channel.read(aBuf, offset, length);
        if (cb < 0L) {
            throw new IOException("InputShutdown during reading");
        }
        return cb;
    }

    protected ByteBuffer[] getBuffers(SharedBuffer[] aSharedBuffer) {
        ArrayList<ByteBuffer> listBuf = new ArrayList<ByteBuffer>();
        for (SharedBuffer sBuf : aSharedBuffer) {
            if (sBuf == null) break;
            listBuf.add(sBuf.get());
        }
        return listBuf.toArray(new ByteBuffer[listBuf.size()]);
    }

    protected void checkWrites() throws IOException {
        if (!this.f_delegatedWrites.isEmpty()) {
            this.m_flowControl.resumeWrites();
        }
    }

    protected static class BinaryResponse
    implements Response,
    Disposable {
        protected BufferManager m_bufferManager;
        protected BinaryConnection m_conn;
        protected BinaryRequest m_request;
        protected int m_nResponseCode;
        protected long m_lVersion;
        protected String m_sKey;
        protected byte[] m_value;
        protected ByteBuffer m_extras;
        protected ByteBuffer[] m_aBuffers;
        protected int m_nOffset;
        protected int m_cBuffers;
        protected volatile boolean m_fDeferred = false;
        protected boolean m_fDisposeOnly;
        protected volatile BinaryResponse m_next;

        public BinaryResponse(BufferManager bufMgr, BinaryConnection conn, BinaryRequest request) {
            this.m_bufferManager = bufMgr;
            this.m_conn = conn;
            this.m_request = request;
        }

        @Override
        public BinaryResponse setResponseCode(int nResponseCode) {
            this.m_nResponseCode = nResponseCode;
            return this;
        }

        @Override
        public int getResponseCode() {
            return this.m_nResponseCode;
        }

        @Override
        public BinaryResponse setVersion(long lVersion) {
            this.m_lVersion = lVersion;
            return this;
        }

        @Override
        public BinaryResponse setKey(String sKey) {
            this.m_sKey = sKey;
            return this;
        }

        @Override
        public BinaryResponse setValue(byte[] value) {
            this.m_value = value;
            return this;
        }

        @Override
        public BinaryResponse setExtras(ByteBuffer extras) {
            this.m_extras = extras;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush(boolean fDispose) {
            boolean fClose = false;
            try {
                BinaryRequest request = this.m_request;
                this.m_fDisposeOnly = fDispose;
                this.m_aBuffers = fDispose ? null : this.getBuffers(request.getOpCode() == 16);
                BinaryResponse response = this;
                BinaryConnection conn = this.m_conn;
                ResponseQueue queue = conn.f_queueResponses;
                boolean fFlush = queue.isFlushable(response, true);
                do {
                    if (fFlush) {
                        if (response.m_fDisposeOnly) {
                            response.dispose();
                        } else {
                            this.m_conn.writeResponse(response);
                        }
                        response = queue.removeAndGetNext(response);
                        continue;
                    }
                    queue.markDeferred(response);
                } while (fFlush = queue.isFlushable(response, false));
                conn.checkWrites();
            }
            catch (ClosedChannelException request) {
            }
            catch (IOException ioe) {
                fClose = true;
            }
            catch (Throwable thr) {
                fClose = true;
                CacheFactory.log("Exception while writing response: " + Base.printStackTrace(thr), 1);
            }
            finally {
                if (fClose) {
                    try {
                        this.m_conn.getChannel().close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }

        public boolean write() throws IOException {
            SocketChannel channel = this.m_conn.getChannel();
            ByteBuffer[] abuffers = this.m_aBuffers;
            int offset = this.m_nOffset;
            int cBuffers = this.m_cBuffers;
            int nOpCode = this.m_request.getOpCode();
            if (nOpCode == 23) {
                channel.close();
                return true;
            }
            while (cBuffers > 0) {
                if (channel.write(abuffers, offset, cBuffers) > 0L) {
                    for (int i = offset; i < abuffers.length && !abuffers[i].hasRemaining(); ++i) {
                        ++offset;
                        --cBuffers;
                    }
                    continue;
                }
                this.m_nOffset = offset;
                this.m_cBuffers = cBuffers;
                return false;
            }
            if (nOpCode == 7) {
                channel.close();
            }
            this.dispose();
            return true;
        }

        @Override
        public void dispose() {
            this.m_request.dispose();
        }

        protected ByteBuffer[] getBuffers(boolean fAppendEmptyPkt) throws IOException {
            BufferSequenceWriteBufferPool wbPool = new BufferSequenceWriteBufferPool(this.m_bufferManager);
            WriteBuffer.BufferOutput bufOutput = new MultiBufferWriteBuffer(wbPool).getBufferOutput();
            bufOutput.write(-127);
            bufOutput.write((byte)this.m_request.getOpCode());
            int keyLength = (short)(this.m_sKey == null ? 0 : (short)this.m_sKey.length());
            bufOutput.writeShort(keyLength);
            int extrasLength = this.m_extras == null ? 0 : this.m_extras.remaining();
            bufOutput.writeByte((byte)extrasLength);
            bufOutput.writeByte(0);
            bufOutput.writeShort(this.m_nResponseCode);
            int dataLength = this.m_value != null ? this.m_value.length : 0;
            bufOutput.writeInt(dataLength + keyLength + extrasLength);
            bufOutput.writeInt(this.m_request.header().getOpaqueValue());
            bufOutput.writeLong(this.m_lVersion);
            BufferSequence headerSeq = wbPool.toBufferSequence();
            ByteBuffer[] aBufEmpty = null;
            if (fAppendEmptyPkt) {
                BinaryResponse emptyResponse = new BinaryResponse(this.m_bufferManager, this.m_conn, this.m_request);
                aBufEmpty = emptyResponse.getBuffers(false);
            }
            this.m_cBuffers = headerSeq.getBufferCount() + (this.m_extras != null ? 1 : 0) + (this.m_sKey != null ? 1 : 0) + (this.m_value != null ? 1 : 0) + (fAppendEmptyPkt ? aBufEmpty.length : 0);
            ByteBuffer[] buffers = new ByteBuffer[this.m_cBuffers];
            ByteBuffer[] aHdr = headerSeq.getBuffers();
            for (int i = 0; i < aHdr.length; ++i) {
                buffers[i] = aHdr[i];
            }
            if (this.m_extras != null) {
                buffers[i++] = this.m_extras;
            }
            if (this.m_sKey != null) {
                buffers[i++] = ByteBuffer.wrap(this.m_sKey.getBytes("utf-8"));
            }
            if (this.m_value != null) {
                buffers[i++] = ByteBuffer.wrap(this.m_value);
            }
            if (fAppendEmptyPkt) {
                for (int j = 0; j < aBufEmpty.length; ++j) {
                    buffers[i++] = aBufEmpty[j];
                }
            }
            return buffers;
        }
    }

    protected static class BinaryRequest
    implements Request {
        protected BinaryHeader m_header;
        protected BinaryResponse m_response;
        protected DisposableReadBuffer m_bufPayLoad;
        protected BufferManager m_bufferManager;
        protected BinaryConnection m_conn;
        protected volatile long m_lId;

        public BinaryRequest(BinaryHeader header, DisposableReadBuffer readBuffer, BufferManager bufMgr, BinaryConnection conn) {
            this.m_header = header;
            this.m_bufferManager = bufMgr;
            this.m_conn = conn;
            this.m_bufPayLoad = readBuffer;
            this.m_lId = conn.m_cRequests++;
            this.m_response = new BinaryResponse(this.m_bufferManager, this.m_conn, this);
        }

        @Override
        public int getOpCode() {
            return this.header().m_nOpCode;
        }

        public BinaryHeader header() {
            return this.m_header;
        }

        @Override
        public DataInput getExtras() {
            BinaryHeader hdr = this.m_header;
            DisposableReadBuffer readBuffer = this.m_bufPayLoad;
            int nLen = hdr.getExtrasLength();
            return nLen > 0 ? readBuffer.getReadBuffer(0, nLen).getBufferInput() : null;
        }

        @Override
        public String getKey() {
            BinaryHeader hdr = this.m_header;
            DisposableReadBuffer readBuffer = this.m_bufPayLoad;
            return MemcachedHelper.getString(readBuffer.getReadBuffer(hdr.getKeyOffset(), hdr.getKeyLength()).toByteArray());
        }

        @Override
        public byte[] getValue() {
            BinaryHeader hdr = this.m_header;
            DisposableReadBuffer readBuffer = this.m_bufPayLoad;
            return readBuffer.getReadBuffer(hdr.getValueOffset(), hdr.getValueLength()).toByteArray();
        }

        @Override
        public long getVersion() {
            return this.header().getVersion();
        }

        @Override
        public BinaryResponse getResponse() {
            return this.m_response;
        }

        @Override
        public Object getAssociatedKey() {
            return this.m_conn.getId();
        }

        @Override
        public void dispose() {
            this.header().m_readBuffer.dispose();
            this.m_bufPayLoad.dispose();
        }
    }

    protected static class BinaryHeader {
        protected final int m_nOpCode;
        protected final short m_sKeyLength;
        protected final int m_nExtraLength;
        protected final int m_nDataType;
        protected final short m_sReserved;
        protected final int m_nBodyLength;
        protected final int m_nOpaque;
        protected final long m_lVersion;
        protected final DisposableReadBuffer m_readBuffer;

        public BinaryHeader(DisposableReadBuffer readBuffer) throws IOException {
            ReadBuffer.BufferInput bufInput = readBuffer.getBufferInput();
            this.m_readBuffer = readBuffer;
            int magic = bufInput.readUnsignedByte();
            if (magic != 128) {
                throw new IOException("invalid magic byte - " + magic);
            }
            this.m_nOpCode = bufInput.readUnsignedByte();
            this.m_sKeyLength = bufInput.readShort();
            this.m_nExtraLength = bufInput.readUnsignedByte();
            this.m_nDataType = bufInput.readUnsignedByte();
            this.m_sReserved = bufInput.readShort();
            this.m_nBodyLength = bufInput.readInt();
            this.m_nOpaque = bufInput.readInt();
            this.m_lVersion = bufInput.readLong();
        }

        public int getExtrasLength() {
            return this.m_nExtraLength;
        }

        public int getBodyLength() {
            return this.m_nBodyLength;
        }

        public int getKeyOffset() {
            return this.m_nExtraLength;
        }

        public int getKeyLength() {
            return this.m_sKeyLength;
        }

        public int getValueOffset() {
            return this.m_nExtraLength + this.m_sKeyLength;
        }

        public int getValueLength() {
            return this.m_nBodyLength - this.m_sKeyLength - this.m_nExtraLength;
        }

        public int getOpaqueValue() {
            return this.m_nOpaque;
        }

        public long getVersion() {
            return this.m_lVersion;
        }
    }
}

