/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.memcached.server;

import com.tangosol.coherence.memcached.server.BinaryConnection;

public class ResponseQueue {
    protected volatile BinaryConnection.BinaryResponse m_head;
    protected volatile BinaryConnection.BinaryResponse m_tail;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BinaryConnection.BinaryResponse response) {
        BinaryConnection.BinaryResponse oldTail = this.m_tail;
        if (oldTail != null) {
            oldTail.m_next = response;
        }
        this.m_tail = response;
        BinaryConnection.BinaryResponse head = this.m_head;
        if (head == null) {
            this.m_head = response;
            if (oldTail != null) {
                oldTail.m_next = null;
            }
        } else if (head == oldTail) {
            ResponseQueue responseQueue = this;
            synchronized (responseQueue) {
                if (this.m_head == null) {
                    this.m_head = response;
                    oldTail.m_next = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFlushable(BinaryConnection.BinaryResponse response, boolean fOwner) {
        if (response == null) {
            return false;
        }
        if (fOwner) {
            return this.m_head == response;
        }
        BinaryConnection.BinaryResponse binaryResponse = response;
        synchronized (binaryResponse) {
            if (this.m_head == response && response.m_fDeferred) {
                response.m_fDeferred = false;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDeferred(BinaryConnection.BinaryResponse response) {
        BinaryConnection.BinaryResponse binaryResponse = response;
        synchronized (binaryResponse) {
            response.m_fDeferred = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryConnection.BinaryResponse removeAndGetNext(BinaryConnection.BinaryResponse response) {
        BinaryConnection.BinaryResponse nextResponse = response.m_next;
        if (nextResponse == null) {
            ResponseQueue responseQueue = this;
            synchronized (responseQueue) {
                nextResponse = response.m_next;
                response.m_next = null;
                this.m_head = nextResponse;
            }
        } else {
            response.m_next = null;
            this.m_head = nextResponse;
        }
        return nextResponse;
    }

    public int size() {
        BinaryConnection.BinaryResponse head = this.m_head;
        BinaryConnection.BinaryResponse tail = this.m_tail;
        if (head != null && tail != null) {
            return (int)(this.m_tail.m_request.m_lId - head.m_request.m_lId + 1L);
        }
        return 0;
    }
}

