/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.memcached.server;

import com.tangosol.coherence.memcached.Request;
import com.tangosol.coherence.memcached.RequestHandler;
import com.tangosol.coherence.memcached.Response;
import com.tangosol.coherence.memcached.server.BinaryConnection;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.cache.KeyAssociation;
import com.tangosol.util.Base;
import java.io.IOException;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;

public class Task
implements Runnable,
KeyAssociation {
    protected final Request f_request;
    protected final RequestHandler f_handler;

    public Task(Request request, RequestHandler handler) {
        this.f_request = request;
        this.f_handler = handler;
    }

    @Override
    public Object getAssociatedKey() {
        return this.f_request.getAssociatedKey();
    }

    @Override
    public void run() {
        final Request request = this.f_request;
        final Response response = request.getResponse();
        Subject subject = this.f_handler.getSubject(request);
        if (subject == null) {
            this.handleRequest(request, response);
        } else {
            Subject.doAs(subject, new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Task.this.handleRequest(request, response);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleRequest(Request request, Response response) {
        boolean fFlush = false;
        try {
            switch (request.getOpCode()) {
                case 0: {
                    this.f_handler.onGet(request, response);
                    return;
                }
                case 1: {
                    this.f_handler.onSet(request, response);
                    return;
                }
                case 2: {
                    this.f_handler.onAdd(request, response);
                    return;
                }
                case 3: {
                    this.f_handler.onReplace(request, response);
                    return;
                }
                case 4: {
                    this.f_handler.onDelete(request, response);
                    return;
                }
                case 5: {
                    this.f_handler.onIncrement(request, response);
                    return;
                }
                case 6: {
                    this.f_handler.onDecrement(request, response);
                    return;
                }
                case 7: {
                    fFlush = true;
                    response.setResponseCode(Response.ResponseCode.OK.getCode());
                    return;
                }
                case 8: {
                    this.f_handler.onFlush(request, response);
                    return;
                }
                case 9: {
                    this.f_handler.onGet(request, response);
                    return;
                }
                case 10: {
                    fFlush = true;
                    response.setResponseCode(Response.ResponseCode.OK.getCode());
                    return;
                }
                case 11: {
                    fFlush = true;
                    this.version(request, response);
                    return;
                }
                case 12: {
                    response.setKey(request.getKey());
                    this.f_handler.onGet(request, response);
                    return;
                }
                case 13: {
                    response.setKey(request.getKey());
                    this.f_handler.onGet(request, response);
                    return;
                }
                case 14: {
                    this.f_handler.onAppend(request, response);
                    return;
                }
                case 15: {
                    this.f_handler.onPrepend(request, response);
                    return;
                }
                case 16: {
                    fFlush = true;
                    this.stat(request, response);
                    return;
                }
                case 17: {
                    this.f_handler.onSet(request, response);
                    return;
                }
                case 18: {
                    this.f_handler.onAdd(request, response);
                    return;
                }
                case 19: {
                    this.f_handler.onReplace(request, response);
                    return;
                }
                case 20: {
                    this.f_handler.onDelete(request, response);
                    return;
                }
                case 21: {
                    this.f_handler.onIncrement(request, response);
                    return;
                }
                case 22: {
                    this.f_handler.onDecrement(request, response);
                    return;
                }
                case 23: {
                    fFlush = true;
                    response.setResponseCode(Response.ResponseCode.OK.getCode());
                    return;
                }
                case 24: {
                    this.f_handler.onFlush(request, response);
                    return;
                }
                case 25: {
                    this.f_handler.onAppend(request, response);
                    return;
                }
                case 26: {
                    this.f_handler.onPrepend(request, response);
                    return;
                }
                case 28: {
                    this.f_handler.onTouch(request, response);
                    return;
                }
                case 29: {
                    this.f_handler.onGAT(request, response);
                    return;
                }
                case 30: {
                    this.f_handler.onGAT(request, response);
                    return;
                }
                case 32: {
                    fFlush = true;
                    this.f_handler.onSASLList(request, response);
                    return;
                }
                case 33: {
                    fFlush = true;
                    this.f_handler.onSASLAuth(request, response);
                    return;
                }
                case 34: {
                    fFlush = true;
                    this.f_handler.onSASLAuthStep(request, response);
                    return;
                }
                default: {
                    CacheFactory.log("Memcached adapter received unknown request: " + request.getOpCode(), 1);
                    response.setResponseCode(Response.ResponseCode.NOT_SUPPORTED.getCode());
                    return;
                }
            }
        }
        catch (Throwable thr) {
            fFlush = true;
            CacheFactory.log("Exception in handling memcached request: " + Base.printStackTrace(thr), 1);
            response.setResponseCode(Response.ResponseCode.INTERNAL_ERROR.getCode());
            return;
        }
        finally {
            if (fFlush) {
                Task.flush(response, false);
            }
        }
    }

    protected void stat(Request request, Response response) throws IOException {
        String sPid = CacheFactory.getCluster().getLocalMember().getProcessName();
        response.setKey("pid").setValue(sPid.getBytes("utf-8"));
    }

    protected void version(Request request, Response response) throws IOException {
        response.setValue(CacheFactory.VERSION.getBytes("utf-8"));
    }

    public static void flush(Response response, boolean fDisposeOnly) {
        if (response instanceof BinaryConnection.BinaryResponse) {
            ((BinaryConnection.BinaryResponse)response).flush(fDisposeOnly);
        }
    }
}

