/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter;

import com.tangosol.coherence.reporter.Constants;
import com.tangosol.coherence.reporter.QueryHandler;
import com.tangosol.coherence.reporter.ReportColumnView;
import com.tangosol.run.xml.XmlElement;
import java.text.DateFormat;
import java.util.Date;

public class ColumnView
implements ReportColumnView,
Constants {
    protected String m_sId;
    protected String m_sType;
    protected String m_sDesc;
    protected String m_sHeader;
    protected DateFormat m_dateFormat;
    protected boolean m_fVisible;
    protected XmlElement m_xmlConfig;
    protected QueryHandler m_handler;

    @Override
    public void configure(XmlElement xmlConfig) {
        String sHeader;
        String sId = xmlConfig.getSafeAttribute("id").getString();
        String sName = xmlConfig.getSafeElement("name").getString();
        if (sId == null || sId.length() == 0) {
            sId = sName;
        }
        sHeader = (sHeader = xmlConfig.getSafeElement("header").getString(null)) == null ? (sName == null ? "" : sName) : sHeader;
        this.m_sId = sId;
        this.m_xmlConfig = xmlConfig;
        this.m_sType = xmlConfig.getSafeElement("data-type").getString("java.lang.String");
        this.m_sDesc = xmlConfig.getSafeElement("description").getString(sHeader);
        this.setHeader(sHeader);
        this.setVisible(!xmlConfig.getSafeElement("hidden").getBoolean(false));
    }

    public void configure(XmlElement xmlConfig, QueryHandler handler) {
        this.setQueryHandler(handler);
        this.configure(xmlConfig);
    }

    @Override
    public void setQueryHandler(QueryHandler handler) {
        this.m_handler = handler;
    }

    public boolean isAggregate() {
        return this.m_handler.isAggregate(this.m_sId);
    }

    protected void setVisible(boolean fVisible) {
        this.m_fVisible = fVisible;
    }

    protected void setHeader(String sHeader) {
        this.m_sHeader = sHeader;
    }

    public XmlElement getConfig() {
        return this.m_xmlConfig;
    }

    public String getType() {
        return this.m_sType;
    }

    public String getDescription() {
        return this.m_sDesc;
    }

    @Override
    public String getOutputString(Object oObject) {
        Object oValue = this.m_handler.getValue(oObject, this.m_sId);
        if (oValue == null) {
            return "";
        }
        return oValue instanceof Date && this.m_dateFormat != null ? this.m_dateFormat.format((Date)oValue).toString() : oValue.toString();
    }

    @Override
    public boolean isRowDetail() {
        return this.m_handler.isDetail(this.m_sId);
    }

    @Override
    public String getHeader() {
        return this.m_sHeader;
    }

    protected void setDateFormat(DateFormat df) {
        this.m_dateFormat = df;
    }

    @Override
    public boolean isVisible() {
        return this.m_fVisible;
    }

    @Override
    public String getId() {
        return this.m_sId;
    }
}

