/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter.extractor;

import com.tangosol.coherence.reporter.Constants;
import com.tangosol.coherence.reporter.Reporter;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.MultiExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JoinExtractor
extends MultiExtractor
implements Constants {
    private static final String NOT_SERIALIZABLE_MSG = JoinExtractor.class.getCanonicalName() + " is not serializable";
    protected final MBeanServer f_mbs;
    protected String m_sJoinTemplate;
    protected ValueExtractor m_veSource;

    public JoinExtractor(ValueExtractor[] aExtractors, String sJoinTemplate, ValueExtractor veSource) {
        this(aExtractors, sJoinTemplate, veSource, MBeanHelper.findMBeanServer());
    }

    public JoinExtractor(ValueExtractor[] aExtractors, String sJoinTemplate, ValueExtractor veSource, MBeanServer server) {
        super(aExtractors);
        this.m_sJoinTemplate = sJoinTemplate;
        this.m_veSource = veSource;
        this.f_mbs = server;
    }

    @Override
    public Object extract(Object oTarget) {
        List listResult = (List)super.extract(oTarget);
        Set set = Reporter.getMacros(this.m_sJoinTemplate);
        String sJoinTarget = this.m_sJoinTemplate;
        int index = 0;
        for (String sId : set) {
            Object oValue = listResult.get(index);
            if (oValue != null) {
                sJoinTarget = sJoinTarget.replaceAll("\\{" + sId + "\\}", oValue.toString().replaceAll("\\$", "\\\\\\$"));
            }
            ++index;
        }
        try {
            ObjectName onameTarget = new ObjectName(sJoinTarget);
            if (sJoinTarget.contains("*")) {
                Set<ObjectName> setNames = this.f_mbs.queryNames(onameTarget, null);
                onameTarget = setNames.size() == 1 ? setNames.iterator().next() : onameTarget;
            }
            return this.m_veSource.extract(onameTarget);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            return null;
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        throw new NotSerializableException(NOT_SERIALIZABLE_MSG);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        throw new NotSerializableException(NOT_SERIALIZABLE_MSG);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        throw new NotSerializableException(NOT_SERIALIZABLE_MSG);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        throw new NotSerializableException(NOT_SERIALIZABLE_MSG);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        throw new NotSerializableException(NOT_SERIALIZABLE_MSG);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException(NOT_SERIALIZABLE_MSG);
    }
}

