/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter.locator;

import com.tangosol.coherence.reporter.Constants;
import com.tangosol.coherence.reporter.JMXQueryHandler;
import com.tangosol.coherence.reporter.Reporter;
import com.tangosol.coherence.reporter.extractor.AttributeExtractor;
import com.tangosol.coherence.reporter.extractor.JoinExtractor;
import com.tangosol.coherence.reporter.locator.BaseLocator;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ValueExtractor;
import java.util.Set;
import javax.management.MBeanServer;

public class AttributeLocator
extends BaseLocator
implements Constants {
    protected String m_sJoinTemplate;
    protected boolean m_fReturnNeg = false;

    @Override
    public void configure(XmlElement xmlConfig) {
        super.configure(xmlConfig);
        this.m_fReturnNeg = xmlConfig.getSafeElement("return-neg").getBoolean(false);
        this.setJoinTemplate(xmlConfig.getSafeElement("query").getSafeElement("pattern").getString(""));
    }

    @Override
    public ValueExtractor getExtractor() {
        if (this.m_veExtractor == null) {
            String sTemplate = this.m_sJoinTemplate;
            MBeanServer server = this.m_source.getMBeanServer();
            if (sTemplate == null || sTemplate.length() == 0) {
                this.m_veExtractor = new AttributeExtractor(this.m_sName, this.m_cDelim, this.m_fReturnNeg, server);
            } else {
                Set setMacros = Reporter.getMacros(sTemplate);
                if (setMacros.size() > 0) {
                    int nSize = setMacros.size();
                    ValueExtractor[] aVE = new ValueExtractor[nSize];
                    int c = 0;
                    JMXQueryHandler qh = this.m_queryHandler;
                    for (String sExtractorName : setMacros) {
                        aVE[c] = Base.checkNotNull(qh.ensureExtractor(sExtractorName), "Column extractor");
                        ++c;
                    }
                    return new JoinExtractor(aVE, this.m_sJoinTemplate, new AttributeExtractor(this.m_sName, ',', this.m_fReturnNeg, server), server);
                }
                return null;
            }
        }
        return this.m_veExtractor;
    }

    public String getJoinTemplate() {
        return this.m_sJoinTemplate;
    }

    protected void setJoinTemplate(String sTemplate) {
        this.m_sJoinTemplate = sTemplate;
    }

    @Override
    public boolean isRowDetail() {
        return true;
    }
}

