/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter.locator;

import com.tangosol.coherence.reporter.Constants;
import com.tangosol.coherence.reporter.DataSource;
import com.tangosol.coherence.reporter.JMXQueryHandler;
import com.tangosol.coherence.reporter.QueryHandler;
import com.tangosol.coherence.reporter.locator.ColumnLocator;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import java.util.Set;

public class BaseLocator
implements Constants,
ColumnLocator {
    protected String m_sName;
    protected String m_sId;
    protected XmlElement m_xml;
    protected char m_cDelim;
    protected JMXQueryHandler m_queryHandler;
    protected ValueExtractor m_veExtractor;
    protected int m_iExtractorPos;
    protected int m_iGroupPos;
    protected int m_iAggregatePos;
    protected DataSource m_source;
    protected boolean m_fGroupBy;
    protected boolean m_fHidden;

    @Override
    public Object getValue(Object oKey) {
        if (this.isAggregate()) {
            return this.m_source.getAggValue(oKey, this.m_iAggregatePos);
        }
        return this.m_source.getValue(oKey, this.m_iExtractorPos);
    }

    @Override
    public void reset(Set setResults) {
        this.m_veExtractor = null;
    }

    @Override
    public void setDataSource(DataSource source) {
        this.m_source = source;
        if (this.isAggregate()) {
            this.m_iAggregatePos = source.addAggregator(this.getAggregator());
        } else {
            ValueExtractor ve = this.getExtractor();
            this.m_iExtractorPos = source.addExtractor(ve);
            if (this.m_fGroupBy && !this.m_fHidden) {
                source.addGroupBy(ve);
            }
        }
    }

    @Override
    public ValueExtractor getExtractor() {
        return null;
    }

    @Override
    public InvocableMap.EntryAggregator getAggregator() {
        return null;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public void configure(XmlElement xmlConfig) {
        this.m_xml = xmlConfig;
        this.m_cDelim = this.getDelim();
        this.m_sName = xmlConfig.getSafeElement("name").getString();
        this.m_sId = xmlConfig.getSafeAttribute("id").getString();
        this.m_fGroupBy = xmlConfig.getSafeElement("group-by").getBoolean(false);
        this.m_fHidden = xmlConfig.getSafeElement("hidden").getBoolean(false);
        if (this.m_sId.length() == 0) {
            this.m_sId = this.m_sName;
        }
    }

    @Override
    public XmlElement getConfig() {
        return this.m_xml;
    }

    @Override
    public boolean isRowDetail() {
        return false;
    }

    public String getName() {
        return this.m_sName;
    }

    @Override
    public String getId() {
        return this.m_sId;
    }

    @Override
    public void setQuery(QueryHandler handler) {
        this.m_queryHandler = (JMXQueryHandler)handler;
    }

    @Override
    public void configure(XmlElement xmlConfig, JMXQueryHandler handler, DataSource source) {
        this.setQuery(handler);
        this.configure(xmlConfig);
        this.setDataSource(source);
    }

    protected char getDelim() {
        if (this.m_cDelim == '\u0000') {
            String sDelim = this.m_xml.getSafeElement("delim").getString("{tab}");
            this.m_cDelim = sDelim.equals("{tab}") ? (char)9 : (sDelim.equals("{space}") ? (char)32 : sDelim.charAt(0));
        }
        return this.m_cDelim;
    }
}

