/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.config.expression;

import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.expression.Value;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.json.bind.annotation.JsonbProperty;

public class Parameter
implements Expression<Value>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="name")
    private String m_sName;
    @JsonbProperty(value="classType")
    private Class<?> m_clzType;
    @JsonbProperty(value="expression")
    private Expression<?> m_expression;

    public Parameter() {
    }

    public Parameter(String sName, Expression<?> expression) {
        this.m_sName = sName;
        this.m_clzType = null;
        this.m_expression = expression;
    }

    public Parameter(String sName, Object oValue) {
        this.m_sName = sName;
        this.m_clzType = null;
        this.m_expression = new LiteralExpression<Object>(oValue);
    }

    public Parameter(String sName, Class<?> clzType, Expression<?> expression) {
        this.m_sName = sName;
        this.m_clzType = clzType;
        this.m_expression = expression;
    }

    public Parameter(String sName, Class<?> clzType, Object oValue) {
        this.m_sName = sName;
        this.m_clzType = clzType;
        this.m_expression = new LiteralExpression<Object>(oValue);
    }

    @Override
    public Value evaluate(ParameterResolver resolver) {
        Value value;
        Object oValue = this.m_expression.evaluate(resolver);
        Value value2 = value = oValue instanceof Value ? (Value)oValue : new Value(oValue);
        if (this.isExplicitlyTyped()) {
            return new Value(value.as(this.m_clzType));
        }
        return value;
    }

    public String toString() {
        String sResult = "";
        if (this.m_sName != null) {
            sResult = sResult + "name=" + this.m_sName;
        }
        if (this.m_clzType != null) {
            sResult = sResult + (sResult.isEmpty() ? "" : ", ") + "type=" + this.m_clzType;
        }
        sResult = sResult + (sResult.isEmpty() ? "" : ", ") + "expression=" + this.m_expression;
        return "Parameter{" + sResult + "}";
    }

    public String getName() {
        return this.m_sName;
    }

    public Class<?> getExplicitType() {
        return this.m_clzType;
    }

    public boolean isExplicitlyTyped() {
        return this.m_clzType != null;
    }

    public Expression<?> getExpression() {
        return this.m_expression;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_sName = ExternalizableHelper.readSafeUTF(in);
        this.m_expression = (Expression)ExternalizableHelper.readObject(in);
        String sClzName = ExternalizableHelper.readSafeUTF(in);
        if (sClzName.length() > 0) {
            try {
                this.m_clzType = Class.forName(sClzName);
            }
            catch (ClassNotFoundException e) {
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeSafeUTF(out, this.m_sName);
        ExternalizableHelper.writeObject(out, this.m_expression);
        ExternalizableHelper.writeSafeUTF(out, this.m_clzType == null ? "" : this.m_clzType.getName());
    }

    @Override
    public void readExternal(PofReader reader) throws IOException {
        this.m_sName = reader.readString(0);
        this.m_expression = (Expression)reader.readObject(1);
        String sClzName = reader.readString(2);
        if (sClzName.length() > 0) {
            try {
                this.m_clzType = Class.forName(sClzName);
            }
            catch (ClassNotFoundException e) {
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    @Override
    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeString(0, this.m_sName);
        writer.writeObject(1, this.m_expression);
        writer.writeString(2, this.m_clzType == null ? "" : this.m_clzType.getName());
    }
}

