/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.config.xml;

import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlValue;
import java.lang.reflect.Constructor;

public class SimpleElementProcessor<T>
implements ElementProcessor<T> {
    private Class<T> m_clzElement;

    public SimpleElementProcessor(Class<T> clzElement) {
        this.m_clzElement = clzElement;
    }

    @Override
    public T process(ProcessingContext context, XmlElement element) throws ConfigurationException {
        try {
            if (this.m_clzElement.isEnum()) {
                String sValue = element.getString();
                try {
                    return Enum.valueOf(this.m_clzElement, sValue);
                }
                catch (Exception exception) {
                    throw new ClassCastException(String.format("The specified Enum value '%s' is unknown.", sValue));
                }
            }
            try {
                Constructor<T> constructor = this.m_clzElement.getConstructor(XmlValue.class);
                return constructor.newInstance(element);
            }
            catch (NoSuchMethodException constructor) {
                try {
                    Constructor<T> constructor2 = this.m_clzElement.getConstructor(XmlElement.class);
                    return constructor2.newInstance(element);
                }
                catch (NoSuchMethodException constructor2) {
                    try {
                        Constructor<T> constructor3 = this.m_clzElement.getConstructor(String.class);
                        return constructor3.newInstance(element.toString());
                    }
                    catch (NoSuchMethodException constructor3) {
                        return context.inject(this.m_clzElement.newInstance(), element);
                    }
                }
            }
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new ConfigurationException(String.format("Can't instantiate the required class [%s] using the element [%s]", this.m_clzElement, element), "The required class does not provide a public no args constructor or a single argument constructor for either String, XmlValue or XmlElement type values.", exception);
        }
    }
}

