/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class FloatConstant
extends Constant
implements Constants {
    private static final String CLASS = "FloatConstant";
    private float m_flVal;

    protected FloatConstant() {
        super(4);
    }

    public FloatConstant(float flVal) {
        this();
        this.m_flVal = flVal;
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_flVal = stream.readFloat();
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        super.assemble(stream, pool);
        stream.writeFloat(this.m_flVal);
    }

    @Override
    public int compareTo(Object obj) {
        FloatConstant that = (FloatConstant)obj;
        float flThis = this.m_flVal;
        float flThat = that.m_flVal;
        return flThis < flThat ? -1 : (flThis > flThat ? 1 : 0);
    }

    @Override
    public String toString() {
        return "(Float) " + this.m_flVal;
    }

    @Override
    public String format() {
        return String.valueOf(this.m_flVal) + 'F';
    }

    @Override
    public boolean equals(Object obj) {
        try {
            FloatConstant that = (FloatConstant)obj;
            return this == that || this.getClass() == that.getClass() && this.m_flVal == that.m_flVal;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public float getValue() {
        return this.m_flVal;
    }
}

