/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Ivar;
import com.tangosol.dev.assembler.Op;
import com.tangosol.dev.assembler.OpDeclare;
import com.tangosol.dev.assembler.OpVariable;
import java.io.DataOutput;
import java.io.IOException;

public class Iinc
extends Op
implements Constants,
OpVariable {
    private static final String CLASS = "Iinc";
    private Ivar m_var;
    private short m_sInc;

    public Iinc(Ivar var, short sInc) {
        super(132);
        this.m_var = var;
        this.m_sInc = sInc;
        if (var == null) {
            throw new IllegalArgumentException("Iinc:  Variable must not be null!");
        }
    }

    @Override
    public String toString() {
        return Iinc.format(null, this.getName() + ' ' + this.m_var.format() + ", " + this.m_sInc, null);
    }

    @Override
    public String toJasm() {
        return this.getName() + ' ' + this.m_var.format() + ", " + this.m_sInc;
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        int n = this.m_var.getSlot();
        short i = this.m_sInc;
        if (n > 255 || i < -128 || i > 127) {
            stream.writeByte(196);
            stream.writeByte(132);
            stream.writeShort(n);
            stream.writeShort(i);
        } else {
            stream.writeByte(132);
            stream.writeByte(n);
            stream.writeByte(i);
        }
    }

    @Override
    protected void calculateSize(ConstantPool pool) {
        short i = this.m_sInc;
        if (this.m_var.getSlot() > 255 || i < -128 || i > 127) {
            this.setSize(6);
        } else {
            this.setSize(3);
        }
    }

    @Override
    public OpDeclare getVariable() {
        return this.m_var;
    }
}

