/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.assembler.OpBranch;
import java.io.DataOutput;
import java.io.IOException;

public class Jsr
extends OpBranch
implements Constants {
    private static final String CLASS = "Jsr";
    private Label m_labelContext;
    private int m_iSlot = Integer.MIN_VALUE;

    public Jsr(Label label) {
        super(168, label);
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        Label label = this.getLabel();
        int iOp = label.getRet() == null ? 167 : 168;
        int ofBranch = label.getOffset() - this.getOffset();
        if (ofBranch < Short.MIN_VALUE || ofBranch > Short.MAX_VALUE) {
            throw new IllegalStateException("Jsr.assemble:  Branch offset out of range!");
        }
        stream.writeByte(iOp);
        stream.writeShort(ofBranch);
    }

    @Override
    public int getStackChange() {
        int cwBefore = this.getStackHeight();
        int cwAfter = this.getLabel().getRetHeight();
        if (cwBefore == Integer.MIN_VALUE || cwAfter == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return cwAfter - cwBefore;
    }

    @Override
    public String toJasm() {
        return this.getName() + ' ' + this.getLabel().getOffset();
    }

    protected Label getContext() {
        return this.m_labelContext;
    }

    protected void setContext(Label label) {
        this.m_labelContext = label;
    }

    protected int getDepth() {
        Label labelContext = this.m_labelContext;
        return labelContext == null ? 0 : labelContext.getDepth() + 1;
    }

    protected int getFirstSlot() {
        return this.m_iSlot;
    }

    protected void setFirstSlot(int iSlot) {
        this.m_iSlot = iSlot;
    }
}

