/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ClassFile;
import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.FieldConstant;
import com.tangosol.dev.assembler.InterfaceConstant;
import com.tangosol.dev.assembler.MethodConstant;
import com.tangosol.dev.assembler.RefConstant;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MethodHandleConstant
extends Constant {
    public static final int KIND_REF_GETFIELD = 1;
    public static final int KIND_REF_GETSTATIC = 2;
    public static final int KIND_REF_PUTFIELD = 3;
    public static final int KIND_REF_PUTSTATIC = 4;
    public static final int KIND_REF_INVOKEVIRTUAL = 5;
    public static final int KIND_REF_INVOKESTATIC = 6;
    public static final int KIND_REF_INVOKESPECIAL = 7;
    public static final int KIND_REF_NEWINVOKESPECIAL = 8;
    public static final int KIND_REF_INVOKEINTERFACE = 9;
    private int m_nReferenceKind;
    private int m_nReferenceIndex;
    private RefConstant m_ref;
    private boolean m_fAllowInterface;

    protected MethodHandleConstant(boolean fAllowInterface) {
        this(fAllowInterface, 0, null);
    }

    public MethodHandleConstant(boolean fAllowInterface, int nReferenceKind, RefConstant ref) {
        super(15);
        this.m_fAllowInterface = fAllowInterface;
        this.m_nReferenceKind = nReferenceKind;
        this.m_ref = ref;
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_nReferenceKind = stream.readUnsignedByte();
        this.m_nReferenceIndex = stream.readUnsignedShort();
        ClassFile cf = pool.getClassFile();
        this.m_fAllowInterface = cf != null && cf.getMajorVersion() >= 52;
    }

    @Override
    protected void postdisassemble(ConstantPool pool) {
        RefConstant ref = (RefConstant)pool.getConstant(this.m_nReferenceIndex);
        ref.postdisassemble(pool);
        if (this.isValid(ref)) {
            this.m_ref = ref;
        }
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(this.m_ref);
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        super.assemble(stream, pool);
        stream.writeByte(this.m_nReferenceKind);
        stream.writeShort(pool.findConstant(this.m_ref));
    }

    @Override
    public int compareTo(Object obj) {
        return obj instanceof MethodHandleConstant ? this.m_ref.compareTo(((MethodHandleConstant)obj).m_ref) : 1;
    }

    @Override
    public String toString() {
        return "(MethodHandle)->[reference_kind = " + this.m_nReferenceKind + ", reference = " + this.m_ref + "]";
    }

    @Override
    public String format() {
        return this.m_ref.format();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof MethodHandleConstant ? this.m_ref.equals(((MethodHandleConstant)obj).m_ref) : false;
    }

    public int getKind() {
        return this.m_nReferenceKind;
    }

    public void setKind(int nReferenceKind) {
        if (this.isValid(nReferenceKind, this.m_ref)) {
            this.m_nReferenceKind = nReferenceKind;
        }
    }

    public RefConstant getReference() {
        return this.m_ref;
    }

    public void setReference(RefConstant ref) {
        if (!this.isValid(ref)) {
            throw new IllegalArgumentException(String.format("Constant is not valid with the current reference_kind, [constant = %s, reference_kind = %d]", ref, this.m_nReferenceKind));
        }
        this.m_ref = ref;
    }

    public boolean isInterfaceRefAllowed() {
        return this.m_fAllowInterface;
    }

    public void setInterfaceRefAllowed(boolean fAllowInterface) {
        this.m_fAllowInterface = fAllowInterface;
    }

    protected boolean isValid(RefConstant ref) {
        return this.isValid(this.m_nReferenceKind, ref);
    }

    protected boolean isValid(int nKind, RefConstant ref) {
        if (ref == null) {
            return true;
        }
        Class<MethodConstant> clz = MethodConstant.class;
        switch (nKind) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return FieldConstant.class == ref.getClass();
            }
            case 9: {
                clz = InterfaceConstant.class;
            }
            case 6: 
            case 7: {
                return (clz == ref.getClass() || this.isInterfaceRefAllowed() && clz == InterfaceConstant.class) && !ref.getName().contains("<init>") && !ref.getName().contains("<clinit>");
            }
            case 5: 
            case 8: {
                return MethodConstant.class == ref.getClass() && (nKind == 8 && ref.getName().contains("<init>") || !ref.getName().contains("<init>") && !ref.getName().contains("<clinit>"));
            }
        }
        throw new IllegalStateException("Constant MethodHandle must have a reference kind value between 0 - 9");
    }
}

