/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Aload;
import com.tangosol.dev.assembler.Areturn;
import com.tangosol.dev.assembler.Astore;
import com.tangosol.dev.assembler.Avar;
import com.tangosol.dev.assembler.Begin;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Dload;
import com.tangosol.dev.assembler.Dreturn;
import com.tangosol.dev.assembler.Dstore;
import com.tangosol.dev.assembler.Dvar;
import com.tangosol.dev.assembler.End;
import com.tangosol.dev.assembler.Fload;
import com.tangosol.dev.assembler.Freturn;
import com.tangosol.dev.assembler.Fstore;
import com.tangosol.dev.assembler.Fvar;
import com.tangosol.dev.assembler.Iload;
import com.tangosol.dev.assembler.Ireturn;
import com.tangosol.dev.assembler.Istore;
import com.tangosol.dev.assembler.Ivar;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.assembler.Lload;
import com.tangosol.dev.assembler.Lreturn;
import com.tangosol.dev.assembler.Lstore;
import com.tangosol.dev.assembler.Lvar;
import com.tangosol.dev.assembler.Op;
import com.tangosol.dev.assembler.OpLoad;
import com.tangosol.dev.assembler.Return;
import com.tangosol.java.type.Type;

public abstract class OpDeclare
extends Op
implements Constants {
    private static final String CLASS = "OpDeclare";
    private static final char[] TYPES = new char[]{'I', 'L', 'F', 'D', 'A', 'R'};
    private static final String[] SIGS = new String[]{Type.INT.getSignature(), Type.LONG.getSignature(), Type.FLOAT.getSignature(), Type.DOUBLE.getSignature(), Type.OBJECT.getSignature(), null};
    private String m_sName;
    private String m_sSig;
    private int m_iVar = Integer.MIN_VALUE;
    private Begin m_begin;
    private End m_end;
    private Label m_labelContext;

    protected OpDeclare(int iOp, String sName, String sSig) {
        this(iOp, sName, sSig, Integer.MIN_VALUE);
    }

    protected OpDeclare(int iOp, String sName, String sSig, int iVar) {
        super(iOp);
        if (sSig == null) {
            sSig = SIGS[iOp - 236];
        }
        if (sName != null && sName.length() == 0) {
            sName = null;
        }
        this.m_sName = sName;
        this.m_sSig = sSig;
        this.m_iVar = iVar;
    }

    @Override
    public String toString() {
        StringBuffer sbInstruction = new StringBuffer(this.getName());
        if (this.m_sSig != null && !this.m_sSig.equals(SIGS[this.getValue() - 236])) {
            sbInstruction.append(' ').append(this.m_sSig);
        }
        sbInstruction.append(' ').append(this.format());
        String sInstruction = sbInstruction.toString();
        String sComment = null;
        if (this.m_iVar != Integer.MIN_VALUE) {
            sComment = "reg[" + this.m_iVar + "]";
        }
        return OpDeclare.format(null, sInstruction, sComment);
    }

    @Override
    public String toJasm() {
        StringBuffer sb = new StringBuffer(this.getName());
        if (this.m_sSig != null && !this.m_sSig.equals(SIGS[this.getValue() - 236])) {
            sb.append(' ').append(this.m_sSig);
        }
        sb.append(' ').append(this.format());
        return sb.toString();
    }

    public String format() {
        String sName = this.m_sName;
        if (sName == null) {
            sName = new StringBuffer().append('#').append(this.getName().charAt(0)).append(this.m_iVar == Integer.MIN_VALUE ? this.hashCode() : this.m_iVar).toString();
        }
        return sName;
    }

    public char getType() {
        return TYPES[this.getValue() - 236];
    }

    public String getVariableName() {
        return this.m_sName;
    }

    public String getSignature() {
        return this.m_sSig;
    }

    public boolean hasDebugInfo() {
        String sName = this.m_sName;
        return sName != null && sName.charAt(0) != '#';
    }

    public int getSlot() {
        return this.m_iVar;
    }

    protected void setSlot(int iVar) {
        this.m_iVar = iVar;
    }

    public int getWidth() {
        int iOp = this.getValue();
        return iOp == 237 || iOp == 239 ? 2 : 1;
    }

    public static int getWidth(char ch) {
        return ch == 'L' || ch == 'D' ? 2 : 1;
    }

    public static int getJavaWidth(char ch) {
        return ch == 'J' || ch == 'D' ? 2 : 1;
    }

    protected Begin getBegin() {
        return this.m_begin;
    }

    protected void setBegin(Begin begin) {
        this.m_begin = begin;
    }

    protected End getEnd() {
        return this.m_begin.getEnd();
    }

    protected Label getContext() {
        return this.m_labelContext;
    }

    protected void setContext(Label label) {
        this.m_labelContext = label;
    }

    protected int getDepth() {
        Label labelContext = this.m_labelContext;
        return labelContext == null ? 0 : labelContext.getDepth();
    }

    public static OpDeclare getDeclareVar(String sType, String sName) {
        switch (sType.charAt(0)) {
            case 'Z': {
                return new Ivar(sName, "Z");
            }
            case 'B': {
                return new Ivar(sName, "B");
            }
            case 'C': {
                return new Ivar(sName, "C");
            }
            case 'S': {
                return new Ivar(sName, "S");
            }
            case 'I': {
                return new Ivar(sName, "I");
            }
            case 'J': {
                return new Lvar(sName);
            }
            case 'F': {
                return new Fvar(sName);
            }
            case 'D': {
                return new Dvar(sName);
            }
        }
        return new Avar(sName, sType);
    }

    public Op getLoadOp() {
        return OpDeclare.getLoadOp(this);
    }

    public static OpLoad getLoadOp(OpDeclare opDeclare) {
        switch (opDeclare.getSignature().charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return new Iload((Ivar)opDeclare);
            }
            case 'J': {
                return new Lload((Lvar)opDeclare);
            }
            case 'F': {
                return new Fload((Fvar)opDeclare);
            }
            case 'D': {
                return new Dload((Dvar)opDeclare);
            }
        }
        return new Aload((Avar)opDeclare);
    }

    public Op getStoreOp() {
        switch (this.getSignature().charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return new Istore((Ivar)this);
            }
            case 'J': {
                return new Lstore((Lvar)this);
            }
            case 'F': {
                return new Fstore((Fvar)this);
            }
            case 'D': {
                return new Dstore((Dvar)this);
            }
        }
        return new Astore((Avar)this);
    }

    public Op getReturnOp() {
        return OpDeclare.getReturnOp(this.getSignature());
    }

    public static Op getReturnOp(String sSig) {
        switch (sSig.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return new Ireturn();
            }
            case 'J': {
                return new Lreturn();
            }
            case 'F': {
                return new Freturn();
            }
            case 'D': {
                return new Dreturn();
            }
            case 'V': {
                return new Return();
            }
        }
        return new Areturn();
    }
}

