/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.Goto;
import com.tangosol.dev.assembler.Iconst;
import com.tangosol.dev.assembler.Ifne;
import com.tangosol.dev.assembler.IntConstant;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.LogicalExpression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.AbstractSet;
import java.util.Map;

public class AndExpression
extends LogicalExpression {
    private static final String CLASS = "AndExpression";
    private static final IntConstant TRUE = Constants.CONSTANT_ICONST_1;
    private static final IntConstant FALSE = Constants.CONSTANT_ICONST_0;

    public AndExpression(Expression left, Token operator, Expression right) {
        super(left, operator, right);
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        left = (Expression)left.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        DualSet setUTrue = new DualSet(setUVars.getTrueSet());
        DualSet setFTrue = new DualSet(setFVars.getTrueSet());
        right = (Expression)right.precompile(ctx, setUTrue, setFTrue, mapThrown, errlist);
        if (setUTrue.isModified()) {
            if (!setUTrue.isSingle()) {
                setUTrue.getFalseSet().clear();
            }
            setUTrue.resolve();
        }
        if (!setUVars.isModified()) {
            setUVars.merge();
        }
        if (setFVars.isModified() || setFTrue.isModified()) {
            AbstractSet setFRightFalse = setFTrue.isSingle() ? setFTrue : setFTrue.getFalseSet();
            setFVars.getFalseSet().addAll(setFRightFalse);
            if (!setFTrue.isSingle()) {
                setFTrue.getFalseSet().clear();
            }
            setFTrue.resolve();
        }
        if (!setFVars.isModified()) {
            setFVars.merge();
        }
        left.checkBoolean(errlist);
        right.checkBoolean(errlist);
        this.setLeftExpression(left);
        this.setRightExpression(right);
        this.setType(DataType.BOOLEAN);
        return this;
    }

    @Override
    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        if (!ctx.isDebug() && this.isConstant()) {
            boolean fVal = (Boolean)this.getValue();
            code.add(new Iconst(fVal ? TRUE : FALSE));
            if (fReached && !right.isConstant()) {
                right.notReached(errlist);
            }
        } else {
            Label lblRight = new Label();
            Label lblExit = new Label();
            left.compile(ctx, code, fReached, errlist);
            code.add(new Ifne(lblRight));
            code.add(new Iconst(FALSE));
            code.add(new Goto(lblExit));
            code.add(lblRight);
            right.compile(ctx, code, fReached, errlist);
            code.add(lblExit);
        }
        return fReached;
    }

    @Override
    public boolean isConstant() {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        if (left.isConstant()) {
            boolean fLeft = (Boolean)left.getValue();
            return !fLeft || right.isConstant();
        }
        return false;
    }

    @Override
    public Object getValue() {
        Expression left = this.getLeftExpression();
        if (!((Boolean)left.getValue()).booleanValue()) {
            return Boolean.FALSE;
        }
        Expression right = this.getRightExpression();
        if (!((Boolean)right.getValue()).booleanValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

