/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.util.DeltaSet;
import com.tangosol.util.NullImplementation;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class DualSet
extends AbstractSet {
    private DeltaSet dsetTrue;
    private DeltaSet dsetFalse;
    private static final Set EMPTY_SET = NullImplementation.getSet();
    private static final Iterator EMPTY_ITERATOR = NullImplementation.getIterator();
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public DualSet(Set set) {
        this.dsetTrue = new DeltaSet(set);
    }

    public boolean isModified() {
        return this.dsetTrue.isModified() || this.dsetFalse != null && this.dsetFalse.isModified();
    }

    public Set getAdded() {
        DeltaSet dsetTrue = this.dsetTrue;
        DeltaSet dsetFalse = this.dsetFalse;
        if (dsetFalse == null) {
            return dsetTrue.getAdded();
        }
        Set setAddedTrue = dsetTrue.getAdded();
        Set setAddedFalse = dsetFalse.getAdded();
        if (setAddedTrue.isEmpty()) {
            return setAddedFalse;
        }
        if (setAddedFalse.isEmpty()) {
            return setAddedTrue;
        }
        HashSet setAdded = new HashSet(setAddedTrue);
        setAdded.addAll(setAddedFalse);
        return setAdded;
    }

    public Set getRemoved() {
        DeltaSet dsetTrue = this.dsetTrue;
        DeltaSet dsetFalse = this.dsetFalse;
        if (dsetFalse == null) {
            return dsetTrue.getRemoved();
        }
        Set setRemovedTrue = dsetTrue.getRemoved();
        Set setRemovedFalse = dsetFalse.getRemoved();
        if (setRemovedTrue.isEmpty() || setRemovedFalse.isEmpty()) {
            return EMPTY_SET;
        }
        HashSet setRemoved = new HashSet(setRemovedTrue);
        setRemoved.retainAll(setRemovedFalse);
        return setRemoved;
    }

    public DeltaSet getTrueSet() {
        if (this.dsetFalse == null) {
            this.dsetFalse = (DeltaSet)this.dsetTrue.clone();
        }
        return this.dsetTrue;
    }

    public DeltaSet getFalseSet() {
        DeltaSet dset = this.dsetFalse;
        if (dset == null) {
            this.dsetFalse = dset = (DeltaSet)this.dsetTrue.clone();
        }
        return dset;
    }

    public void negate() {
        if (this.dsetFalse != null) {
            DeltaSet dset = this.dsetFalse;
            this.dsetFalse = this.dsetTrue;
            this.dsetTrue = dset;
        }
    }

    public boolean isSingle() {
        return this.dsetFalse == null;
    }

    public void merge() {
        if (this.dsetFalse != null) {
            Set setRemovedFalse;
            Set setRemovedTrue;
            DeltaSet dsetTrue = this.dsetTrue;
            DeltaSet dsetFalse = this.dsetFalse;
            Set setAdded = dsetFalse.getAdded();
            if (!setAdded.isEmpty()) {
                dsetTrue.addAll(setAdded);
            }
            if (!(setRemovedTrue = dsetTrue.getRemoved()).equals(setRemovedFalse = dsetFalse.getRemoved())) {
                HashSet set = new HashSet(setRemovedTrue);
                set.removeAll(setRemovedFalse);
                dsetTrue.addAll(set);
            }
            Object var2_2 = null;
        }
    }

    public void resolve() {
        this.merge();
        this.dsetTrue.resolve();
    }

    public void reset() {
        this.dsetTrue.reset();
        this.dsetFalse = null;
    }

    @Override
    public Iterator iterator() {
        if (this.dsetFalse == null) {
            return this.dsetTrue.iterator();
        }
        return new DualIterator();
    }

    @Override
    public int size() {
        DeltaSet dsetTrue = this.dsetTrue;
        DeltaSet dsetFalse = this.dsetFalse;
        int c = dsetTrue.size();
        if (dsetFalse == null) {
            return c;
        }
        Set setAddedFalse = dsetFalse.getAdded();
        if (setAddedFalse.isEmpty()) {
            return c;
        }
        Set setAddedTrue = dsetTrue.getAdded();
        Iterator iter = setAddedFalse.iterator();
        while (iter.hasNext()) {
            if (setAddedTrue.contains(iter.next())) continue;
            ++c;
        }
        return c;
    }

    @Override
    public boolean contains(Object o) {
        if (this.dsetFalse == null) {
            return this.dsetTrue.contains(o);
        }
        return this.dsetTrue.contains(o) || this.dsetFalse.contains(o);
    }

    @Override
    public boolean add(Object o) {
        boolean f = this.dsetTrue.add(o);
        if (this.dsetFalse != null) {
            f &= this.dsetFalse.add(o);
        }
        return f;
    }

    @Override
    public boolean remove(Object o) {
        boolean f = this.dsetTrue.remove(o);
        if (this.dsetFalse != null) {
            f &= this.dsetFalse.remove(o);
        }
        return f;
    }

    @Override
    public void clear() {
        this.dsetTrue.clear();
        this.dsetFalse = null;
    }

    @Override
    public Object[] toArray() {
        DeltaSet dsetTrue = this.dsetTrue;
        DeltaSet dsetFalse = this.dsetFalse;
        if (dsetFalse == null || dsetFalse.getAdded().isEmpty()) {
            return dsetTrue.toArray();
        }
        int c = this.size();
        Object[] ao = new Object[c];
        c = dsetTrue.size();
        if (c > 0) {
            dsetTrue.toArray(ao);
        }
        Set setAddedTrue = dsetTrue.getAdded();
        Set setAddedFalse = dsetFalse.getAdded();
        for (Object o : setAddedFalse) {
            if (setAddedTrue.contains(o)) continue;
            ao[c++] = o;
        }
        return ao;
    }

    protected class DualIterator
    implements Iterator {
        private Object[] ao;
        private int i = 0;
        private boolean fRemovable = false;

        protected DualIterator() {
            this.ao = DualSet.this.toArray();
        }

        @Override
        public boolean hasNext() {
            return this.i < this.ao.length;
        }

        public Object next() {
            if (this.i < this.ao.length) {
                this.fRemovable = true;
                return this.ao[this.i++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (!this.fRemovable) {
                throw new IllegalStateException();
            }
            DualSet.this.remove(this.ao[this.i - 1]);
            this.fRemovable = false;
        }
    }
}

