/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Goto;
import com.tangosol.dev.assembler.Ifeq;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.BooleanExpression;
import com.tangosol.dev.compiler.java.ConditionalStatement;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Statement;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class IfStatement
extends ConditionalStatement {
    private static final String CLASS = "IfStatement";
    private Statement stmtElse;

    public IfStatement(Statement stmt, Token token) {
        super(stmt, token);
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression exprTest = this.precompileTest(ctx, setUVars, setFVars, mapThrown, errlist);
        Statement stmtThen = this.getThenStatement();
        DualSet setUThen = new DualSet(setUVars.getTrueSet());
        DualSet setFThen = new DualSet(setFVars.getTrueSet());
        stmtThen.precompile(ctx, setUThen, setFThen, mapThrown, errlist);
        setUThen.resolve();
        setFThen.resolve();
        Statement stmtElse = this.getElseStatement();
        if (stmtElse != null) {
            DualSet setUElse = new DualSet(setUVars.getFalseSet());
            DualSet setFElse = new DualSet(setFVars.getFalseSet());
            stmtElse.precompile(ctx, setUElse, setFElse, mapThrown, errlist);
            setUElse.resolve();
            setFElse.resolve();
        }
        setUVars.merge();
        setFVars.merge();
        return this;
    }

    @Override
    protected boolean compileImpl(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        Expression exprTest = this.getTest();
        Statement stmtThen = this.getThenStatement();
        Statement stmtElse = this.getElseStatement();
        if (exprTest instanceof BooleanExpression || !ctx.isDebug() && exprTest.isConstant()) {
            if (!((Boolean)exprTest.getValue()).booleanValue()) {
                stmtThen = stmtElse;
            }
            if (stmtThen != null) {
                stmtThen.compile(ctx, code, fReached, errlist);
            }
            return fReached;
        }
        Label lblElse = new Label();
        Label lblExit = this.getEndLabel();
        exprTest.compile(ctx, code, fReached, errlist);
        code.add(new Ifeq(lblElse));
        boolean fCompletes = stmtThen.compile(ctx, code, fReached, errlist);
        if (stmtElse == null) {
            code.add(lblElse);
            fCompletes = fReached;
        } else {
            code.add(new Goto(lblExit));
            code.add(lblElse);
            fCompletes |= stmtElse.compile(ctx, code, fReached, errlist);
        }
        return fCompletes;
    }

    public Statement getThenStatement() {
        return this.getInnerStatement();
    }

    protected void setThenStatement(Statement stmt) {
        this.setInnerStatement(stmt);
        if (this.stmtElse == null) {
            this.setEndToken(stmt.getEndToken());
        }
    }

    public Statement getElseStatement() {
        return this.stmtElse;
    }

    protected void setElseStatement(Statement stmt) {
        this.stmtElse = stmt;
        this.setEndToken(stmt.getEndToken());
    }
}

