/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Dconst;
import com.tangosol.dev.assembler.Dneg;
import com.tangosol.dev.assembler.Fconst;
import com.tangosol.dev.assembler.Fneg;
import com.tangosol.dev.assembler.Iconst;
import com.tangosol.dev.assembler.Ineg;
import com.tangosol.dev.assembler.Lconst;
import com.tangosol.dev.assembler.Lneg;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.UnaryExpression;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class MinusExpression
extends UnaryExpression {
    private static final String CLASS = "MinusExpression";

    public MinusExpression(Token operator, Expression expr) {
        super(operator, expr);
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression expr = this.getExpression();
        if ((expr = (Expression)expr.precompile(ctx, setUVars, setFVars, mapThrown, errlist)).checkNumeric(errlist)) {
            expr = expr.promoteNumeric();
            this.setExpression(expr);
            this.setType(expr.getType());
        }
        return this;
    }

    @Override
    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        Expression expr = this.getExpression();
        char chType = expr.getType().getTypeString().charAt(0);
        if (!ctx.isDebug() && expr.isConstant()) {
            Object oVal = expr.getValue();
            switch (chType) {
                case 'I': {
                    int n = ((Number)oVal).intValue();
                    code.add(new Iconst(-n));
                    break;
                }
                case 'J': {
                    long l = ((Number)oVal).longValue();
                    code.add(new Lconst(-l));
                    break;
                }
                case 'F': {
                    float fl = ((Number)oVal).floatValue();
                    code.add(new Fconst(-fl));
                    break;
                }
                case 'D': {
                    double dfl = ((Number)oVal).doubleValue();
                    code.add(new Dconst(-dfl));
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal Type=" + chType);
                }
            }
        } else {
            expr.compile(ctx, code, fReached, errlist);
            switch (chType) {
                case 'I': {
                    code.add(new Ineg());
                    break;
                }
                case 'J': {
                    code.add(new Lneg());
                    break;
                }
                case 'F': {
                    code.add(new Fneg());
                    break;
                }
                case 'D': {
                    code.add(new Dneg());
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal Type=" + chType);
                }
            }
        }
        return fReached;
    }

    @Override
    public boolean isConstant() {
        return this.getExpression().isConstant();
    }

    @Override
    public Object getValue() {
        Expression expr = this.getExpression();
        char chType = expr.getType().getTypeString().charAt(0);
        Object oVal = expr.getValue();
        switch (chType) {
            case 'I': {
                return -((Number)oVal).intValue();
            }
            case 'J': {
                return MinusExpression.makeLong(-((Number)oVal).longValue());
            }
            case 'F': {
                return new Float(-((Number)oVal).floatValue());
            }
            case 'D': {
                return new Double(-((Number)oVal).doubleValue());
            }
        }
        throw new IllegalStateException("Illegal Type=" + chType);
    }
}

