/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.Aload;
import com.tangosol.dev.assembler.Astore;
import com.tangosol.dev.assembler.Athrow;
import com.tangosol.dev.assembler.Avar;
import com.tangosol.dev.assembler.Begin;
import com.tangosol.dev.assembler.Catch;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Dup;
import com.tangosol.dev.assembler.End;
import com.tangosol.dev.assembler.Goto;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.assembler.Monitorenter;
import com.tangosol.dev.assembler.Monitorexit;
import com.tangosol.dev.assembler.Ret;
import com.tangosol.dev.assembler.Rstore;
import com.tangosol.dev.assembler.Rvar;
import com.tangosol.dev.assembler.Try;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.GuardedStatement;
import com.tangosol.dev.compiler.java.Statement;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class SynchronizedStatement
extends GuardedStatement {
    private static final String CLASS = "SynchronizedStatement";
    private Expression monitor;

    public SynchronizedStatement(Statement outer, Token token) {
        super(outer, token);
        this.setUnwindLabel(new Label());
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression expr = this.monitor;
        expr = (Expression)expr.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        expr.checkReference(errlist);
        this.monitor = expr;
        this.getInnerStatement().precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        return this;
    }

    @Override
    protected boolean compileImpl(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        Expression expr = this.monitor;
        Statement stmt = this.getInnerStatement();
        Avar varMonitor = new Avar();
        Rvar varRetAddr = new Rvar();
        Try opTry = new Try();
        Label lblGuard = new Label();
        code.add(new Begin());
        code.add(varMonitor);
        expr.compile(ctx, code, fReached, errlist);
        code.add(new Dup());
        code.add(new Astore(varMonitor));
        code.add(new Monitorenter());
        code.add(opTry);
        boolean fCompletes = stmt.compile(ctx, code, fReached, errlist);
        code.add(new Aload(varMonitor));
        code.add(new Monitorexit());
        code.add(new Catch(opTry, null, lblGuard));
        code.add(new Goto(this.getEndLabel()));
        Try opTryForever = new Try();
        Avar varException = new Avar();
        code.add(lblGuard);
        code.add(new Begin());
        code.add(varException);
        code.add(opTryForever);
        code.add(new Astore(varException));
        code.add(new Aload(varMonitor));
        code.add(new Monitorexit());
        code.add(new Catch(opTryForever, null, lblGuard));
        code.add(new Aload(varException));
        code.add(new Athrow());
        code.add(new End());
        Try opTryFinally = new Try();
        Label lblGuardUnwind = new Label();
        code.add(this.getUnwindLabel());
        code.add(new Begin());
        code.add(varRetAddr);
        code.add(opTryFinally);
        code.add(new Rstore(varRetAddr));
        code.add(new Aload(varMonitor));
        code.add(new Monitorexit());
        code.add(new Catch(opTryFinally, null, lblGuardUnwind));
        code.add(new Ret(varRetAddr));
        Try opTryFinallyForever = new Try();
        Avar varFinallyException = new Avar();
        code.add(lblGuardUnwind);
        code.add(new Begin());
        code.add(varFinallyException);
        code.add(opTryFinallyForever);
        code.add(new Astore(varFinallyException));
        code.add(new Aload(varMonitor));
        code.add(new Monitorexit());
        code.add(new Catch(opTryFinallyForever, null, lblGuardUnwind));
        code.add(new Aload(varFinallyException));
        code.add(new Athrow());
        code.add(new End());
        code.add(new End());
        code.add(new End());
        return fCompletes;
    }

    public Expression getExpression() {
        return this.monitor;
    }

    protected void setExpression(Expression expr) {
        this.monitor = expr;
    }

    @Override
    public void print(String sIndent) {
        SynchronizedStatement.out(sIndent + this.toString());
        SynchronizedStatement.out(sIndent + "  Monitor:");
        this.monitor.print(sIndent + "    ");
        SynchronizedStatement.out(sIndent + "  Synchronized Block:");
        this.getInnerStatement().print(sIndent + "    ");
    }
}

