/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.disassembler;

import com.tangosol.dev.compiler.java.LiteralToken;
import com.tangosol.dev.disassembler.ClassConstant;
import com.tangosol.dev.disassembler.DoubleConstant;
import com.tangosol.dev.disassembler.FloatConstant;
import com.tangosol.dev.disassembler.IntConstant;
import com.tangosol.dev.disassembler.LongConstant;
import com.tangosol.dev.disassembler.NameTypeConstant;
import com.tangosol.dev.disassembler.RefConstant;
import com.tangosol.dev.disassembler.StringConstant;
import com.tangosol.dev.disassembler.UnicodeConstant;
import com.tangosol.dev.disassembler.UtfConstant;
import com.tangosol.util.Base;
import java.io.DataInput;
import java.io.IOException;

public class Constant
extends Base {
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_NameAndType = 12;
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Unicode = 2;
    protected int m_nType;
    protected Constant[] m_aconst;

    public static Constant[] readConstants(DataInput stream) throws IOException {
        int cConst = stream.readUnsignedShort();
        Constant[] aconst = new Constant[cConst];
        for (int i = 1; i < cConst; ++i) {
            int nType = stream.readUnsignedByte();
            Constant constant = null;
            int cExtra = 0;
            switch (nType) {
                case 7: {
                    constant = new ClassConstant(stream);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    constant = new RefConstant(stream);
                    break;
                }
                case 8: {
                    constant = new StringConstant(stream);
                    break;
                }
                case 3: {
                    constant = new IntConstant(stream);
                    break;
                }
                case 4: {
                    constant = new FloatConstant(stream);
                    break;
                }
                case 5: {
                    constant = new LongConstant(stream);
                    cExtra = 1;
                    break;
                }
                case 6: {
                    constant = new DoubleConstant(stream);
                    cExtra = 1;
                    break;
                }
                case 12: {
                    constant = new NameTypeConstant(stream);
                    break;
                }
                case 1: {
                    constant = new UtfConstant(stream);
                    break;
                }
                case 2: {
                    constant = new UnicodeConstant(stream);
                    break;
                }
                default: {
                    throw new IOException("Invalid constant type " + nType + " for constant #" + i);
                }
            }
            constant.m_aconst = aconst;
            constant.m_nType = nType;
            aconst[i] = constant;
            i += cExtra;
        }
        return aconst;
    }

    public int getType() {
        return this.m_nType;
    }

    protected static String format(String s) {
        return LiteralToken.printableString(s);
    }
}

