/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.introspect;

import com.oracle.coherence.common.collections.ChainedIterator;
import com.tangosol.dev.assembler.AbstractAnnotationsAttribute;
import com.tangosol.dev.assembler.Annotation;
import com.tangosol.dev.assembler.Attribute;
import com.tangosol.dev.assembler.ClassFile;
import com.tangosol.dev.assembler.Field;
import com.tangosol.dev.introspect.UrlScanner;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.filter.AlwaysFilter;
import java.io.DataInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ClassAnnotationScanner
implements UrlScanner<String> {
    protected Filter m_filter;
    protected ClassLoader m_loader;

    public ClassAnnotationScanner() {
        this(null);
    }

    public ClassAnnotationScanner(Filter filter) {
        this.m_filter = filter == null ? AlwaysFilter.INSTANCE : filter;
    }

    @Override
    public String scan(URL urlResource) {
        try {
            DataInputStream di = new DataInputStream(urlResource.openStream());
            ClassFile cf = new ClassFile(di);
            String sClassName = cf.getName().replace('/', '.');
            Iterator<Annotation> iterAnnos = this.getAnnotations(cf.getAttributes());
            while (iterAnnos.hasNext()) {
                if (!this.evaluateAnnotation(iterAnnos.next(), sClassName)) continue;
                return sClassName;
            }
        }
        catch (Throwable t) {
            throw Base.ensureRuntimeException(t, "Failed to read resource: " + urlResource);
        }
        return null;
    }

    @Override
    public Set<String> scan(Enumeration<URL> enumResources) {
        HashSet<String> setClassNames = new HashSet<String>();
        while (enumResources.hasMoreElements()) {
            String sClassName = this.scan(enumResources.nextElement());
            if (sClassName == null || setClassNames.contains(sClassName)) continue;
            setClassNames.add(sClassName);
        }
        return setClassNames;
    }

    @Override
    public void setFilter(Filter filter) {
        this.m_filter = filter;
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return this.m_loader == null ? (this.m_loader = Base.getContextClassLoader()) : this.m_loader;
    }

    @Override
    public void setContextClassLoader(ClassLoader loader) {
        this.m_loader = loader;
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    protected Iterator<Annotation> getAnnotations(Enumeration<Attribute> enumAttrs) {
        ArrayList<Iterator> listIters = new ArrayList<Iterator>(0);
        while (enumAttrs.hasMoreElements()) {
            Attribute attr = enumAttrs.nextElement();
            if (!(attr instanceof AbstractAnnotationsAttribute)) continue;
            listIters.add(((AbstractAnnotationsAttribute)attr).getAnnotations());
        }
        return new ChainedIterator<Annotation>(listIters.toArray(new Iterator[listIters.size()]));
    }

    protected boolean evaluateAnnotation(Annotation anno, String sClassName) {
        String sAnnoClassName = Field.toTypeString(anno.getAnnotationType().getValue());
        return InvocableMapHelper.evaluateEntry(this.m_filter, new SimpleMapEntry<String, String>(sClassName, sAnnoClassName));
    }
}

