/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net;

import com.oracle.coherence.common.util.Options;
import com.tangosol.internal.net.SessionNamedCache;
import com.tangosol.internal.net.SessionNamedTopic;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.Releasable;
import com.tangosol.net.Session;
import com.tangosol.net.ValueTypeAssertion;
import com.tangosol.net.cache.TypeAssertion;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.util.Base;
import com.tangosol.util.RegistrationBehavior;
import com.tangosol.util.ResourceRegistry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ConfigurableCacheFactorySession
implements Session {
    private ConfigurableCacheFactory m_ccf;
    private ClassLoader m_classLoader;
    private volatile boolean m_fActive;
    private ConcurrentHashMap<String, ConcurrentHashMap<TypeAssertion, SessionNamedCache>> m_mapCaches;
    private ConcurrentHashMap<String, ConcurrentHashMap<ValueTypeAssertion, SessionNamedTopic>> m_mapTopics;

    public ConfigurableCacheFactorySession(ConfigurableCacheFactory ccf, ClassLoader loader) {
        this.m_ccf = ccf;
        this.m_classLoader = loader == null ? Base.ensureClassLoader(null) : loader;
        this.m_mapCaches = new ConcurrentHashMap();
        this.m_mapTopics = new ConcurrentHashMap();
        this.m_fActive = true;
    }

    @Override
    public <K, V> NamedCache<K, V> getCache(String sName, NamedCache.Option ... options) {
        if (this.m_fActive) {
            ResourceRegistry registry = this.m_ccf.getResourceRegistry();
            registry.registerResource(NamedCacheReferenceCounter.class, sName, NamedCacheReferenceCounter::new, RegistrationBehavior.IGNORE, null);
            ConcurrentHashMap mapCachesByTypeAssertion = this.m_mapCaches.computeIfAbsent(sName, any -> new ConcurrentHashMap());
            Options<NamedCache.Option> optionSet = Options.from(NamedCache.Option.class, options);
            TypeAssertion typeAssertion = optionSet.get(TypeAssertion.class);
            SessionNamedCache cacheSession = mapCachesByTypeAssertion.compute(typeAssertion, (key, value) -> {
                if (value != null && !value.isDestroyed() && !value.isReleased()) {
                    return value;
                }
                NamedCache cacheUnderlying = this.m_ccf.ensureTypedCache(sName, this.m_classLoader, typeAssertion);
                SessionNamedCache cache = new SessionNamedCache(this, cacheUnderlying, typeAssertion);
                registry.getResource(NamedCacheReferenceCounter.class, sName).incrementAndGet();
                return cache;
            });
            return cacheSession;
        }
        throw new IllegalStateException("Session is closed");
    }

    @Override
    public <V> NamedTopic<V> getTopic(String sName, NamedCollection.Option ... options) {
        if (this.m_fActive) {
            ResourceRegistry registry = this.m_ccf.getResourceRegistry();
            registry.registerResource(NamedTopicReferenceCounter.class, sName, NamedTopicReferenceCounter::new, RegistrationBehavior.IGNORE, null);
            ConcurrentHashMap mapTopicsByTypeAssertion = this.m_mapTopics.computeIfAbsent(sName, any -> new ConcurrentHashMap());
            Options<NamedCollection.Option> optionSet = Options.from(NamedCollection.Option.class, options);
            ValueTypeAssertion typeAssertion = optionSet.get(ValueTypeAssertion.class);
            return mapTopicsByTypeAssertion.compute(typeAssertion, (key, value) -> {
                if (value != null && !value.isDestroyed() && !value.isReleased()) {
                    return value;
                }
                NamedTopic topicUnderlying = this.m_ccf.ensureTopic(sName, this.m_classLoader, typeAssertion);
                SessionNamedTopic topic = new SessionNamedTopic(this, topicUnderlying, typeAssertion);
                registry.getResource(NamedTopicReferenceCounter.class, sName).incrementAndGet();
                return topic;
            });
        }
        throw new IllegalStateException("Session is closed");
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.m_fActive) {
            this.m_fActive = false;
            this.m_mapCaches.values().stream().flatMap(mapCachesByAssertion -> mapCachesByAssertion.values().stream()).forEach(SessionNamedCache::close);
            this.m_mapCaches.clear();
            this.m_mapTopics.values().stream().flatMap(mapTopicsByAssertion -> mapTopicsByAssertion.values().stream()).forEach(Releasable::close);
            this.m_mapTopics.clear();
        }
    }

    private void assertActive() {
        if (!this.m_fActive) {
            throw new IllegalStateException("Session is closed");
        }
    }

    <V> void onClose(SessionNamedTopic<V> topic) {
        this.dropNamedTopic(topic);
        topic.onClosing();
        ResourceRegistry registry = this.m_ccf.getResourceRegistry();
        if (registry.getResource(NamedTopicReferenceCounter.class, topic.getName()).decrementAndGet() == 0) {
            this.m_ccf.releaseTopic(topic.getInternalNamedTopic());
        }
        topic.onClosed();
    }

    <V> void onDestroy(SessionNamedTopic<V> topic) {
        this.dropNamedTopic(topic);
        topic.onDestroying();
        ResourceRegistry registry = this.m_ccf.getResourceRegistry();
        registry.getResource(NamedTopicReferenceCounter.class, topic.getName()).reset();
        this.m_ccf.destroyTopic(topic.getInternalNamedTopic());
        topic.onDestroyed();
    }

    <V> void dropNamedTopic(SessionNamedTopic<V> namedTopic) {
        ConcurrentHashMap<ValueTypeAssertion, SessionNamedTopic> mapTopicsByTypeAssertion = this.m_mapTopics.get(namedTopic.getName());
        if (mapTopicsByTypeAssertion != null) {
            mapTopicsByTypeAssertion.remove(namedTopic.getTypeAssertion());
        }
    }

    <K, V> void onClose(SessionNamedCache<K, V> namedCache) {
        this.dropNamedCache(namedCache);
        namedCache.onClosing();
        ResourceRegistry registry = this.m_ccf.getResourceRegistry();
        if (registry.getResource(NamedCacheReferenceCounter.class, namedCache.getCacheName()).decrementAndGet() == 0) {
            this.m_ccf.releaseCache(namedCache.getInternalNamedCache());
        }
        namedCache.onClosed();
    }

    <K, V> void onDestroy(SessionNamedCache<K, V> namedCache) {
        this.dropNamedCache(namedCache);
        namedCache.onDestroying();
        ResourceRegistry registry = this.m_ccf.getResourceRegistry();
        registry.getResource(NamedCacheReferenceCounter.class, namedCache.getCacheName()).reset();
        this.m_ccf.destroyCache(namedCache.getInternalNamedCache());
        namedCache.onDestroyed();
    }

    <K, V> void dropNamedCache(SessionNamedCache<K, V> namedCache) {
        ConcurrentHashMap<TypeAssertion, SessionNamedCache> mapCachesByTypeAssertion = this.m_mapCaches.get(namedCache.getCacheName());
        if (mapCachesByTypeAssertion != null) {
            mapCachesByTypeAssertion.remove(namedCache.getTypeAssertion());
        }
    }

    protected static class NamedTopicReferenceCounter
    extends ReferenceCounter {
        protected NamedTopicReferenceCounter() {
        }
    }

    protected static class NamedCacheReferenceCounter
    extends ReferenceCounter {
        protected NamedCacheReferenceCounter() {
        }
    }

    protected static class ReferenceCounter {
        private AtomicInteger count = new AtomicInteger(0);

        public int get() {
            return this.count.get();
        }

        public int incrementAndGet() {
            return this.count.incrementAndGet();
        }

        public int decrementAndGet() {
            return this.count.decrementAndGet();
        }

        public void reset() {
            this.count.set(0);
        }
    }
}

