/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net;

import com.tangosol.internal.net.ConfigurableCacheFactorySession;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.TypeAssertion;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class SessionNamedCache<K, V>
implements NamedCache<K, V>,
AutoCloseable {
    private ConfigurableCacheFactorySession m_session;
    private NamedCache<K, V> m_cache;
    private TypeAssertion<K, V> m_typeAssertion;
    private MapListenerSupport m_listeners;
    private volatile boolean m_fActive;

    public SessionNamedCache(ConfigurableCacheFactorySession session, NamedCache<K, V> cache, TypeAssertion<K, V> typeAssertion) {
        this.m_session = session;
        this.m_cache = cache;
        this.m_typeAssertion = typeAssertion;
        this.m_fActive = cache.isActive();
        this.m_listeners = new MapListenerSupport();
    }

    @Override
    public String getCacheName() {
        return this.m_cache.getCacheName();
    }

    @Override
    public CacheService getCacheService() {
        return this.m_cache.getCacheService();
    }

    @Override
    public boolean isActive() {
        return this.m_fActive;
    }

    @Override
    public boolean isDestroyed() {
        return this.m_cache.isDestroyed();
    }

    @Override
    public boolean isReleased() {
        return this.m_cache.isReleased();
    }

    @Override
    public void release() {
        this.close();
    }

    @Override
    public void destroy() {
        if (this.m_fActive) {
            this.m_session.onDestroy(this);
        }
    }

    @Override
    public V put(K key, V value, long cMillis) {
        return this.m_cache.put(key, value, cMillis);
    }

    @Override
    public void clear() {
        this.m_cache.clear();
    }

    @Override
    public void truncate() {
        this.m_cache.truncate();
    }

    @Override
    public AsyncNamedCache<K, V> async(AsyncNamedCache.Option ... options) {
        return this.m_cache.async(options);
    }

    @Override
    public void addMapListener(MapListener<? super K, ? super V> listener) {
        this.m_listeners.addListener(listener, (Filter)null, true);
        this.m_cache.addMapListener(listener);
    }

    @Override
    public void removeMapListener(MapListener<? super K, ? super V> listener) {
        this.m_listeners.removeListener(listener, (Filter)null);
        this.m_cache.removeMapListener(listener);
    }

    @Override
    public void addMapListener(MapListener<? super K, ? super V> listener, K key, boolean fLite) {
        this.m_listeners.addListener(listener, key, fLite);
        this.m_cache.addMapListener(listener, (K)key, fLite);
    }

    @Override
    public void removeMapListener(MapListener<? super K, ? super V> listener, K key) {
        this.m_listeners.removeListener(listener, key);
        this.m_cache.removeMapListener(listener, (K)key);
    }

    @Override
    public void addMapListener(MapListener<? super K, ? super V> listener, Filter filter, boolean fLite) {
        this.m_listeners.addListener(listener, filter, fLite);
        this.m_cache.addMapListener(listener, filter, fLite);
    }

    @Override
    public void removeMapListener(MapListener<? super K, ? super V> listener, Filter filter) {
        this.m_listeners.removeListener(listener, filter);
        this.m_cache.removeMapListener(listener, filter);
    }

    @Override
    public int size() {
        return this.m_cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_cache.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_cache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.m_cache.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.m_cache.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.m_cache.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.m_cache.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.m_cache.putAll(m);
    }

    @Override
    public Set<K> keySet() {
        return this.m_cache.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.m_cache.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.m_cache.entrySet();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.m_cache.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.m_cache.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.m_cache.replaceAll(function);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.m_cache.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.m_cache.remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.m_cache.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this.m_cache.replace(key, value);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.m_cache.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.m_cache.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.m_cache.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.m_cache.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public Map<K, V> getAll(Collection<? extends K> colKeys) {
        return this.m_cache.getAll(colKeys);
    }

    @Override
    public void forEach(Collection<? extends K> collKeys, BiConsumer<? super K, ? super V> action) {
        this.m_cache.forEach(collKeys, action);
    }

    @Override
    public boolean lock(Object oKey, long cWait) {
        return this.m_cache.lock(oKey, cWait);
    }

    @Override
    public boolean lock(Object oKey) {
        return this.m_cache.lock(oKey);
    }

    @Override
    public boolean unlock(Object oKey) {
        return this.m_cache.unlock(oKey);
    }

    @Override
    public Set<K> keySet(Filter filter) {
        return this.m_cache.keySet(filter);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(Filter filter) {
        return this.m_cache.entrySet(filter);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(Filter filter, Comparator comparator) {
        return this.m_cache.entrySet(filter, comparator);
    }

    @Override
    public Collection<V> values(Filter filter) {
        return this.m_cache.values(filter);
    }

    @Override
    public Collection<V> values(Filter filter, Comparator comparator) {
        return this.m_cache.values(filter, comparator);
    }

    @Override
    public <T, E> void addIndex(ValueExtractor<? super T, ? extends E> extractor, boolean fOrdered, Comparator<? super E> comparator) {
        this.m_cache.addIndex(extractor, fOrdered, comparator);
    }

    @Override
    public <T, E> void removeIndex(ValueExtractor<? super T, ? extends E> extractor) {
        this.m_cache.removeIndex(extractor);
    }

    @Override
    public void forEach(Filter filter, BiConsumer<? super K, ? super V> action) {
        this.m_cache.forEach(filter, action);
    }

    @Override
    public <R> R invoke(K key, InvocableMap.EntryProcessor<K, V, R> processor) {
        return this.m_cache.invoke(key, processor);
    }

    @Override
    public <R> Map<K, R> invokeAll(InvocableMap.EntryProcessor<K, V, R> processor) {
        return this.m_cache.invokeAll(processor);
    }

    @Override
    public <R> Map<K, R> invokeAll(Collection<? extends K> collKeys, InvocableMap.EntryProcessor<K, V, R> processor) {
        return this.m_cache.invokeAll(collKeys, processor);
    }

    @Override
    public <R> Map<K, R> invokeAll(Filter filter, InvocableMap.EntryProcessor<K, V, R> processor) {
        return this.m_cache.invokeAll(filter, processor);
    }

    @Override
    public <R> R aggregate(InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator) {
        return this.m_cache.aggregate(aggregator);
    }

    @Override
    public <R> R aggregate(Collection<? extends K> collKeys, InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator) {
        return this.m_cache.aggregate(collKeys, aggregator);
    }

    @Override
    public <R> R aggregate(Filter filter, InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator) {
        return this.m_cache.aggregate(filter, aggregator);
    }

    @Override
    public V computeIfAbsent(K key, Remote.Function<? super K, ? extends V> mappingFunction) {
        return this.m_cache.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V computeIfPresent(K key, Remote.BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.m_cache.computeIfPresent((K)key, (Remote.BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V compute(K key, Remote.BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.m_cache.compute((K)key, (Remote.BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V merge(K key, V value, Remote.BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.m_cache.merge(key, (V)value, (Remote.BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public void replaceAll(Remote.BiFunction<? super K, ? super V, ? extends V> function) {
        this.m_cache.replaceAll(function);
    }

    @Override
    public void replaceAll(Collection<? extends K> collKeys, Remote.BiFunction<? super K, ? super V, ? extends V> function) {
        this.m_cache.replaceAll(collKeys, function);
    }

    @Override
    public void replaceAll(Filter filter, Remote.BiFunction<? super K, ? super V, ? extends V> function) {
        this.m_cache.replaceAll(filter, function);
    }

    @Override
    public RemoteStream<InvocableMap.Entry<K, V>> stream() {
        return this.m_cache.stream();
    }

    @Override
    public RemoteStream<InvocableMap.Entry<K, V>> stream(Collection<? extends K> collKeys) {
        return this.m_cache.stream(collKeys);
    }

    @Override
    public RemoteStream<InvocableMap.Entry<K, V>> stream(Filter filter) {
        return this.m_cache.stream(filter);
    }

    @Override
    public <T, E> RemoteStream<E> stream(ValueExtractor<T, ? extends E> extractor) {
        return this.m_cache.stream(extractor);
    }

    @Override
    public <T, E> RemoteStream<E> stream(Collection<? extends K> collKeys, ValueExtractor<T, ? extends E> extractor) {
        return this.m_cache.stream(collKeys, extractor);
    }

    @Override
    public <T, E> RemoteStream<E> stream(Filter filter, ValueExtractor<T, ? extends E> extractor) {
        return this.m_cache.stream(filter, extractor);
    }

    @Override
    public <C extends NamedCache<K, V>> C as(Class<C> clzNamedCache) {
        Base.azzert(clzNamedCache != null, "The specified Class can't be null");
        return (C)(clzNamedCache.isInstance(this) ? this : this.m_cache.as(clzNamedCache));
    }

    @Override
    public synchronized void close() {
        if (this.m_fActive) {
            this.m_session.onClose(this);
        }
    }

    NamedCache<K, V> getInternalNamedCache() {
        return this.m_cache;
    }

    TypeAssertion<K, V> getTypeAssertion() {
        return this.m_typeAssertion;
    }

    void onClosing() {
        this.m_fActive = false;
        this.dropListeners();
    }

    void onClosed() {
    }

    void onDestroying() {
        this.m_fActive = false;
        this.dropListeners();
    }

    void onDestroyed() {
    }

    void dropListeners() {
        this.m_listeners.getKeySet().stream().forEach((? super T key) -> {
            Listeners listeners = this.m_listeners.getListeners(key);
            if (listeners != null) {
                for (EventListener listener : listeners.listeners()) {
                    this.m_cache.removeMapListener((MapListener)listener, key);
                }
            }
        });
        this.m_listeners.getFilterSet().stream().forEach((? super T filter) -> {
            Listeners listeners = this.m_listeners.getListeners(filter);
            if (listeners != null) {
                for (EventListener listener : listeners.listeners()) {
                    this.m_cache.removeMapListener((MapListener)listener, (Filter)filter);
                }
            }
        });
        this.m_listeners.clear();
    }
}

