/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.cluster;

import com.oracle.coherence.common.base.Predicate;
import com.oracle.coherence.common.internal.Platform;
import com.oracle.coherence.common.net.InetAddresses;
import com.tangosol.coherence.config.builder.ActionPolicyBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilderRegistry;
import com.tangosol.coherence.config.builder.ServiceFailurePolicyBuilder;
import com.tangosol.coherence.config.builder.SimpleParameterizedBuilderRegistry;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.internal.net.cluster.ClusterDependencies;
import com.tangosol.internal.net.cluster.DefaultMemberIdentity;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerFactory;
import com.tangosol.io.WrapperStreamFactory;
import com.tangosol.net.AddressProvider;
import com.tangosol.net.AddressProviderFactory;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.MemberIdentity;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.persistence.SnapshotArchiverFactory;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.LiteMap;
import com.tangosol.util.SafeLinkedList;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketOptions;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultClusterDependencies
implements ClusterDependencies {
    private Filter m_authorizedHostFilter;
    private ActionPolicyBuilder m_bldrClusterActionPolicy;
    private int m_cClusterAnnounceTimeout = 3000;
    private int m_cClusterHeartbeatDelay;
    private int m_cClusterTimestampMaxVariance = 16;
    private int m_nEdition = 3;
    private List<String> m_listFilter;
    private Map<String, WrapperStreamFactory> m_mapFilter;
    private boolean m_fFlowControlEnabled = true;
    private InetAddress m_discAddressLocal;
    protected final String DEFAULT_ADDR = "239.192.0.0";
    private InetAddress m_groupAddress;
    private int m_nGroupBufferSize;
    private InetAddress m_groupInterface;
    private int m_nGroupListenerPriority = 10;
    private int m_gGroupPort = 7574;
    private int m_cGroupTimeToLive = 4;
    private int m_nIpMonitorPriority = 6;
    private int m_cIpMonitorAttempts = Platform.getPlatform().isExaEnabled() ? 12 : 3;
    private long m_cMillisIpMonitorTimeout = 5000L;
    private InetAddress m_localAddress;
    private int m_cLocalBufferSize;
    private int m_nLocalListenerPriority = 10;
    private int m_nLocalPort = 0;
    private int m_nLocalPortAutoAdjust = 65535;
    private int m_cLostPacketThreshold = 16;
    private DefaultMemberIdentity m_memberIdentity;
    private int m_nMode = 1;
    private int m_cOutstandingPacketMaximum = 4096;
    private int m_cOutstandingPacketMinimum = 64;
    private double m_dPacketBundlingAggression = 0.0;
    private long m_cPacketBundlingThresholdNanos = 1000L;
    private int m_cbPacketMaxLength = 65535;
    private int m_cbPacketPreferredLength;
    private int m_cPublisherAckDelay = 16;
    private int m_cPublisherSocketBufferSize;
    private int m_cPublisherCloggedCount = 8192;
    private int m_cPublisherCloggedDelayMillis = 10;
    private int m_cPublisherGroupThreshold = 100;
    private int m_cPublisherNackDelay = 1;
    private int m_nPublisherPriority = 10;
    private int m_cPublisherResendDelayMillis = 200;
    private int m_cPublisherResendTimeoutMillis = 300000;
    private long m_cGuardTimeout = this.m_cPublisherResendTimeoutMillis;
    private boolean m_fReceiverNackEnabled = true;
    private int m_nReceiverPriority = 10;
    private transient String m_sReliableTransport;
    private Map<String, List<String>> m_mapServiceFilter;
    private Map<String, String> m_mapService;
    private Map<String, SerializerFactory> m_mapSerializer;
    private Map<String, SnapshotArchiverFactory> m_mapSnapshotArchiver;
    private Map<String, AddressProviderFactory> m_mapAddressProvider;
    private ServiceFailurePolicyBuilder m_bldrServiceFailurePolicy = new ServiceFailurePolicyBuilder(1);
    private int m_nShutdownHookOption = 1;
    private SocketProviderFactory m_socketProviderFactory;
    private XmlElement m_xmlUnicastSocketProvider;
    private int m_nSpeakerPriority = 10;
    private int m_cSpeakerVolumeMinimum = -1;
    private boolean m_fSpeakerEnabled = true;
    private boolean m_fTcmpEnabled = true;
    private int m_cTcpBacklog;
    private SocketOptions m_optionsTcpDatagram;
    private boolean m_fTcpRingEnabled = true;
    private SocketOptions m_optionsTcpRing;
    private AddressProvider m_providerWellKnownAddresses;
    private ParameterizedBuilderRegistry m_builderRegistry;
    private SocketProviderBuilder m_builderUnicastSocketProvider;

    public DefaultClusterDependencies() {
        this(null);
    }

    public DefaultClusterDependencies(com.tangosol.net.ClusterDependencies deps) {
        if (deps == null) {
            this.m_builderRegistry = new SimpleParameterizedBuilderRegistry();
        } else {
            this.m_authorizedHostFilter = deps.getAuthorizedHostFilter();
            this.m_bldrClusterActionPolicy = deps.getClusterActionPolicyBuilder();
            this.m_cClusterAnnounceTimeout = deps.getClusterAnnounceTimeoutMillis();
            this.m_cClusterHeartbeatDelay = deps.getClusterHeartbeatDelayMillis();
            this.m_cClusterTimestampMaxVariance = deps.getClusterTimestampMaxVarianceMillis();
            this.m_nEdition = deps.getEdition();
            this.m_listFilter = deps.getFilterList();
            this.m_mapFilter = deps.getFilterMap();
            this.m_fFlowControlEnabled = deps.isFlowControlEnabled();
            this.m_discAddressLocal = deps.getLocalDiscoveryAddress();
            this.m_groupAddress = deps.getGroupAddress();
            this.m_nGroupBufferSize = deps.getGroupBufferSize();
            this.m_groupInterface = deps.getGroupInterface();
            this.m_nGroupListenerPriority = deps.getGroupListenerPriority();
            this.m_gGroupPort = deps.getGroupPort();
            this.m_cGroupTimeToLive = deps.getGroupTimeToLive();
            this.m_cGuardTimeout = deps.getGuardTimeoutMillis();
            this.m_cIpMonitorAttempts = deps.getIpMonitorAttempts();
            this.m_nIpMonitorPriority = deps.getIpMonitorPriority();
            this.m_cMillisIpMonitorTimeout = deps.getIpMonitorTimeoutMillis();
            this.m_cLocalBufferSize = deps.getLocalBufferSize();
            this.m_nLocalListenerPriority = deps.getLocalListenerPriority();
            this.m_nLocalPort = deps.getLocalPort();
            this.m_nLocalPortAutoAdjust = deps.getLocalPortAutoAdjust();
            this.m_cLostPacketThreshold = deps.getLostPacketThreshold();
            this.m_nMode = deps.getMode();
            this.m_cOutstandingPacketMaximum = deps.getOutstandingPacketMaximum();
            this.m_cOutstandingPacketMinimum = deps.getOutstandingPacketMinimum();
            this.m_dPacketBundlingAggression = deps.getPacketBundlingAggression();
            this.m_cPacketBundlingThresholdNanos = deps.getPacketBundlingThresholdNanos();
            this.m_cbPacketMaxLength = deps.getPacketMaxLength();
            this.m_cbPacketPreferredLength = deps.getPacketPreferredLength();
            this.m_cPublisherAckDelay = deps.getPublisherAckDelayMillis();
            this.m_cPublisherSocketBufferSize = deps.getPublisherSocketBufferSize();
            this.m_cPublisherCloggedCount = deps.getPublisherCloggedCount();
            this.m_cPublisherCloggedDelayMillis = deps.getPublisherCloggedDelayMillis();
            this.m_cPublisherGroupThreshold = deps.getPublisherGroupThreshold();
            this.m_cPublisherNackDelay = deps.getPublisherNackDelayMillis();
            this.m_nPublisherPriority = deps.getPublisherPriority();
            this.m_cPublisherResendDelayMillis = deps.getPublisherResendDelayMillis();
            this.m_cPublisherResendTimeoutMillis = deps.getPublisherResendTimeoutMillis();
            this.m_fReceiverNackEnabled = deps.isReceiverNackEnabled();
            this.m_nReceiverPriority = deps.getReceiverPriority();
            this.m_sReliableTransport = deps.getReliableTransport();
            this.m_mapSerializer = deps.getSerializerMap();
            this.m_mapSnapshotArchiver = deps.getSnapshotArchiverMap();
            this.m_mapAddressProvider = deps.getAddressProviderMap();
            this.m_bldrServiceFailurePolicy = deps.getServiceFailurePolicyBuilder();
            this.m_mapServiceFilter = deps.getServiceFilterMap();
            this.m_mapService = deps.getServiceMap();
            this.m_nShutdownHookOption = deps.getShutdownHookOption();
            this.m_socketProviderFactory = deps.getSocketProviderFactory();
            this.m_xmlUnicastSocketProvider = deps.getUnicastSocketProviderXml();
            this.m_nSpeakerPriority = deps.getSpeakerPriority();
            this.m_cSpeakerVolumeMinimum = deps.getSpeakerVolumeMinimum();
            this.m_fSpeakerEnabled = deps.isSpeakerEnabled();
            this.m_fTcmpEnabled = deps.isTcmpEnabled();
            this.m_cTcpBacklog = deps.getTcpBacklog();
            this.m_optionsTcpDatagram = deps.getTcpDatagramSocketOptions();
            this.m_fTcpRingEnabled = deps.isTcpRingEnabled();
            this.m_optionsTcpRing = deps.getTcpRingSocketOptions();
            this.m_providerWellKnownAddresses = deps.getWellKnownAddresses();
            this.m_localAddress = deps.getLocalAddress();
            this.m_builderRegistry = new SimpleParameterizedBuilderRegistry(deps.getBuilderRegistry());
            this.m_builderUnicastSocketProvider = deps.getUnicastSocketProviderBuilder();
            this.setMemberIdentity(deps.getMemberIdentity());
        }
    }

    @Override
    public Filter getAuthorizedHostFilter() {
        return this.m_authorizedHostFilter;
    }

    public DefaultClusterDependencies setAuthorizedHostFilter(Filter filter) {
        this.m_authorizedHostFilter = filter;
        return this;
    }

    @Override
    public ActionPolicyBuilder getClusterActionPolicyBuilder() {
        return this.m_bldrClusterActionPolicy;
    }

    public DefaultClusterDependencies setClusterActionPolicyBuilder(ActionPolicyBuilder builder) {
        this.m_bldrClusterActionPolicy = builder;
        return this;
    }

    @Override
    public int getClusterAnnounceTimeoutMillis() {
        return this.m_cClusterAnnounceTimeout;
    }

    public DefaultClusterDependencies setClusterAnnounceTimeoutMillis(int cMillis) {
        this.m_cClusterAnnounceTimeout = Math.max(100, cMillis);
        return this;
    }

    @Override
    public int getClusterHeartbeatDelayMillis() {
        int cMillis = this.m_cClusterHeartbeatDelay;
        if (cMillis == 0) {
            this.m_cClusterHeartbeatDelay = cMillis = Math.min(1000, this.getClusterAnnounceTimeoutMillis() / 3);
        }
        return cMillis;
    }

    public DefaultClusterDependencies setClusterHeartbeatDelayMillis(int cMillis) {
        this.m_cClusterHeartbeatDelay = cMillis;
        return this;
    }

    @Override
    public int getClusterTimestampMaxVarianceMillis() {
        return this.m_cClusterTimestampMaxVariance;
    }

    public DefaultClusterDependencies setClusterTimestampMaxVarianceMillis(int cMillis) {
        this.m_cClusterTimestampMaxVariance = cMillis;
        return this;
    }

    @Override
    public int getEdition() {
        return this.m_nEdition;
    }

    public DefaultClusterDependencies setEdition(int n) {
        this.m_nEdition = n;
        return this;
    }

    @Override
    public Map<String, WrapperStreamFactory> getFilterMap() {
        Map<String, WrapperStreamFactory> mapFilter = this.m_mapFilter;
        if (mapFilter == null) {
            this.m_mapFilter = mapFilter = new LiteMap<String, WrapperStreamFactory>();
        }
        return mapFilter;
    }

    public DefaultClusterDependencies setFilterMap(Map<String, WrapperStreamFactory> mapFilter) {
        this.m_mapFilter = mapFilter;
        return this;
    }

    @Override
    public List<String> getFilterList() {
        SafeLinkedList listFilter = this.m_listFilter;
        if (listFilter == null) {
            this.m_listFilter = listFilter = new SafeLinkedList();
        }
        return listFilter;
    }

    public DefaultClusterDependencies setFilterList(List<String> listFilter) {
        this.m_listFilter = listFilter;
        return this;
    }

    @Override
    public boolean isFlowControlEnabled() {
        return this.m_fFlowControlEnabled;
    }

    public DefaultClusterDependencies setFlowControlEnabled(boolean fEnabled) {
        this.m_fFlowControlEnabled = fEnabled;
        return this;
    }

    public DefaultClusterDependencies setLocalDiscoveryAddress(InetAddress addr) {
        this.m_discAddressLocal = addr;
        return this;
    }

    @Override
    public InetAddress getLocalDiscoveryAddress() {
        InetAddress addr = this.m_discAddressLocal;
        if (addr == null) {
            this.m_discAddressLocal = addr = InetAddresses.ADDR_ANY;
        }
        return addr;
    }

    @Override
    public InetAddress getGroupAddress() {
        InetAddress addr = this.m_groupAddress;
        if (addr == null) {
            try {
                this.m_groupAddress = addr = InetAddress.getByName("239.192.0.0");
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e, "Unable to resolve default group address 239.192.0.0");
            }
        }
        return addr;
    }

    public DefaultClusterDependencies setGroupAddress(InetAddress addr) {
        this.m_groupAddress = addr;
        return this;
    }

    @Override
    public int getGroupBufferSize() {
        return this.m_nGroupBufferSize;
    }

    public DefaultClusterDependencies setGroupBufferSize(int nSize) {
        this.m_nGroupBufferSize = nSize;
        return this;
    }

    @Override
    public InetAddress getGroupInterface() {
        InetAddress addrIf = this.m_groupInterface;
        if (addrIf == null) {
            this.m_groupInterface = addrIf = this.getLocalDiscoveryAddress();
        }
        return addrIf;
    }

    public DefaultClusterDependencies setGroupInterface(InetAddress addr) {
        this.m_groupInterface = addr;
        return this;
    }

    @Override
    public int getGroupListenerPriority() {
        return this.m_nGroupListenerPriority;
    }

    public DefaultClusterDependencies setGroupListenerPriority(int nPriority) {
        this.m_nGroupListenerPriority = nPriority;
        return this;
    }

    @Override
    public int getGroupPort() {
        return this.m_gGroupPort;
    }

    public DefaultClusterDependencies setGroupPort(int nPort) {
        this.m_gGroupPort = nPort;
        return this;
    }

    @Override
    public int getGroupTimeToLive() {
        return this.m_cGroupTimeToLive;
    }

    public DefaultClusterDependencies setGroupTimeToLive(int cHops) {
        this.m_cGroupTimeToLive = cHops;
        return this;
    }

    @Override
    public long getGuardTimeoutMillis() {
        return this.m_cGuardTimeout;
    }

    public DefaultClusterDependencies setGuardTimeoutMillis(long cTimeout) {
        this.m_cGuardTimeout = cTimeout;
        return this;
    }

    @Override
    public int getIpMonitorAttempts() {
        return this.m_cIpMonitorAttempts;
    }

    public DefaultClusterDependencies setIpMonitorAttempts(int cAttempts) {
        this.m_cIpMonitorAttempts = cAttempts;
        return this;
    }

    @Override
    public int getIpMonitorPriority() {
        return this.m_nIpMonitorPriority;
    }

    public DefaultClusterDependencies setIpMonitorPriority(int nPriority) {
        this.m_nIpMonitorPriority = nPriority;
        return this;
    }

    @Override
    public long getIpMonitorTimeoutMillis() {
        return this.m_cMillisIpMonitorTimeout;
    }

    public DefaultClusterDependencies setIpMonitorTimeoutMillis(long cMillis) {
        this.m_cMillisIpMonitorTimeout = cMillis;
        return this;
    }

    @Override
    public InetAddress getLocalAddress() {
        InetAddress addr = this.m_localAddress;
        if (addr == null) {
            InetAddress addrDiscovery = this.getLocalDiscoveryAddress();
            if (!addrDiscovery.isAnyLocalAddress()) {
                return addrDiscovery;
            }
            AddressProvider providerWka = this.getWellKnownAddresses();
            if (providerWka != null) {
                InetAddress addrPeer = null;
                InetSocketAddress addrWKA = providerWka.getNextAddress();
                while (addrWKA != null) {
                    InetAddress addrWkaIP = addrWKA.getAddress();
                    if (InetAddresses.isLocalAddress(addrWkaIP)) {
                        this.m_localAddress = addrWkaIP;
                        return this.m_localAddress;
                    }
                    if (addrPeer == null) {
                        addrPeer = InetAddresses.getLocalPeer(addrWkaIP);
                    }
                    addrWKA = providerWka.getNextAddress();
                }
                this.m_localAddress = addrPeer;
                return this.m_localAddress;
            }
        }
        return addr;
    }

    public InetAddress computeLocalAddress() {
        InetAddress addr = this.m_localAddress;
        if (addr == null) {
            InetAddress addrDiscovery = this.getLocalDiscoveryAddress();
            if (!addrDiscovery.isAnyLocalAddress()) {
                return addrDiscovery;
            }
            try {
                final AddressProvider providerWka = this.getWellKnownAddresses();
                if (providerWka == null) {
                    addr = InetAddresses.getLocalHost();
                } else {
                    InetAddresses.IsRoutable predRouteable = InetAddresses.IsRoutable.INSTANCE;
                    do {
                        final InetAddresses.IsRoutable predCompound = predRouteable;
                        try {
                            final Collection<InetAddress> listAddrRoute = InetAddresses.getRoutes(InetAddresses.getAllLocalAddresses(), (Iterable<? extends InetAddress>)new Iterable<InetAddress>(){

                                @Override
                                public Iterator<InetAddress> iterator() {
                                    return new Iterator<InetAddress>(){
                                        InetSocketAddress m_addrNext;
                                        {
                                            this.m_addrNext = providerWka.getNextAddress();
                                        }

                                        @Override
                                        public boolean hasNext() {
                                            return this.m_addrNext != null;
                                        }

                                        @Override
                                        public InetAddress next() {
                                            InetSocketAddress addrNext = this.m_addrNext;
                                            this.m_addrNext = providerWka.getNextAddress();
                                            return addrNext.getAddress();
                                        }

                                        @Override
                                        public void remove() {
                                            throw new UnsupportedOperationException();
                                        }
                                    };
                                }
                            });
                            addr = InetAddresses.getLocalAddress(new Predicate<InetAddress>(){

                                @Override
                                public boolean evaluate(InetAddress addr) {
                                    return listAddrRoute.contains(addr) && (predCompound == null || predCompound.evaluate(addr));
                                }

                                public String toString() {
                                    return listAddrRoute.toString() + (predCompound == null ? "" : " and " + predCompound);
                                }
                            });
                        }
                        catch (UnknownHostException e) {
                            if (predRouteable == null) {
                                throw e;
                            }
                            predRouteable = null;
                        }
                    } while (addr == null);
                }
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException(e);
            }
        }
        return addr;
    }

    public DefaultClusterDependencies setLocalAddress(InetAddress addr) {
        this.m_localAddress = addr;
        return this;
    }

    @Override
    public int getLocalBufferSize() {
        return this.m_cLocalBufferSize;
    }

    public DefaultClusterDependencies setLocalBufferSize(int cPackets) {
        this.m_cLocalBufferSize = cPackets;
        return this;
    }

    @Override
    public int getLocalListenerPriority() {
        return this.m_nLocalListenerPriority;
    }

    public DefaultClusterDependencies setLocalListenerPriority(int nPriority) {
        this.m_nLocalListenerPriority = nPriority;
        return this;
    }

    @Override
    public int getLocalPort() {
        return this.m_nLocalPort;
    }

    public DefaultClusterDependencies setLocalPort(int nPort) {
        this.m_nLocalPort = nPort;
        return this;
    }

    @Override
    public boolean isLocalPortAutoAdjust() {
        return this.m_nLocalPortAutoAdjust != 0;
    }

    @Override
    public int getLocalPortAutoAdjust() {
        return this.m_nLocalPortAutoAdjust;
    }

    public DefaultClusterDependencies setLocalPortAutoAdjust(boolean fPortAuto) {
        this.m_nLocalPortAutoAdjust = fPortAuto ? 65535 : 0;
        return this;
    }

    public DefaultClusterDependencies setLocalPortAutoAdjust(int nPortAuto) {
        this.m_nLocalPortAutoAdjust = nPortAuto;
        return this;
    }

    @Override
    public int getLostPacketThreshold() {
        return this.m_cLostPacketThreshold;
    }

    public DefaultClusterDependencies setLostPacketThreshold(int cPackets) {
        this.m_cLostPacketThreshold = cPackets;
        return this;
    }

    @Override
    public DefaultMemberIdentity getMemberIdentity() {
        return this.m_memberIdentity;
    }

    public DefaultClusterDependencies setMemberIdentity(MemberIdentity identity) {
        this.m_memberIdentity = new DefaultMemberIdentity(identity){

            @Override
            public String getClusterName() {
                String sName = super.getClusterName();
                if (sName == null || sName.isEmpty()) {
                    sName = DefaultClusterDependencies.this.makeClusterName();
                    CacheFactory.log("The cluster name has not been configured, a value of \"" + sName + "\" has been automatically generated", DefaultClusterDependencies.this.getMode() == 2 ? 2 : 3);
                    this.setClusterName(sName);
                }
                return sName;
            }

            @Override
            public String getMachineName() {
                String sMachineName = super.getMachineName();
                if (sMachineName == null) {
                    sMachineName = DefaultClusterDependencies.this.makeMachineName();
                    super.setMachineName(sMachineName);
                }
                return sMachineName;
            }

            @Override
            public int getMachineId() {
                int nMachineId = super.getMachineId();
                if (nMachineId == 0) {
                    nMachineId = this.makeMachineId();
                    this.setMachineId(nMachineId);
                }
                return nMachineId;
            }

            @Override
            public String getSiteName() {
                String sSiteName = super.getSiteName();
                if (sSiteName == null) {
                    sSiteName = DefaultClusterDependencies.this.makeSiteName();
                    super.setSiteName(sSiteName);
                }
                return sSiteName;
            }

            protected int makeMachineId() {
                String sId = this.getMachineName();
                if (sId == null || sId.length() == 66 && sId.equals(DefaultClusterDependencies.this.makeMachineName())) {
                    sId = null;
                    try {
                        Class<?> clz = Class.forName("com.oracle.exalogic.ExaManager");
                        sId = (String)ClassHelper.invoke(clz, ClassHelper.invokeStatic(clz, "instance", null), "getHostUUID", null);
                        if (Character.isDigit(sId.charAt(0))) {
                            try {
                                return Integer.parseInt(sId) & 0xFFFF;
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (sId == null) {
                        sId = DefaultClusterDependencies.this.computeLocalAddress().getHostAddress();
                    }
                }
                return sId.hashCode() & 0xFFFF;
            }
        };
        return this;
    }

    @Override
    public int getMode() {
        return this.m_nMode;
    }

    public DefaultClusterDependencies setMode(int nMode) {
        this.m_nMode = nMode;
        return this;
    }

    @Override
    public int getOutstandingPacketMaximum() {
        return this.m_cOutstandingPacketMaximum;
    }

    public DefaultClusterDependencies setOutstandingPacketMaximum(int cPackets) {
        this.m_cOutstandingPacketMaximum = cPackets;
        return this;
    }

    @Override
    public int getOutstandingPacketMinimum() {
        return this.m_cOutstandingPacketMinimum;
    }

    public DefaultClusterDependencies setOutstandingPacketMinimum(int cPackets) {
        this.m_cOutstandingPacketMinimum = cPackets;
        return this;
    }

    @Override
    public double getPacketBundlingAggression() {
        return this.m_dPacketBundlingAggression;
    }

    public DefaultClusterDependencies setPacketBundlingAggression(double dAggression) {
        this.m_dPacketBundlingAggression = dAggression;
        return this;
    }

    @Override
    public long getPacketBundlingThresholdNanos() {
        return this.m_cPacketBundlingThresholdNanos;
    }

    public DefaultClusterDependencies setPacketBundlingThresholdNanos(long cNanos) {
        this.m_cPacketBundlingThresholdNanos = cNanos;
        return this;
    }

    @Override
    public int getPacketMaxLength() {
        return this.m_cbPacketMaxLength;
    }

    public DefaultClusterDependencies setPacketMaxLength(int cbMax) {
        this.m_cbPacketMaxLength = cbMax;
        return this;
    }

    @Override
    public int getPacketPreferredLength() {
        return this.m_cbPacketPreferredLength;
    }

    public DefaultClusterDependencies setPacketPreferredLength(int cb) {
        this.m_cbPacketPreferredLength = cb;
        return this;
    }

    @Override
    public int getPublisherAckDelayMillis() {
        return this.m_cPublisherAckDelay;
    }

    public DefaultClusterDependencies setPublisherAckDelayMillis(int cMillis) {
        this.m_cPublisherAckDelay = cMillis;
        return this;
    }

    @Override
    public int getPublisherSocketBufferSize() {
        return this.m_cPublisherSocketBufferSize;
    }

    public DefaultClusterDependencies setPublisherSocketBufferSize(int cPackets) {
        this.m_cPublisherSocketBufferSize = cPackets;
        return this;
    }

    @Override
    public int getPublisherCloggedCount() {
        return this.m_cPublisherCloggedCount;
    }

    public DefaultClusterDependencies setPublisherCloggedCount(int cMax) {
        this.m_cPublisherCloggedCount = cMax;
        return this;
    }

    @Override
    public int getPublisherCloggedDelayMillis() {
        return this.m_cPublisherCloggedDelayMillis;
    }

    public DefaultClusterDependencies setPublisherCloggedDelayMillis(int cMillis) {
        this.m_cPublisherCloggedDelayMillis = cMillis;
        return this;
    }

    @Override
    public int getPublisherGroupThreshold() {
        return this.m_cPublisherGroupThreshold;
    }

    public DefaultClusterDependencies setPublisherGroupThreshold(int cPercent) {
        this.m_cPublisherGroupThreshold = cPercent;
        return this;
    }

    @Override
    public int getPublisherNackDelayMillis() {
        return this.m_cPublisherNackDelay;
    }

    public DefaultClusterDependencies setPublisherNackDelayMillis(int cMillis) {
        this.m_cPublisherNackDelay = cMillis;
        return this;
    }

    @Override
    public int getPublisherPriority() {
        return this.m_nPublisherPriority;
    }

    public DefaultClusterDependencies setPublisherPriority(int nPriority) {
        this.m_nPublisherPriority = nPriority;
        return this;
    }

    @Override
    public int getPublisherResendDelayMillis() {
        return this.m_cPublisherResendDelayMillis;
    }

    public DefaultClusterDependencies setPublisherResendDelayMillis(int cMillis) {
        this.m_cPublisherResendDelayMillis = cMillis;
        return this;
    }

    @Override
    public int getPublisherResendTimeoutMillis() {
        return this.m_cPublisherResendTimeoutMillis;
    }

    public DefaultClusterDependencies setPublisherResendTimeoutMillis(int cMillis) {
        this.m_cPublisherResendTimeoutMillis = cMillis;
        return this;
    }

    @Override
    public boolean isReceiverNackEnabled() {
        return this.m_fReceiverNackEnabled;
    }

    public DefaultClusterDependencies setReceiverNackEnabled(boolean fEnabled) {
        this.m_fReceiverNackEnabled = fEnabled;
        return this;
    }

    @Override
    public int getReceiverPriority() {
        return this.m_nReceiverPriority;
    }

    public DefaultClusterDependencies setReceiverPriority(int nPriority) {
        this.m_nReceiverPriority = nPriority;
        return this;
    }

    @Override
    public String getReliableTransport() {
        return this.m_sReliableTransport;
    }

    public DefaultClusterDependencies setReliableTransport(String sName) {
        this.m_sReliableTransport = sName;
        return this;
    }

    @Override
    public Map<String, SerializerFactory> getSerializerMap() {
        if (this.m_mapSerializer == null) {
            this.m_mapSerializer = new LiteMap<String, SerializerFactory>();
        }
        if (this.m_mapSerializer.isEmpty()) {
            for (final ParameterizedBuilderRegistry.Registration r : this.getBuilderRegistry()) {
                if (!r.getInstanceClass().isAssignableFrom(Serializer.class)) continue;
                this.m_mapSerializer.put(r.getName(), new SerializerFactory(){

                    @Override
                    public Serializer createSerializer(ClassLoader loader) {
                        Serializer serializer = (Serializer)r.getBuilder().realize(new NullParameterResolver(), loader, null);
                        if (serializer instanceof ClassLoaderAware) {
                            ((ClassLoaderAware)((Object)serializer)).setContextClassLoader(loader);
                        }
                        return serializer;
                    }
                });
            }
        }
        return this.m_mapSerializer;
    }

    @Override
    public Map<String, SnapshotArchiverFactory> getSnapshotArchiverMap() {
        Map<String, SnapshotArchiverFactory> mapSnapshotArchiver = this.m_mapSnapshotArchiver;
        if (mapSnapshotArchiver == null) {
            this.m_mapSnapshotArchiver = mapSnapshotArchiver = new LiteMap<String, SnapshotArchiverFactory>();
        }
        return mapSnapshotArchiver;
    }

    public DefaultClusterDependencies setSnapshotArchiverMap(Map<String, SnapshotArchiverFactory> mapSnapshotArchiver) {
        this.m_mapSnapshotArchiver = mapSnapshotArchiver;
        return this;
    }

    @Override
    public Map<String, AddressProviderFactory> getAddressProviderMap() {
        Map<String, AddressProviderFactory> mapAddressProvider = this.m_mapAddressProvider;
        if (mapAddressProvider == null) {
            this.m_mapAddressProvider = mapAddressProvider = new LiteMap<String, AddressProviderFactory>();
        }
        return mapAddressProvider;
    }

    public DefaultClusterDependencies setAddressProviderMap(Map<String, AddressProviderFactory> mapAddressProvider) {
        this.m_mapAddressProvider = mapAddressProvider;
        return this;
    }

    @Override
    public ServiceFailurePolicyBuilder getServiceFailurePolicyBuilder() {
        return this.m_bldrServiceFailurePolicy;
    }

    public DefaultClusterDependencies setServiceFailurePolicyBuilder(ServiceFailurePolicyBuilder builder) {
        this.m_bldrServiceFailurePolicy = builder;
        return this;
    }

    @Override
    public Map<String, List<String>> getServiceFilterMap() {
        Map<String, List<String>> mapServiceFilter = this.m_mapServiceFilter;
        if (mapServiceFilter == null) {
            this.m_mapServiceFilter = mapServiceFilter = new LiteMap<String, List<String>>();
        }
        return mapServiceFilter;
    }

    public DefaultClusterDependencies setServiceFilterMap(Map<String, List<String>> mapServiceFilter) {
        this.m_mapServiceFilter = mapServiceFilter;
        return this;
    }

    @Override
    public Map<String, String> getServiceMap() {
        Map<String, String> mapService = this.m_mapService;
        if (mapService == null) {
            this.m_mapService = mapService = new LiteMap<String, String>();
        }
        return mapService;
    }

    public DefaultClusterDependencies setServiceMap(Map<String, String> mapService) {
        this.m_mapService = mapService;
        return this;
    }

    @Override
    public int getShutdownHookOption() {
        return this.m_nShutdownHookOption;
    }

    public DefaultClusterDependencies setShutdownHookOption(int nOption) {
        this.m_nShutdownHookOption = nOption;
        return this;
    }

    @Override
    public SocketProviderFactory getSocketProviderFactory() {
        SocketProviderFactory socketProviderFactory = this.m_socketProviderFactory;
        if (socketProviderFactory == null) {
            this.m_socketProviderFactory = socketProviderFactory = new SocketProviderFactory();
        }
        return socketProviderFactory;
    }

    public DefaultClusterDependencies setSocketProviderFactory(SocketProviderFactory factory) {
        this.m_socketProviderFactory = factory;
        return this;
    }

    @Override
    @Deprecated
    public XmlElement getUnicastSocketProviderXml() {
        return this.m_xmlUnicastSocketProvider;
    }

    @Deprecated
    public DefaultClusterDependencies setUnicastSocketProviderXml(XmlElement xmlProvider) {
        this.m_xmlUnicastSocketProvider = xmlProvider;
        return this;
    }

    @Override
    public SocketProviderBuilder getUnicastSocketProviderBuilder() {
        return this.m_builderUnicastSocketProvider;
    }

    @Injectable(value="socket-provider")
    public DefaultClusterDependencies setUnicastSocketProviderBuilder(SocketProviderBuilder builder) {
        this.m_builderUnicastSocketProvider = builder;
        return this;
    }

    @Override
    public int getSpeakerPriority() {
        return this.m_nSpeakerPriority;
    }

    public DefaultClusterDependencies setSpeakerPriority(int nPriority) {
        this.m_nSpeakerPriority = nPriority;
        return this;
    }

    @Override
    public int getSpeakerVolumeMinimum() {
        return this.m_cSpeakerVolumeMinimum;
    }

    public DefaultClusterDependencies setSpeakerVolumeMinimum(int cVolume) {
        this.m_cSpeakerVolumeMinimum = cVolume;
        return this;
    }

    @Override
    public boolean isSpeakerEnabled() {
        return this.m_fSpeakerEnabled;
    }

    public DefaultClusterDependencies setSpeakerEnabled(boolean fEnabled) {
        this.m_fSpeakerEnabled = fEnabled;
        return this;
    }

    @Override
    public boolean isTcmpEnabled() {
        return this.m_fTcmpEnabled;
    }

    public DefaultClusterDependencies setTcmpEnabled(boolean fEnabled) {
        this.m_fTcmpEnabled = fEnabled;
        return this;
    }

    @Override
    public int getTcpBacklog() {
        return this.m_cTcpBacklog;
    }

    public DefaultClusterDependencies setTcpBacklog(int cPeers) {
        this.m_cTcpBacklog = cPeers;
        return this;
    }

    @Override
    public SocketOptions getTcpDatagramSocketOptions() {
        return this.m_optionsTcpDatagram;
    }

    public DefaultClusterDependencies setTcpDatagramSocketOptions(SocketOptions options) {
        this.m_optionsTcpDatagram = options;
        return this;
    }

    @Override
    public SocketOptions getTcpRingSocketOptions() {
        return this.m_optionsTcpRing;
    }

    public DefaultClusterDependencies setTcpRingSocketOptions(SocketOptions options) {
        this.m_optionsTcpRing = options;
        return this;
    }

    @Override
    public boolean isTcpRingEnabled() {
        return this.m_fTcpRingEnabled;
    }

    public DefaultClusterDependencies setTcpRingEnabled(boolean fEnabled) {
        this.m_fTcpRingEnabled = fEnabled;
        return this;
    }

    @Override
    public AddressProvider getWellKnownAddresses() {
        return this.m_providerWellKnownAddresses;
    }

    public DefaultClusterDependencies setWellKnownAddresses(AddressProvider provider) {
        this.m_providerWellKnownAddresses = provider;
        return this;
    }

    @Override
    public boolean isIpMonitorEnabled() {
        return this.getIpMonitorTimeoutMillis() * (long)this.getIpMonitorAttempts() > 0L;
    }

    @Override
    public ParameterizedBuilderRegistry getBuilderRegistry() {
        return this.m_builderRegistry;
    }

    public DefaultClusterDependencies validate() {
        Base.checkNotNull(this.getMemberIdentity(), "MemberIdentity");
        this.getMemberIdentity().validate();
        this.validateGuardTimeout();
        Base.checkNotNull(this.getServiceMap(), "Services");
        Base.checkNotNull(this.getFilterMap(), "FilterMap");
        Base.checkNotNull(this.getFilterList(), "FilterList");
        Base.checkNotNull(this.getLocalDiscoveryAddress(), "LocalDiscoveryAddress");
        Base.checkNotNull(this.getMemberIdentity(), "MemberIdentity");
        Base.checkNotNull(this.getSerializerMap(), "SerializerMap");
        Base.checkNotNull(this.getAddressProviderMap(), "AddressProviderMap");
        Base.checkNotNull(this.getServiceFailurePolicyBuilder(), "ServiceFailurePolicyBuilder");
        Base.checkNotNull(this.getBuilderRegistry(), "BuilderRegistry");
        Base.checkNotNull(this.getServiceFilterMap(), "ServiceFilterMap");
        Base.checkNotNull(this.getServiceMap(), "ServiceMap");
        Base.checkNotNull(this.getSocketProviderFactory(), "SocketProviderFactory");
        Base.checkRange(this.getClusterAnnounceTimeoutMillis(), 0L, 1000000L, "ClusterAnnounceTimeoutMillis");
        Base.checkRange(this.getClusterHeartbeatDelayMillis(), 0L, 60000L, "ClusterHeartbeatDelayMillis");
        Base.checkRange(this.getClusterTimestampMaxVarianceMillis(), 1L, 1000L, "ClusterTimestampMaxVarianceMillis");
        Base.checkRange(this.getGroupListenerPriority(), 1L, 10L, "GroupListenerPriority");
        Base.checkRange(this.getGroupPort(), 1L, 65536L, "GroupPort");
        Base.checkRange(this.getGroupTimeToLive(), 0L, 255L, "GroupTimeToLive");
        Base.checkRange(this.getIpMonitorPriority(), 1L, 10L, "IpMonitorPriority");
        Base.checkRange(this.getLocalListenerPriority(), 1L, 10L, "LocalListenerPriority");
        Base.checkRange(this.getLocalPort(), 0L, 65535L, "LocalPort");
        Base.checkRange(this.getPacketMaxLength(), 0L, 65535L, "PacketMaxLength");
        Base.checkRange(this.getPacketPreferredLength(), 0L, 65535L, "PacketPreferredLength");
        Base.checkRange(this.getPublisherAckDelayMillis(), 0L, 60000L, "PublisherAckDelayMillis");
        Base.checkRange(this.getPublisherCloggedDelayMillis(), 0L, 60000L, "PublisherCloggedDelayMillis");
        Base.checkRange(this.getPublisherGroupThreshold(), 0L, 100L, "PublisherGroupThreshold");
        Base.checkRange(this.getPublisherPriority(), 1L, 10L, "PublisherPriority");
        Base.checkRange(this.getPublisherResendDelayMillis(), 0L, 60000L, "PublisherResendDelayMillis");
        Base.checkRange(this.getPublisherResendTimeoutMillis(), 0L, 1000000L, "PublisherResendTimeoutMillis");
        Base.checkRange(this.getReceiverPriority(), 1L, 10L, "ReceiverPriority");
        Base.checkRange(this.getSpeakerPriority(), 1L, 10L, "SpeakerPriority");
        return this;
    }

    public String toString() {
        return "DefaultClusterDependencies{\n\tAuthorizedHostFilter          = " + this.getAuthorizedHostFilter() + "\n\tClusterActionPolicyBuilder    = " + this.getClusterActionPolicyBuilder() + "\n\tBuilderRegistry               = " + this.getBuilderRegistry() + "\n\tClusterAnnounceTimeout        = " + this.getClusterAnnounceTimeoutMillis() + "\n\tClusterHeartbeatDelay         = " + this.getClusterHeartbeatDelayMillis() + "\n\tClusterTimestampMaxVariance   = " + this.getClusterTimestampMaxVarianceMillis() + "\n\tEdition                       = " + this.getEdition() + "\n\tFilterList                    = " + this.getFilterList() + "\n\tFilterMap                     = " + this.getFilterMap() + "\n\tServiceFilterMap              = " + this.getServiceFilterMap() + "\n\tGroupAddress                  = " + this.getGroupAddress() + "\n\tGroupBufferSize               = " + this.getGroupBufferSize() + "\n\tGroupInterface                = " + this.getGroupInterface() + "\n\tGroupTimeToLive               = " + this.getGroupTimeToLive() + "\n\tGuardTimeout                  = " + this.getGuardTimeoutMillis() + "\n\tIpMonitorAttempts             = " + this.getIpMonitorAttempts() + "\n\tIpMonitorPriority             = " + this.getIpMonitorPriority() + "\n\tLocalAddress                  = " + this.getLocalAddress() + "\n\tLocalBufferSize               = " + this.getLocalBufferSize() + "\n\tLocalListenerPriority         = " + this.getLocalListenerPriority() + "\n\tLocalPort                     = " + this.getLocalPort() + "\n\tLostPacketThreshold           = " + this.getLostPacketThreshold() + "\n\tMemberIdentity                = " + this.getMemberIdentity() + "\n\tMode                          = " + this.getMode() + "\n\tOutstandingPacketMaximum      = " + this.getOutstandingPacketMaximum() + "\n\tOutstandingPacketMinimum      = " + this.getOutstandingPacketMinimum() + "\n\tPacketBundlingAggression      = " + this.getPacketBundlingAggression() + "\n\tPacketBundlingThresholdNanos  = " + this.getPacketBundlingThresholdNanos() + "\n\tPacketMaxLength               = " + this.getPacketMaxLength() + "\n\tPacketPreferredLength         = " + this.getPacketPreferredLength() + "\n\tPublisherAckDelay             = " + this.getPublisherAckDelayMillis() + "\n\tPublisherSocketBufferSize     = " + this.getPublisherSocketBufferSize() + "\n\tPublisherCloggedCount         = " + this.getPublisherCloggedCount() + "\n\tPublisherCloggedDelayMillis   = " + this.getPublisherCloggedDelayMillis() + "\n\tPublisherGroupThreshold       = " + this.getPublisherGroupThreshold() + "\n\tPublisherNackDelay            = " + this.getPublisherNackDelayMillis() + "\n\tPublisherPriority             = " + this.getPublisherPriority() + "\n\tPublisherResendDelayMillis    = " + this.getPublisherResendDelayMillis() + "\n\tPublisherResendTimeoutMillis  = " + this.getPublisherResendTimeoutMillis() + "\n\tReceiverPriority              = " + this.getReceiverPriority() + "\n\tReliableTransport             = " + this.getReliableTransport() + "\n\tServiceFailurePolicyBuilder   = " + this.getServiceFailurePolicyBuilder() + "\n\tShutdownHookOption            = " + this.getShutdownHookOption() + "\n\tSocketProviderFactory         = " + this.getSocketProviderFactory() + "\n\tServiceMap                    = " + this.getServiceMap() + "\n\tSerializerMap                 = " + this.getSerializerMap() + "\n\tAddressProviderMap            = " + this.getAddressProviderMap() + "\n\tUnicastSocketProviderXml      = " + this.getUnicastSocketProviderXml() + "\n\tUnicastSocketProviderBuilder  = " + this.getUnicastSocketProviderBuilder() + "\n\tSpeakerPriority               = " + this.getSpeakerPriority() + "\n\tSpeakerVolumeMinimum          = " + this.getSpeakerVolumeMinimum() + "\n\tSpeakerEnabled                = " + this.isSpeakerEnabled() + "\n\tTcpBacklog                    = " + this.getTcpBacklog() + "\n\tTcpDatagramSocketOptions      = " + this.getTcpDatagramSocketOptions() + "\n\tTcpRingSocketOptions          = " + this.getTcpRingSocketOptions() + "\n\tWellKnownAddresses            = " + this.getWellKnownAddresses() + "\n\tFlowControlEnabled            = " + this.isFlowControlEnabled() + "\n\tIpMonitorEnabled              = " + this.isIpMonitorEnabled() + "\n\tLocalPortAutoAdjust           = " + this.isLocalPortAutoAdjust() + "\n\tReceiverNackEnabled           = " + this.isReceiverNackEnabled() + "\n\tTcmpEnabled                   = " + this.isTcmpEnabled() + "\n\tTcpRingEnabled                = " + this.isTcpRingEnabled() + "}";
    }

    protected void validateGuardTimeout() {
        if (this.getGuardTimeoutMillis() <= 0L) {
            this.setGuardTimeoutMillis(this.getPublisherResendTimeoutMillis());
            this.setServiceFailurePolicyBuilder(new ServiceFailurePolicyBuilder(3));
            CacheFactory.log("Disabling the service-guardian by setting a timeout of 0 has been deprecated. Instead, please configure a \"service-failure-policy\" of \"logging\" which will perform non-invasive monitoring of Coherence services.\n Configuring the Guardian to use the \"logging\" policy with a timeout of " + this.getGuardTimeoutMillis() + "ms", 2);
        }
    }

    protected String makeClusterName() {
        String sName = AccessController.doPrivileged(() -> System.getProperty("user.name"));
        if (sName != null) {
            sName = sName.trim();
        }
        if (sName == null || sName.isEmpty() || sName.equals("?")) {
            throw new UnsupportedOperationException("unable to generate a default cluster name, user name is not available, explicit cluster name configuration is required");
        }
        return sName + "'s cluster";
    }

    protected String makeMachineName() {
        try {
            InetAddress addr = this.getLocalAddress();
            String sHost = addr.getCanonicalHostName();
            if (!Base.equals(addr.getHostAddress(), sHost)) {
                int ofDelim = sHost.indexOf(46);
                int cChars = ofDelim == -1 ? sHost.length() : ofDelim;
                return sHost.substring(0, Math.min(66, cChars));
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    protected String makeSiteName() {
        try {
            int ofDelim;
            InetAddress addr = this.getLocalAddress();
            String sHost = addr.getCanonicalHostName();
            if (!Base.equals(addr.getHostAddress(), sHost) && (ofDelim = sHost.indexOf(46)) != -1) {
                int ofEnd = Math.min(sHost.length(), ofDelim + 66);
                return sHost.substring(ofDelim + 1, ofEnd);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }
}

