/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.management;

import com.tangosol.internal.net.management.ConnectorDependencies;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;

public class DefaultConnectorDependencies
implements ConnectorDependencies {
    private int m_nRefreshPolicy = 0;
    private long m_cRefreshRequestTimeoutMillis = 250L;
    private long m_cRefreshTimeoutMillis = 1000L;

    public DefaultConnectorDependencies() {
        this(null);
    }

    public DefaultConnectorDependencies(ConnectorDependencies deps) {
        if (deps != null) {
            this.m_cRefreshRequestTimeoutMillis = deps.getRefreshRequestTimeoutMillis();
            this.m_nRefreshPolicy = deps.getRefreshPolicy();
            this.m_cRefreshTimeoutMillis = deps.getRefreshTimeoutMillis();
        }
    }

    @Override
    public int getRefreshPolicy() {
        return this.m_nRefreshPolicy;
    }

    @Override
    public DefaultConnectorDependencies setRefreshPolicy(String sPolicy) {
        this.m_nRefreshPolicy = this.convertRefreshPolicy(sPolicy);
        return this;
    }

    @Override
    public long getRefreshRequestTimeoutMillis() {
        return this.m_cRefreshRequestTimeoutMillis;
    }

    protected DefaultConnectorDependencies setRefreshRequestTimeoutMillis(long cMillis) {
        this.m_cRefreshRequestTimeoutMillis = cMillis;
        return this;
    }

    @Override
    public long getRefreshTimeoutMillis() {
        return this.m_cRefreshTimeoutMillis;
    }

    @Override
    public DefaultConnectorDependencies setRefreshTimeoutMillis(long cMillis) {
        this.m_cRefreshTimeoutMillis = cMillis;
        return this;
    }

    public int convertRefreshPolicy(String sRefreshPolicy) {
        int nRefreshPolicy;
        if (sRefreshPolicy.equalsIgnoreCase("refresh-behind")) {
            nRefreshPolicy = 2;
        } else if (sRefreshPolicy.equalsIgnoreCase("refresh-ahead")) {
            nRefreshPolicy = 1;
        } else if (sRefreshPolicy.equalsIgnoreCase("refresh-onquery")) {
            nRefreshPolicy = 3;
        } else if (sRefreshPolicy.equalsIgnoreCase("refresh-expired")) {
            nRefreshPolicy = 0;
        } else {
            throw new IllegalArgumentException("Error invalid refresh-policy specified: " + sRefreshPolicy);
        }
        return nRefreshPolicy;
    }

    protected String formatRefreshPolicy(int nPolicy) {
        switch (nPolicy) {
            case 0: {
                return "refresh-expired";
            }
            case 1: {
                return "refresh-ahead";
            }
            case 2: {
                return "refresh-behind";
            }
            case 3: {
                return "refresh-onquery";
            }
        }
        return "n/a";
    }

    public DefaultConnectorDependencies validate() {
        Base.checkRange(this.getRefreshRequestTimeoutMillis(), 1L, Integer.MAX_VALUE, "RefreshRequestTimeout");
        Base.checkRange(this.getRefreshTimeoutMillis(), 1L, Integer.MAX_VALUE, "RefreshTimeout");
        return this;
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "{RefreshRequestTimeout=" + this.getRefreshRequestTimeoutMillis() + ", RefreshPolicy=" + this.formatRefreshPolicy(this.getRefreshPolicy()) + ", RefreshTimeout=" + this.getRefreshTimeoutMillis() + "}";
    }
}

