/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.metrics;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

final class EWMA {
    private static final int INTERVAL = 5;
    private static final double SECONDS_PER_MINUTE = 60.0;
    private static final int ONE_MINUTE = 1;
    private static final int FIVE_MINUTES = 5;
    private static final int FIFTEEN_MINUTES = 15;
    private static final double M1_ALPHA = 1.0 - StrictMath.exp(-0.08333333333333333);
    private static final double M5_ALPHA = 1.0 - StrictMath.exp(-0.016666666666666666);
    private static final double M15_ALPHA = 1.0 - StrictMath.exp(-0.005555555555555555);
    private final LongAdder m_cUncounted = new LongAdder();
    private final double m_nAlpha;
    private final double m_nInterval;
    private volatile boolean m_fInitialized = false;
    private volatile double m_nRate = 0.0;

    private EWMA(double nAlpha, long nInterval, TimeUnit intervalUnit) {
        this.m_nInterval = intervalUnit.toNanos(nInterval);
        this.m_nAlpha = nAlpha;
    }

    void update(long n) {
        this.m_cUncounted.add(n);
    }

    void tick() {
        long count = this.m_cUncounted.sumThenReset();
        double instantRate = (double)count / this.m_nInterval;
        if (this.m_fInitialized) {
            double currentRate = this.m_nRate;
            currentRate += this.m_nAlpha * (instantRate - currentRate);
            this.m_nRate = currentRate;
        } else {
            this.m_nRate = instantRate;
            this.m_fInitialized = true;
        }
    }

    double getRate(TimeUnit rateUnit) {
        return this.m_nRate * (double)rateUnit.toNanos(1L);
    }

    static EWMA oneMinuteEWMA() {
        return new EWMA(M1_ALPHA, 5L, TimeUnit.SECONDS);
    }

    static EWMA fiveMinuteEWMA() {
        return new EWMA(M5_ALPHA, 5L, TimeUnit.SECONDS);
    }

    static EWMA fifteenMinuteEWMA() {
        return new EWMA(M15_ALPHA, 5L, TimeUnit.SECONDS);
    }
}

