/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.metrics;

import com.tangosol.internal.net.metrics.Clock;
import com.tangosol.internal.net.metrics.ExponentiallyDecayingReservoir;
import com.tangosol.internal.net.metrics.Snapshot;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;

public class Histogram {
    private final LongAdder counter = new LongAdder();
    private final ExponentiallyDecayingReservoir reservoir;

    public Histogram() {
        this(Clock.system());
    }

    public Histogram(Clock clock) {
        this.reservoir = new ExponentiallyDecayingReservoir(clock);
    }

    public void update(int value) {
        this.update((long)value);
    }

    public void update(long value) {
        this.counter.increment();
        this.reservoir.update(value);
    }

    public void update(long value, long timestamp) {
        this.counter.increment();
        this.reservoir.update(value, timestamp);
    }

    public long getCount() {
        return this.counter.sum();
    }

    public Snapshot getSnapshot() {
        return this.reservoir.getSnapshot();
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getCount());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Histogram that = (Histogram)o;
        return this.getCount() == that.getCount();
    }
}

