/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.service;

import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.io.ConfigurableSerializerFactory;
import com.tangosol.io.SerializerFactory;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.net.OperationalContext;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import java.util.Map;

@Deprecated
public class LegacyXmlServiceHelper {
    public static DefaultServiceDependencies fromXml(XmlElement xml, DefaultServiceDependencies deps, OperationalContext ctx) {
        if (xml == null) {
            throw new IllegalArgumentException("XML argument cannot be null");
        }
        deps.setRequestTimeoutMillis(XmlHelper.parseTime(xml, "request-timeout", deps.getRequestTimeoutMillis()));
        XmlElement xmlThreads = xml.getElement("thread-count");
        if (xmlThreads == null || xmlThreads.isEmpty()) {
            deps.setWorkerThreadCountMax(xml.getSafeElement("thread-count-max").getInt(deps.getWorkerThreadCountMax()));
            deps.setWorkerThreadCountMin(xml.getSafeElement("thread-count-min").getInt(deps.getWorkerThreadCountMin()));
        } else {
            deps.setWorkerThreadCount(xmlThreads.getInt(deps.getWorkerThreadCount()));
        }
        deps.setTaskHungThresholdMillis(XmlHelper.parseTime(xml, "task-hung-threshold", deps.getTaskHungThresholdMillis()));
        deps.setTaskTimeoutMillis(XmlHelper.parseTime(xml, "task-timeout", deps.getTaskTimeoutMillis()));
        deps.setThreadPriority(xml.getSafeElement("service-priority").getInt(deps.getThreadPriority()));
        deps.setEventDispatcherThreadPriority(xml.getSafeElement("event-dispatcher-priority").getInt(deps.getEventDispatcherThreadPriority()));
        deps.setWorkerThreadPriority(xml.getSafeElement("worker-priority").getInt(deps.getWorkerThreadPriority()));
        XmlElement xmlSerializer = xml.getElement("serializer");
        if (xmlSerializer != null && !XmlHelper.isEmpty(xmlSerializer)) {
            SerializerFactory factory;
            if (xmlSerializer.isEmpty()) {
                ConfigurableSerializerFactory factoryImpl = new ConfigurableSerializerFactory();
                factoryImpl.setConfig(xmlSerializer);
                factory = factoryImpl;
            } else {
                String sName = xmlSerializer.getString();
                Map<String, SerializerFactory> mapSerializer = ctx.getSerializerMap();
                factory = mapSerializer.get(sName);
                if (factory == null) {
                    throw new IllegalArgumentException("Serializer name \"" + sName + "\" is undefined:\n" + xmlSerializer);
                }
            }
            deps.setSerializerFactory(factory);
        }
        return deps;
    }

    public static String getServiceName(XmlElement xmlScheme) {
        String sSchemeType = xmlScheme.getName();
        String sServiceName = xmlScheme.getSafeElement("service-name").getString();
        if (sServiceName.isEmpty()) {
            switch (DefaultConfigurableCacheFactory.translateStandardSchemeType(sSchemeType)) {
                case 1: {
                    sServiceName = "ReplicatedCache";
                    break;
                }
                case 2: {
                    sServiceName = "OptimisticCache";
                    break;
                }
                case 3: {
                    sServiceName = "DistributedCache";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 19: 
                case 20: {
                    sServiceName = "LocalCache";
                    break;
                }
                case 4: 
                case 5: 
                case 14: {
                    sServiceName = "Invocation";
                    break;
                }
                case 15: {
                    sServiceName = "Proxy";
                    break;
                }
                case 16: {
                    sServiceName = "RemoteCache";
                    break;
                }
                case 17: {
                    sServiceName = "RemoteInvocation";
                    break;
                }
                case 21: {
                    sServiceName = "DistributedTopic";
                }
            }
        }
        return sServiceName;
    }
}

