/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.service.grid;

import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.builder.ActionPolicyBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.PartitionAssignmentStrategyBuilder;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.internal.net.service.grid.DefaultGridDependencies;
import com.tangosol.internal.net.service.grid.PartitionedServiceDependencies;
import com.tangosol.internal.net.service.grid.PersistenceDependencies;
import com.tangosol.net.partition.DefaultKeyAssociator;
import com.tangosol.net.partition.KeyAssociator;
import com.tangosol.net.partition.KeyPartitioningStrategy;
import com.tangosol.net.partition.PartitionListener;
import com.tangosol.util.Base;
import java.util.LinkedList;
import java.util.List;

public class DefaultPartitionedServiceDependencies
extends DefaultGridDependencies
implements PartitionedServiceDependencies {
    private int m_cBackups = 1;
    private int m_nDistributionAggressiveness = Config.getInteger("coherence.distributed.aggressive", 20);
    private boolean m_fDistributionSynchronized = Config.getBoolean("coherence.distributed.synchronize", true);
    private KeyAssociator m_keyAssociator;
    private KeyPartitioningStrategy m_keyPartitioningStrategy;
    private boolean m_fOwnershipCapable = true;
    private boolean m_fAsyncBackup = false;
    private int m_cPartitions = 257;
    private List<ParameterizedBuilder<PartitionListener>> m_bldrsPartitionListener;
    private PartitionAssignmentStrategyBuilder m_bldrAssignmentStrategy;
    private int m_cbTransferThreshold = 524288;
    private PersistenceDependencies m_depsPersistence;

    public DefaultPartitionedServiceDependencies() {
        this(null);
    }

    public DefaultPartitionedServiceDependencies(PartitionedServiceDependencies deps) {
        super(deps);
        if (deps == null) {
            this.setWorkerThreadCountMin(1);
        } else {
            this.m_cBackups = deps.getPreferredBackupCount();
            this.m_nDistributionAggressiveness = deps.getDistributionAggressiveness();
            this.m_fDistributionSynchronized = deps.isDistributionSynchronized();
            this.m_keyAssociator = deps.getKeyAssociator();
            this.m_keyPartitioningStrategy = deps.getKeyPartitioningStrategy();
            this.m_fOwnershipCapable = deps.isOwnershipCapable();
            this.m_cPartitions = deps.getPreferredPartitionCount();
            this.m_bldrsPartitionListener = deps.getPartitionListenerBuilders();
            this.m_bldrAssignmentStrategy = deps.getPartitionAssignmentStrategyBuilder();
            this.m_cbTransferThreshold = deps.getTransferThreshold();
            this.m_fAsyncBackup = deps.isAsyncBackupEnabled();
            this.m_depsPersistence = deps.getPersistenceDependencies();
        }
    }

    @Override
    @Injectable(value="partitioned-quorum-policy-scheme")
    public void setActionPolicyBuilder(ActionPolicyBuilder builder) {
        super.setActionPolicyBuilder(builder);
    }

    @Override
    public int getPreferredBackupCount() {
        return this.m_cBackups;
    }

    @Injectable(value="backup-count")
    public void setPreferredBackupCount(int cBackups) {
        this.m_cBackups = cBackups;
    }

    @Override
    public int getDistributionAggressiveness() {
        return this.m_nDistributionAggressiveness;
    }

    public void setDistributionAggressiveness(int nAggressiveness) {
        this.m_nDistributionAggressiveness = nAggressiveness;
    }

    @Override
    public boolean isDistributionSynchronized() {
        return this.m_fDistributionSynchronized;
    }

    public void setDistributionSynchronized(boolean fSync) {
        this.m_fDistributionSynchronized = fSync;
    }

    @Override
    public KeyAssociator getKeyAssociator() {
        KeyAssociator keyAssociator = this.m_keyAssociator;
        if (keyAssociator == null) {
            this.m_keyAssociator = keyAssociator = new DefaultKeyAssociator();
        }
        return keyAssociator;
    }

    @Injectable(value="key-associator")
    public void setKeyAssociator(KeyAssociator associator) {
        this.m_keyAssociator = associator;
    }

    @Override
    public KeyPartitioningStrategy getKeyPartitioningStrategy() {
        return this.m_keyPartitioningStrategy;
    }

    @Injectable(value="key-partitioning")
    public void setKeyPartitioningStrategy(KeyPartitioningStrategy strategy) {
        this.m_keyPartitioningStrategy = strategy;
    }

    @Override
    public boolean isOwnershipCapable() {
        return this.m_fOwnershipCapable;
    }

    @Injectable(value="local-storage")
    public void setOwnershipCapable(boolean fEnabled) {
        this.m_fOwnershipCapable = fEnabled;
    }

    @Override
    public boolean isAsyncBackupEnabled() {
        return this.m_fAsyncBackup;
    }

    @Injectable(value="async-backup")
    public void setAsyncBackupEnabled(boolean fEnabled) {
        this.m_fAsyncBackup = fEnabled;
    }

    @Override
    public PartitionAssignmentStrategyBuilder getPartitionAssignmentStrategyBuilder() {
        PartitionAssignmentStrategyBuilder bldr = this.m_bldrAssignmentStrategy;
        if (bldr == null) {
            this.m_bldrAssignmentStrategy = bldr = new PartitionAssignmentStrategyBuilder("simple", null);
        }
        return bldr;
    }

    @Injectable(value="partition-assignment-strategy")
    public void setPartitionAssignmentStrategyBuilder(PartitionAssignmentStrategyBuilder builder) {
        this.m_bldrAssignmentStrategy = builder;
    }

    @Override
    public int getPreferredPartitionCount() {
        return this.m_cPartitions;
    }

    @Injectable(value="partition-count")
    public void setPreferredPartitionCount(int cPartitions) {
        this.m_cPartitions = cPartitions;
    }

    @Override
    public List<ParameterizedBuilder<PartitionListener>> getPartitionListenerBuilders() {
        List<ParameterizedBuilder<PartitionListener>> listeners = this.m_bldrsPartitionListener;
        if (listeners == null) {
            this.m_bldrsPartitionListener = listeners = new LinkedList<ParameterizedBuilder<PartitionListener>>();
        }
        return listeners;
    }

    @Injectable(value="partition-listener")
    public void setPartitionListenerBuilders(List<ParameterizedBuilder<PartitionListener>> bldrsListener) {
        this.m_bldrsPartitionListener = bldrsListener;
    }

    @Override
    public int getTransferThreshold() {
        return this.m_cbTransferThreshold;
    }

    @Injectable(value="transfer-threshold")
    public void setTransferThreshold(int cbThreshold) {
        int KB = 1024;
        this.m_cbTransferThreshold = cbThreshold * 1024;
    }

    @Override
    public PersistenceDependencies getPersistenceDependencies() {
        return this.m_depsPersistence;
    }

    @Injectable(value="persistence")
    public void setPersistenceDependencies(PersistenceDependencies deps) {
        this.m_depsPersistence = deps;
    }

    @Override
    public DefaultPartitionedServiceDependencies validate() {
        super.validate();
        Base.checkRange(this.getPreferredBackupCount(), 0L, 256L, "BackupCount");
        Base.checkRange(this.getPreferredPartitionCount(), 1L, 32767L, "PartitionCount");
        Base.checkRange(this.getTransferThreshold(), 1024L, Integer.MAX_VALUE, "TransferThreshold");
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "{PreferredBackupCount=" + this.getPreferredBackupCount() + ", DistributionAggressiveness=" + this.getDistributionAggressiveness() + ", DistributionSynchronized=" + this.isDistributionSynchronized() + ", KeyAssociator=" + this.getKeyAssociator() + "  KeyPartitioningStrategy=" + this.getKeyPartitioningStrategy() + ", OwnershipCapable=" + this.isOwnershipCapable() + ", PreferredPartitionCount=" + this.getPreferredPartitionCount() + ", PartitionListenerBuilders=" + this.getPartitionListenerBuilders() + ", PartitionAssignmentStrategyBuilder=" + this.getPartitionAssignmentStrategyBuilder() + ", TransferThreshold=" + this.getTransferThreshold() + ", AsyncBackupEnabled=" + this.isAsyncBackupEnabled() + ", PersistenceDependencies=" + this.getPersistenceDependencies() + "}";
    }
}

