/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.service.peer;

import com.tangosol.config.annotation.Injectable;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.peer.PeerDependencies;
import com.tangosol.io.WrapperStreamFactory;
import com.tangosol.net.messaging.Codec;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.SafeLinkedList;
import java.util.List;

public class DefaultPeerDependencies
extends DefaultServiceDependencies
implements PeerDependencies {
    private Codec m_codec = null;
    private List<WrapperStreamFactory> m_listFilter = null;
    private long m_cPingIntervalMillis;
    private long m_cPingTimeoutMillis = -1L;
    private int m_cbMaxIncomingMessageSize;
    private int m_cbMaxOutgoingMessageSize;

    public DefaultPeerDependencies() {
        this(null);
    }

    public DefaultPeerDependencies(PeerDependencies deps) {
        super(deps);
        if (deps != null) {
            this.m_codec = deps.getMessageCodec();
            this.m_listFilter = deps.getFilterList();
            this.m_cPingIntervalMillis = deps.getPingIntervalMillis();
            this.m_cPingTimeoutMillis = deps.getPingTimeoutMillis();
            this.m_cbMaxIncomingMessageSize = deps.getMaxIncomingMessageSize();
            this.m_cbMaxOutgoingMessageSize = deps.getMaxOutgoingMessageSize();
        } else {
            super.setRequestTimeoutMillis(30000L);
        }
    }

    @Override
    @Injectable(value="outgoing-message-handler/request-timeout")
    public void setRequestTimeoutMillis(long cMillis) {
        super.setRequestTimeoutMillis(cMillis);
    }

    @Override
    public List<WrapperStreamFactory> getFilterList() {
        SafeLinkedList listFilter = this.m_listFilter;
        if (listFilter == null) {
            this.m_listFilter = listFilter = new SafeLinkedList();
        }
        return listFilter;
    }

    @Injectable(value="use-filters")
    public void setFilterList(List<WrapperStreamFactory> listFilter) {
        this.m_listFilter = listFilter == null ? listFilter : new ImmutableArrayList(listFilter);
    }

    @Override
    public Codec getMessageCodec() {
        return this.m_codec;
    }

    @Injectable(value="message-codec")
    public void setMessageCodec(Codec codec) {
        this.m_codec = codec;
    }

    @Override
    public long getPingIntervalMillis() {
        return this.m_cPingIntervalMillis;
    }

    @Injectable(value="outgoing-message-handler/heartbeat-interval")
    public void setPingIntervalMillis(long cMillis) {
        this.m_cPingIntervalMillis = cMillis;
    }

    @Override
    public long getPingTimeoutMillis() {
        return this.m_cPingTimeoutMillis < 0L ? this.getRequestTimeoutMillis() : this.m_cPingTimeoutMillis;
    }

    @Injectable(value="outgoing-message-handler/heartbeat-timeout")
    public void setPingTimeoutMillis(long cMillis) {
        this.m_cPingTimeoutMillis = cMillis;
    }

    @Override
    public int getMaxIncomingMessageSize() {
        return this.m_cbMaxIncomingMessageSize;
    }

    @Injectable(value="incoming-message-handler/max-message-size")
    public void setMaxIncomingMessageSize(int cbMax) {
        this.m_cbMaxIncomingMessageSize = cbMax;
    }

    @Override
    public int getMaxOutgoingMessageSize() {
        return this.m_cbMaxOutgoingMessageSize;
    }

    @Injectable(value="outgoing-message-handler/max-message-size")
    public void setMaxOutgoingMessageSize(int cbMax) {
        this.m_cbMaxOutgoingMessageSize = cbMax;
    }

    @Override
    public DefaultPeerDependencies validate() {
        super.validate();
        this.validatePingTimeout();
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "{Codec=" + this.getMessageCodec() + ", FilterList=" + this.getFilterList() + ", PingIntervalMillis=" + this.getPingIntervalMillis() + ", PingTimeoutMillis=" + this.getPingTimeoutMillis() + ", MaxIncomingMessageSize=" + this.getMaxIncomingMessageSize() + ", MaxOutgoingMessageSize=" + this.getMaxOutgoingMessageSize() + "}";
    }

    private void validatePingTimeout() {
        long cTimeoutMillis = this.getPingTimeoutMillis();
        long cIntervalMillis = this.getPingIntervalMillis();
        if (cIntervalMillis > 0L) {
            if (cTimeoutMillis == 0L) {
                this.setPingTimeoutMillis(cIntervalMillis);
            } else {
                this.setPingTimeoutMillis(Math.min(cIntervalMillis, cTimeoutMillis));
            }
        }
    }
}

