/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.service.peer.acceptor;

import com.oracle.coherence.common.net.InetAddresses;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.internal.net.service.peer.acceptor.AbstractAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.HttpAcceptorDependencies;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.util.Base;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

public class DefaultHttpAcceptorDependencies
extends AbstractAcceptorDependencies
implements HttpAcceptorDependencies {
    private Object m_oHttpServer;
    private SocketProviderBuilder m_builderSocketProvider = new SocketProviderBuilder(SocketProviderFactory.DEFAULT_SOCKET_PROVIDER);
    private String m_sLocalAddress = this.normalizeAddress(null);
    private int m_nLocalPort = 0;
    private Map<String, Object> m_mapResourceConfig = new HashMap<String, Object>();
    private String m_sAuthMethod = "none";

    public DefaultHttpAcceptorDependencies() {
        this(null);
    }

    public DefaultHttpAcceptorDependencies(HttpAcceptorDependencies deps) {
        super(deps);
        if (deps != null) {
            this.m_oHttpServer = deps.getHttpServer();
            this.m_builderSocketProvider = deps.getSocketProviderBuilder();
            this.m_sLocalAddress = deps.getLocalAddress();
            this.m_nLocalPort = deps.getLocalPort();
            this.m_mapResourceConfig = deps.getResourceConfig();
            this.m_sAuthMethod = deps.getAuthMethod();
        }
    }

    @Override
    public Object getHttpServer() {
        return this.m_oHttpServer;
    }

    public void setHttpServer(Object oServer) {
        this.m_oHttpServer = oServer;
    }

    @Override
    public SocketProviderBuilder getSocketProviderBuilder() {
        return this.m_builderSocketProvider;
    }

    @Injectable(value="socket-provider")
    public void setSocketProviderBuilder(SocketProviderBuilder builder) {
        this.m_builderSocketProvider = builder;
    }

    @Override
    public int getLocalPort() {
        return this.m_nLocalPort;
    }

    @Injectable(value="local-address/port")
    public void setLocalPort(int nPort) {
        this.m_nLocalPort = nPort;
    }

    @Override
    public String getLocalAddress() {
        return this.m_sLocalAddress;
    }

    @Injectable(value="local-address/address")
    public void setLocalAddress(String sAddress) {
        this.m_sLocalAddress = this.normalizeAddress(sAddress);
    }

    @Override
    public Map<String, Object> getResourceConfig() {
        return this.m_mapResourceConfig;
    }

    public void setResourceConfig(Map<String, Object> mapConfig) {
        this.m_mapResourceConfig = mapConfig;
    }

    @Override
    public String getAuthMethod() {
        return this.m_sAuthMethod;
    }

    @Injectable(value="auth-method")
    public void setAuthMethod(String sMethod) {
        this.m_sAuthMethod = sMethod;
    }

    @Override
    public DefaultHttpAcceptorDependencies validate() {
        String sMethod;
        super.validate();
        Base.checkNotNull(this.getHttpServer(), "HttpServer");
        Base.checkNotEmpty(this.getLocalAddress(), "LocalAddress");
        Base.checkRange(this.getLocalPort(), 0L, 65535L, "LocalPort");
        Map<String, Object> mapConfig = this.getResourceConfig();
        if (mapConfig != null) {
            for (String sContext : mapConfig.keySet()) {
                if (sContext != null && sContext.startsWith("/")) continue;
                throw new IllegalArgumentException("illegal context path: " + sContext);
            }
        }
        if (!("basic".equalsIgnoreCase(sMethod = this.getAuthMethod()) || "cert".equalsIgnoreCase(sMethod) || "cert+basic".equalsIgnoreCase(sMethod) || "none".equalsIgnoreCase(sMethod))) {
            throw new IllegalArgumentException("unsupported AuthMethod: " + sMethod);
        }
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "{HttpServer=" + this.getHttpServer() + ", SocketProviderBuilder=" + this.getSocketProviderBuilder() + ", LocalAddress=" + this.getLocalAddress() + ", LocalPort=" + this.getLocalPort() + ", ResourceConfig=" + this.getResourceConfig() + ", AuthMethod=" + this.getAuthMethod() + "}";
    }

    protected String normalizeAddress(String sAddress) {
        block5: {
            try {
                if (sAddress == null || sAddress.isEmpty()) {
                    sAddress = InetAddresses.ADDR_ANY.getHostAddress();
                    break block5;
                }
                InetAddress addr = InetAddresses.getLocalAddress(sAddress);
                if (InetAddresses.isLocalAddress(addr)) {
                    sAddress = addr.getHostAddress();
                    break block5;
                }
                if (InetAddresses.isNatLocalAddress(addr, this.getLocalPort())) {
                    sAddress = InetAddresses.ADDR_ANY.getHostAddress();
                    break block5;
                }
                throw new IllegalArgumentException(sAddress + " does not represent a local address");
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return sAddress;
    }
}

