/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.service.peer.acceptor;

import com.oracle.coherence.common.net.TcpSocketProvider;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.coherence.memcached.server.MemcachedServer;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.internal.net.service.peer.acceptor.AbstractAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.MemcachedAcceptorDependencies;
import com.tangosol.net.AddressProvider;

public class DefaultMemcachedAcceptorDependencies
extends AbstractAcceptorDependencies
implements MemcachedAcceptorDependencies {
    private String m_sAuthMethod = "none";
    private boolean m_fBinaryPassthru;
    private ParameterizedBuilder<AddressProvider> m_bldrAddressProvider;
    private String m_sCacheName = "";
    private MemcachedServer m_memcachedServer;
    private SocketProviderBuilder m_builderSocketProvider = new SocketProviderBuilder(TcpSocketProvider.DEMULTIPLEXED);

    public DefaultMemcachedAcceptorDependencies() {
        this(null);
    }

    public DefaultMemcachedAcceptorDependencies(MemcachedAcceptorDependencies deps) {
        super(deps);
        if (deps != null) {
            this.m_sAuthMethod = deps.getAuthMethod();
            this.m_fBinaryPassthru = deps.isBinaryPassThru();
            this.m_bldrAddressProvider = deps.getAddressProviderBuilder();
            this.m_sCacheName = deps.getCacheName();
            this.m_memcachedServer = deps.getMemcachedServer();
            this.m_builderSocketProvider = deps.getSocketProviderBuilder();
        }
    }

    @Override
    public MemcachedServer getMemcachedServer() {
        if (this.m_memcachedServer == null) {
            this.m_memcachedServer = new MemcachedServer();
        }
        return this.m_memcachedServer;
    }

    @Injectable(value="memcached-server")
    public void setMemcachedServer(MemcachedServer server) {
        this.m_memcachedServer = server;
    }

    @Injectable(value="interop-enabled")
    public void setBinaryPassThru(boolean fBinaryPassthru) {
        this.m_fBinaryPassthru = fBinaryPassthru;
    }

    @Override
    public boolean isBinaryPassThru() {
        return this.m_fBinaryPassthru;
    }

    @Injectable(value="cache-name")
    public void setCacheName(String sCacheName) {
        this.m_sCacheName = sCacheName;
    }

    @Override
    public String getCacheName() {
        return this.m_sCacheName;
    }

    @Override
    public String getAuthMethod() {
        return this.m_sAuthMethod;
    }

    @Injectable(value="memcached-auth-method")
    public void setAuthMethod(String sMethod) {
        this.m_sAuthMethod = sMethod;
    }

    @Override
    public SocketProviderBuilder getSocketProviderBuilder() {
        return this.m_builderSocketProvider;
    }

    @Injectable(value="socket-provider")
    public void setSocketProviderBuilder(SocketProviderBuilder builder) {
        this.m_builderSocketProvider = builder;
    }

    @Override
    public ParameterizedBuilder<AddressProvider> getAddressProviderBuilder() {
        return this.m_bldrAddressProvider;
    }

    @Injectable(value="address-provider")
    public void setAddressProviderBuilder(ParameterizedBuilder<AddressProvider> provider) {
        this.m_bldrAddressProvider = provider;
    }

    @Override
    public String toString() {
        return super.toString() + "MemcachedAcceptor: SocketProviderBuilder=" + this.getSocketProviderBuilder() + ", LocalAddressProvider=" + this.getAddressProviderBuilder() + "}";
    }
}

