/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.service.peer.initiator;

import com.tangosol.config.annotation.Injectable;
import com.tangosol.internal.net.service.peer.DefaultPeerDependencies;
import com.tangosol.internal.net.service.peer.initiator.InitiatorDependencies;
import com.tangosol.util.Base;

public class DefaultInitiatorDependencies
extends DefaultPeerDependencies
implements InitiatorDependencies {
    private long m_cConnectTimeoutMillis;
    private long m_cRequestSendTimeoutMillis;

    public DefaultInitiatorDependencies() {
        this(null);
    }

    public DefaultInitiatorDependencies(InitiatorDependencies deps) {
        super(deps);
        if (deps != null) {
            this.m_cConnectTimeoutMillis = deps.getConnectTimeoutMillis();
            this.m_cRequestSendTimeoutMillis = deps.getRequestSendTimeoutMillis();
        }
    }

    @Override
    public long getConnectTimeoutMillis() {
        long cTimeout = this.m_cConnectTimeoutMillis;
        if (cTimeout == 0L) {
            this.m_cConnectTimeoutMillis = cTimeout = this.getRequestTimeoutMillis();
        }
        return cTimeout;
    }

    @Injectable(value="connect-timeout")
    public void setConnectTimeoutMillis(long cMillis) {
        this.m_cConnectTimeoutMillis = cMillis;
    }

    @Override
    public DefaultInitiatorDependencies validate() {
        super.validate();
        Base.azzert(this.getConnectTimeoutMillis() >= 0L, "Connect timeout cannot be less than 0");
        Base.azzert(this.getRequestSendTimeoutMillis() >= 0L, "Request send timeout cannot be less than 0");
        return this;
    }

    @Override
    public long getRequestSendTimeoutMillis() {
        long cTimeout = this.m_cRequestSendTimeoutMillis;
        if (cTimeout == 0L) {
            this.m_cRequestSendTimeoutMillis = cTimeout = this.getRequestTimeoutMillis();
        }
        return cTimeout;
    }

    @Injectable(value="outgoing-message-handler/request-timeout")
    public void setRequestSendTimeoutMillis(long cMillis) {
        this.m_cRequestSendTimeoutMillis = cMillis;
    }

    @Override
    public String toString() {
        return super.toString() + "{ConnectTimeoutMillis=" + this.getConnectTimeoutMillis() + ", RequestSendTimeoutMillis=" + this.getRequestSendTimeoutMillis() + "}";
    }
}

