/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.agent;

import com.tangosol.internal.net.topic.impl.paged.PagedTopicPartition;
import com.tangosol.internal.net.topic.impl.paged.agent.AbstractPagedTopicProcessor;
import com.tangosol.internal.net.topic.impl.paged.model.Subscription;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import java.io.IOException;
import java.util.function.Function;

public class EnsureSubscriptionProcessor
extends AbstractPagedTopicProcessor<Subscription.Key, Subscription, long[]>
implements EvolvablePortableObject {
    public static final int PHASE_INQUIRE = 0;
    public static final int PHASE_PIN = 1;
    public static final int PHASE_ADVANCE = 2;
    public static final int DATA_VERSION = 1;
    private int m_nPhase;
    private long[] m_alPage;
    private Filter m_filter;
    private Function m_fnConvert;

    public EnsureSubscriptionProcessor() {
        super(PagedTopicPartition::ensureTopic);
    }

    public EnsureSubscriptionProcessor(int nPhase, long[] alPage, Filter filter, Function fnConvert) {
        super(PagedTopicPartition::ensureTopic);
        this.m_nPhase = nPhase;
        this.m_alPage = alPage;
        this.m_filter = filter;
        this.m_fnConvert = fnConvert;
    }

    @Override
    public long[] process(InvocableMap.Entry<Subscription.Key, Subscription> entry) {
        return this.ensureTopic(entry).ensureSubscription(entry.getKey().getGroupId(), this.m_nPhase, this.m_alPage, this.m_filter, this.m_fnConvert);
    }

    @Override
    public int getImplVersion() {
        return 1;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_nPhase = in.readInt(0);
        this.m_alPage = in.readLongArray(1);
        this.m_filter = (Filter)in.readObject(2);
        this.m_fnConvert = (Function)in.readObject(3);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_nPhase);
        out.writeLongArray(1, this.m_alPage);
        out.writeObject(2, this.m_filter);
        out.writeObject(3, this.m_fnConvert);
    }
}

