/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.bind.tuple;

import com.tangosol.internal.sleepycat.bind.tuple.TupleBinding;
import com.tangosol.internal.sleepycat.bind.tuple.TupleInput;
import com.tangosol.internal.sleepycat.bind.tuple.TupleOutput;
import com.tangosol.internal.sleepycat.je.DatabaseEntry;

public class CharacterBinding
extends TupleBinding<Character> {
    private static final int CHAR_SIZE = 2;

    @Override
    public Character entryToObject(TupleInput input) {
        return Character.valueOf(input.readChar());
    }

    @Override
    public void objectToEntry(Character object, TupleOutput output) {
        output.writeChar(object.charValue());
    }

    @Override
    protected TupleOutput getTupleOutput(Character object) {
        return CharacterBinding.sizedOutput();
    }

    public static char entryToChar(DatabaseEntry entry) {
        return CharacterBinding.entryToInput(entry).readChar();
    }

    public static void charToEntry(char val, DatabaseEntry entry) {
        CharacterBinding.outputToEntry(CharacterBinding.sizedOutput().writeChar(val), entry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[2]);
    }
}

