/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.collections;

import com.tangosol.internal.sleepycat.bind.EntityBinding;
import com.tangosol.internal.sleepycat.bind.EntryBinding;
import com.tangosol.internal.sleepycat.collections.DataCursor;
import com.tangosol.internal.sleepycat.collections.DataView;
import com.tangosol.internal.sleepycat.collections.PrimaryKeyAssigner;
import com.tangosol.internal.sleepycat.collections.StoredContainer;
import com.tangosol.internal.sleepycat.collections.StoredMap;
import com.tangosol.internal.sleepycat.je.Database;
import com.tangosol.internal.sleepycat.je.OperationStatus;
import java.util.Comparator;
import java.util.SortedMap;

public class StoredSortedMap<K, V>
extends StoredMap<K, V>
implements SortedMap<K, V> {
    public StoredSortedMap(Database database, EntryBinding<K> keyBinding, EntryBinding<V> valueBinding, boolean writeAllowed) {
        super(new DataView(database, keyBinding, valueBinding, null, writeAllowed, null));
    }

    public StoredSortedMap(Database database, EntryBinding<K> keyBinding, EntryBinding<V> valueBinding, PrimaryKeyAssigner keyAssigner) {
        super(new DataView(database, keyBinding, valueBinding, null, true, keyAssigner));
    }

    public StoredSortedMap(Database database, EntryBinding<K> keyBinding, EntityBinding<V> valueEntityBinding, boolean writeAllowed) {
        super(new DataView(database, keyBinding, null, valueEntityBinding, writeAllowed, null));
    }

    public StoredSortedMap(Database database, EntryBinding<K> keyBinding, EntityBinding<V> valueEntityBinding, PrimaryKeyAssigner keyAssigner) {
        super(new DataView(database, keyBinding, null, valueEntityBinding, true, keyAssigner));
    }

    StoredSortedMap(DataView mapView) {
        super(mapView);
    }

    @Override
    public Comparator<? super K> comparator() {
        return null;
    }

    @Override
    public K firstKey() {
        return this.getFirstOrLastKey(true);
    }

    @Override
    public K lastKey() {
        return this.getFirstOrLastKey(false);
    }

    private K getFirstOrLastKey(boolean doGetFirst) {
        Object object;
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false);
            OperationStatus status = doGetFirst ? cursor.getFirst(false) : cursor.getLast(false);
            object = status == OperationStatus.SUCCESS ? cursor.getCurrentKey() : null;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeCursor(cursor);
                throw throwable;
            }
        }
        this.closeCursor(cursor);
        return (K)object;
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return this.subMap(null, false, toKey, false);
    }

    public SortedMap<K, V> headMap(K toKey, boolean toInclusive) {
        return this.subMap(null, false, toKey, toInclusive);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return this.subMap(fromKey, true, null, false);
    }

    public SortedMap<K, V> tailMap(K fromKey, boolean fromInclusive) {
        return this.subMap(fromKey, fromInclusive, null, false);
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    public SortedMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        try {
            return new StoredSortedMap<K, V>(this.view.subView(fromKey, fromInclusive, toKey, toInclusive, null));
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }
}

