/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je;

import com.tangosol.internal.sleepycat.je.JEVersion;
import com.tangosol.internal.sleepycat.je.utilint.LoggerUtils;

public abstract class DatabaseException
extends RuntimeException {
    private static final long serialVersionUID = 1535562945L;
    private String extraInfo = null;
    private transient ThreadLocal<String> rethrownStackTraces = new ThreadLocal();

    public DatabaseException(Throwable t) {
        super(DatabaseException.getVersionHeader() + t.toString(), t);
    }

    public DatabaseException(String message) {
        super(DatabaseException.getVersionHeader() + message);
    }

    public DatabaseException(String message, Throwable t) {
        super(DatabaseException.getVersionHeader() + message, t);
    }

    public static String getVersionHeader() {
        return "(JE " + JEVersion.CURRENT_VERSION + ") ";
    }

    public void addErrorMessage(String newExtraInfo) {
        this.extraInfo = this.extraInfo == null ? " " + newExtraInfo : this.extraInfo + ' ' + newExtraInfo;
    }

    public void addRethrownStackTrace() {
        Exception localEx = new Exception("Stacktrace where exception below was rethrown (" + this.getClass().getName() + ")");
        this.rethrownStackTraces.set(LoggerUtils.getStackTrace(localEx));
    }

    @Override
    public String getMessage() {
        String msg = this.extraInfo != null ? super.getMessage() + this.extraInfo : super.getMessage();
        String rethrownStackTrace = this.rethrownStackTraces.get();
        if (rethrownStackTrace == null) {
            return msg;
        }
        return rethrownStackTrace + "\n" + msg;
    }
}

