/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.config;

import com.tangosol.internal.sleepycat.je.config.ConfigParam;

public class LongConfigParam
extends ConfigParam {
    private static final String DEBUG_NAME = LongConfigParam.class.getName();
    private Long min;
    private Long max;

    public LongConfigParam(String configName, Long minVal, Long maxVal, Long defaultValue, boolean mutable, boolean forReplication) {
        super(configName, defaultValue.toString(), mutable, forReplication);
        this.min = minVal;
        this.max = maxVal;
    }

    private void validate(Long value) throws IllegalArgumentException {
        if (value != null) {
            if (this.min != null && value.compareTo(this.min) < 0) {
                throw new IllegalArgumentException(DEBUG_NAME + ":" + " param " + this.name + " doesn't validate, " + value + " is less than min of " + this.min);
            }
            if (this.max != null && value.compareTo(this.max) > 0) {
                throw new IllegalArgumentException(DEBUG_NAME + ":" + " param " + this.name + " doesn't validate, " + value + " is greater than max " + " of " + this.max);
            }
        }
    }

    @Override
    public void validateValue(String value) throws IllegalArgumentException {
        try {
            this.validate(new Long(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(DEBUG_NAME + ": " + value + " not valid value for " + this.name);
        }
    }
}

