/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.dbi;

import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.utilint.DbLsn;
import java.util.concurrent.atomic.AtomicLong;

public class NodeSequence {
    public static final int FIRST_LOCAL_NODE_ID = 1;
    public static final int FIRST_REPLICATED_NODE_ID = -10;
    private AtomicLong lastAllocatedLocalNodeId = null;
    private AtomicLong lastAllocatedReplicatedNodeId = null;
    private final AtomicLong lastAllocatedTransientLsnOffset = new AtomicLong(0L);
    public final EnvironmentImpl envImpl;

    public NodeSequence(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
    }

    void initRealNodeId() {
        this.lastAllocatedLocalNodeId = new AtomicLong(0L);
        this.lastAllocatedReplicatedNodeId = new AtomicLong(-9L);
    }

    public long getLastLocalNodeId() {
        return this.lastAllocatedLocalNodeId.get();
    }

    public long getLastReplicatedNodeId() {
        return this.lastAllocatedReplicatedNodeId.get();
    }

    public long getNextLocalNodeId() {
        return this.lastAllocatedLocalNodeId.incrementAndGet();
    }

    public void setLastNodeId(long lastReplicatedNodeId, long lastLocalNodeId) {
        this.lastAllocatedReplicatedNodeId.set(lastReplicatedNodeId);
        this.lastAllocatedLocalNodeId.set(lastLocalNodeId);
    }

    public void updateFromReplay(long replayNodeId) {
        assert (!this.envImpl.isMaster());
        if (replayNodeId > 0L && !this.envImpl.isRepConverted()) {
            throw EnvironmentFailureException.unexpectedState("replay node id is unexpectedly positive " + replayNodeId);
        }
        if (replayNodeId < this.lastAllocatedReplicatedNodeId.get()) {
            this.lastAllocatedReplicatedNodeId.set(replayNodeId);
        }
    }

    public long getNextTransientLsn() {
        return DbLsn.makeTransientLsn(this.lastAllocatedTransientLsnOffset.getAndIncrement());
    }
}

