/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.latch;

import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.ThreadInterruptedException;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.latch.LatchContext;
import com.tangosol.internal.sleepycat.je.latch.LatchSupport;
import com.tangosol.internal.sleepycat.je.latch.OwnerInfo;
import com.tangosol.internal.sleepycat.je.latch.SharedLatch;
import com.tangosol.internal.sleepycat.je.utilint.StatGroup;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class LatchImpl
extends ReentrantLock
implements SharedLatch {
    private final LatchContext context;
    private OwnerInfo lastOwnerInfo;

    LatchImpl(LatchContext context) {
        this.context = context;
    }

    String getName() {
        return this.context.getLatchName();
    }

    @Override
    public boolean isExclusiveOnly() {
        return true;
    }

    @Override
    public void acquireExclusive() {
        if (this.isHeldByCurrentThread()) {
            throw EnvironmentFailureException.unexpectedState(this.context.getEnvImplForFatalException(), "Latch already held: " + this.debugString());
        }
        try {
            if (!this.tryLock(this.context.getLatchTimeoutMs(), TimeUnit.MILLISECONDS)) {
                throw LatchSupport.handleTimeout(this, this.context);
            }
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException(this.context.getEnvImplForFatalException(), (Throwable)e);
        }
        if (LatchSupport.TRACK_LATCHES) {
            LatchSupport.trackAcquire(this, this.context);
        }
        if (LatchSupport.CAPTURE_OWNER) {
            this.lastOwnerInfo = new OwnerInfo(this.context);
        }
        assert (EnvironmentImpl.maybeForceYield());
    }

    @Override
    public boolean acquireExclusiveNoWait() {
        if (this.isHeldByCurrentThread()) {
            throw EnvironmentFailureException.unexpectedState(this.context.getEnvImplForFatalException(), "Latch already held: " + this.debugString());
        }
        if (!this.tryLock()) {
            return false;
        }
        if (LatchSupport.TRACK_LATCHES) {
            LatchSupport.trackAcquire(this, this.context);
        }
        if (LatchSupport.CAPTURE_OWNER) {
            this.lastOwnerInfo = new OwnerInfo(this.context);
        }
        assert (EnvironmentImpl.maybeForceYield());
        return true;
    }

    @Override
    public void acquireShared() {
        this.acquireExclusive();
    }

    @Override
    public void release() {
        if (!this.isHeldByCurrentThread()) {
            throw EnvironmentFailureException.unexpectedState(this.context.getEnvImplForFatalException(), "Latch not held: " + this.debugString());
        }
        if (LatchSupport.TRACK_LATCHES) {
            LatchSupport.trackRelease(this, this.context);
        }
        if (LatchSupport.CAPTURE_OWNER) {
            this.lastOwnerInfo = null;
        }
        this.unlock();
    }

    @Override
    public void releaseIfOwner() {
        if (!this.isHeldByCurrentThread()) {
            return;
        }
        if (LatchSupport.TRACK_LATCHES) {
            LatchSupport.trackRelease(this, this.context);
        }
        if (LatchSupport.CAPTURE_OWNER) {
            this.lastOwnerInfo = null;
        }
        this.unlock();
    }

    @Override
    public boolean isOwner() {
        return this.isHeldByCurrentThread();
    }

    @Override
    public boolean isExclusiveOwner() {
        return this.isHeldByCurrentThread();
    }

    @Override
    public Thread getExclusiveOwner() {
        return this.getOwner();
    }

    @Override
    public int getNWaiters() {
        return this.getQueueLength();
    }

    @Override
    public StatGroup getStats() {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    public void clearStats() {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    public String toString() {
        return LatchSupport.toString(this, this.context, this.lastOwnerInfo);
    }

    @Override
    public String debugString() {
        return LatchSupport.debugString(this, this.context, this.lastOwnerInfo);
    }
}

