/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.log;

import com.tangosol.internal.sleepycat.je.log.ChecksumException;
import com.tangosol.internal.sleepycat.je.utilint.Adler32;
import com.tangosol.internal.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;

public class ChecksumValidator {
    private static final boolean DEBUG = false;
    private Checksum cksum = Adler32.makeChecksum();

    public void reset() {
        this.cksum.reset();
    }

    public void update(ByteBuffer buf, int length) throws ChecksumException {
        if (buf == null) {
            throw new ChecksumException("null buffer given to checksum validation, probably  result of 0's in log file.");
        }
        int bufStart = buf.position();
        this.update(buf.array(), bufStart + buf.arrayOffset(), length);
    }

    public void update(byte[] buf, int offset, int length) {
        this.cksum.update(buf, offset, length);
    }

    void validate(long expectedChecksum, long lsn) throws ChecksumException {
        if (expectedChecksum != this.cksum.getValue()) {
            throw new ChecksumException("Location " + DbLsn.getNoFormatString(lsn) + " expected " + expectedChecksum + " got " + this.cksum.getValue());
        }
    }

    public void validate(long expectedChecksum, long fileNum, long fileOffset) throws ChecksumException {
        if (expectedChecksum != this.cksum.getValue()) {
            long problemLsn = DbLsn.makeLsn(fileNum, fileOffset);
            throw new ChecksumException("Location " + DbLsn.getNoFormatString(problemLsn) + " expected " + expectedChecksum + " got " + this.cksum.getValue());
        }
    }
}

