/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.log.entry;

import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.dbi.DatabaseId;
import com.tangosol.internal.sleepycat.je.dbi.DatabaseImpl;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.log.LogEntryHeader;
import com.tangosol.internal.sleepycat.je.log.LogEntryType;
import com.tangosol.internal.sleepycat.je.log.LogUtils;
import com.tangosol.internal.sleepycat.je.log.entry.BaseEntry;
import com.tangosol.internal.sleepycat.je.log.entry.INContainingEntry;
import com.tangosol.internal.sleepycat.je.log.entry.LogEntry;
import com.tangosol.internal.sleepycat.je.tree.IN;
import com.tangosol.internal.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

public class INLogEntry<T extends IN>
extends BaseEntry<T>
implements LogEntry,
INContainingEntry {
    private DatabaseId dbId;
    private T in;
    private long prevFullLsn;
    private long prevDeltaLsn;

    public static <T extends IN> INLogEntry<T> create(Class<T> INClass) {
        return new INLogEntry<Class<T>>(INClass);
    }

    INLogEntry(Class<T> INClass) {
        super(INClass);
    }

    public INLogEntry(T in) {
        this(in, false);
    }

    INLogEntry(T in, boolean isBINDelta) {
        this.setLogType(isBINDelta ? LogEntryType.LOG_BIN_DELTA : ((IN)in).getLogType());
        this.dbId = ((IN)in).getDatabase().getId();
        this.in = in;
        this.prevFullLsn = ((IN)in).getLastFullVersion();
        this.prevDeltaLsn = ((IN)in).getLastDeltaVersion();
    }

    @Override
    public boolean isBINDelta() {
        return false;
    }

    @Override
    public DatabaseId getDbId() {
        return this.dbId;
    }

    @Override
    public long getPrevFullLsn() {
        return this.prevFullLsn;
    }

    @Override
    public long getPrevDeltaLsn() {
        return this.prevDeltaLsn;
    }

    public T getMainItem() {
        return this.in;
    }

    @Override
    public IN getIN(DatabaseImpl dbImpl) {
        return this.in;
    }

    public long getNodeId() {
        return ((IN)this.in).getNodeId();
    }

    @Override
    public void readEntry(EnvironmentImpl envImpl, LogEntryHeader header, ByteBuffer entryBuffer) {
        boolean version6OrLater;
        int logVersion = header.getVersion();
        boolean bl = version6OrLater = logVersion >= 6;
        if (logVersion < 2) {
            throw EnvironmentFailureException.unexpectedState("Attempt to read from log file with version " + logVersion + ", which is not supported any more");
        }
        if (version6OrLater) {
            this.dbId = new DatabaseId();
            this.dbId.readFromLog(entryBuffer, logVersion);
            this.prevFullLsn = LogUtils.readLong(entryBuffer, false);
            this.prevDeltaLsn = logVersion >= 8 ? LogUtils.readPackedLong(entryBuffer) : -1L;
        }
        this.in = (IN)this.newInstanceOfType();
        this.readMainItem(this.in, entryBuffer, logVersion);
        if (!version6OrLater) {
            this.dbId = new DatabaseId();
            this.dbId.readFromLog(entryBuffer, logVersion);
            this.prevFullLsn = LogUtils.readLong(entryBuffer, true);
            this.prevDeltaLsn = -1L;
        }
    }

    void readMainItem(T in, ByteBuffer entryBuffer, int logVersion) {
        if (this.isBINDelta()) {
            assert (logVersion >= 9);
            ((IN)in).readFromLog(entryBuffer, logVersion, true);
            if (logVersion == 9) {
                ((IN)in).setLastFullLsn(LogUtils.readPackedLong(entryBuffer));
            } else {
                ((IN)in).setLastFullLsn(this.prevFullLsn);
            }
        } else {
            ((IN)in).readFromLog(entryBuffer, logVersion);
        }
    }

    @Override
    public int getSize() {
        int inSize = this.isBINDelta() ? ((IN)this.in).getLogSize(true) : ((IN)this.in).getLogSize();
        return inSize + this.dbId.getLogSize() + LogUtils.getPackedLongLogSize(this.prevFullLsn) + LogUtils.getPackedLongLogSize(this.prevDeltaLsn);
    }

    @Override
    public void writeEntry(ByteBuffer destBuffer) {
        this.dbId.writeToLog(destBuffer);
        LogUtils.writePackedLong(destBuffer, this.prevFullLsn);
        LogUtils.writePackedLong(destBuffer, this.prevDeltaLsn);
        if (this.isBINDelta()) {
            ((IN)this.in).writeToLog(destBuffer, true);
        } else {
            ((IN)this.in).writeToLog(destBuffer);
        }
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(LogEntry other) {
        return false;
    }

    @Override
    public StringBuilder dumpEntry(StringBuilder sb, boolean verbose) {
        ((IN)this.in).dumpLog(sb, verbose);
        this.dbId.dumpLog(sb, verbose);
        if (this.prevFullLsn != -1L) {
            sb.append("<prevFullLsn>");
            sb.append(DbLsn.getNoFormatString(this.prevFullLsn));
            sb.append("</prevFullLsn>");
        }
        if (this.prevDeltaLsn != -1L) {
            sb.append("<prevDeltaLsn>");
            sb.append(DbLsn.getNoFormatString(this.prevDeltaLsn));
            sb.append("</prevDeltaLsn>");
        }
        return sb;
    }

    @Override
    public void dumpRep(StringBuilder sb) {
    }
}

