/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep;

import com.tangosol.internal.sleepycat.je.config.ConfigParam;
import com.tangosol.internal.sleepycat.je.dbi.DbConfigManager;
import com.tangosol.internal.sleepycat.je.rep.ReplicationNetworkConfig;
import com.tangosol.internal.sleepycat.je.rep.impl.RepParams;
import com.tangosol.internal.sleepycat.je.rep.net.PasswordSource;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class ReplicationSSLConfig
extends ReplicationNetworkConfig {
    private static final long serialVersionUID = 1L;
    public static final String SSL_KEYSTORE_FILE = "je.rep.ssl.keyStoreFile";
    public static final String SSL_KEYSTORE_PASSWORD = "je.rep.ssl.keyStorePassword";
    public static final String SSL_KEYSTORE_PASSWORD_CLASS = "je.rep.ssl.keyStorePasswordClass";
    public static final String SSL_KEYSTORE_PASSWORD_PARAMS = "je.rep.ssl.keyStorePasswordParams";
    public static final String SSL_KEYSTORE_TYPE = "je.rep.ssl.keyStoreType";
    public static final String SSL_SERVER_KEY_ALIAS = "je.rep.ssl.serverKeyAlias";
    public static final String SSL_CLIENT_KEY_ALIAS = "je.rep.ssl.clientKeyAlias";
    public static final String SSL_TRUSTSTORE_FILE = "je.rep.ssl.trustStoreFile";
    public static final String SSL_TRUSTSTORE_TYPE = "je.rep.ssl.trustStoreType";
    public static final String SSL_CIPHER_SUITES = "je.rep.ssl.cipherSuites";
    public static final String SSL_PROTOCOLS = "je.rep.ssl.protocols";
    public static final String SSL_AUTHENTICATOR = "je.rep.ssl.authenticator";
    public static final String SSL_AUTHENTICATOR_CLASS = "je.rep.ssl.authenticatorClass";
    public static final String SSL_AUTHENTICATOR_PARAMS = "je.rep.ssl.authenticatorParams";
    public static final String SSL_HOST_VERIFIER = "je.rep.ssl.hostVerifier";
    public static final String SSL_HOST_VERIFIER_CLASS = "je.rep.ssl.hostVerifierClass";
    public static final String SSL_HOST_VERIFIER_PARAMS = "je.rep.ssl.hostVerifierParams";
    private static Set<String> repSSLProperties = new HashSet<String>();
    private transient PasswordSource sslKeyStorePasswordSource;

    public ReplicationSSLConfig() {
    }

    public ReplicationSSLConfig(Properties properties) throws IllegalArgumentException {
        super(properties);
    }

    @Override
    public String getChannelType() {
        return "ssl";
    }

    public String getSSLKeyStore() {
        return DbConfigManager.getVal(this.props, RepParams.SSL_KEYSTORE_FILE);
    }

    public ReplicationNetworkConfig setSSLKeyStore(String filename) {
        this.setSSLKeyStoreVoid(filename);
        return this;
    }

    public void setSSLKeyStoreVoid(String filename) {
        DbConfigManager.setVal(this.props, RepParams.SSL_KEYSTORE_FILE, filename, true);
    }

    public String getSSLKeyStoreType() {
        return DbConfigManager.getVal(this.props, RepParams.SSL_KEYSTORE_TYPE);
    }

    public ReplicationNetworkConfig setSSLKeyStoreType(String keyStoreType) {
        this.setSSLKeyStoreTypeVoid(keyStoreType);
        return this;
    }

    public void setSSLKeyStoreTypeVoid(String keyStoreType) {
        DbConfigManager.setVal(this.props, RepParams.SSL_KEYSTORE_TYPE, keyStoreType, true);
    }

    public String getSSLKeyStorePassword() {
        return DbConfigManager.getVal(this.props, RepParams.SSL_KEYSTORE_PASSWORD);
    }

    public ReplicationNetworkConfig setSSLKeyStorePassword(String password) {
        this.setSSLKeyStorePasswordVoid(password);
        return this;
    }

    public void setSSLKeyStorePasswordVoid(String password) {
        DbConfigManager.setVal(this.props, RepParams.SSL_KEYSTORE_PASSWORD, password, true);
    }

    public String getSSLKeyStorePasswordClass() {
        return DbConfigManager.getVal(this.props, RepParams.SSL_KEYSTORE_PASSWORD_CLASS);
    }

    public ReplicationNetworkConfig setSSLKeyStorePasswordClass(String className) {
        this.setSSLKeyStorePasswordClassVoid(className);
        return this;
    }

    public void setSSLKeyStorePasswordClassVoid(String className) {
        DbConfigManager.setVal(this.props, RepParams.SSL_KEYSTORE_PASSWORD_CLASS, className, true);
    }

    public String getSSLKeyStorePasswordParams() {
        return DbConfigManager.getVal(this.props, RepParams.SSL_KEYSTORE_PASSWORD_PARAMS);
    }

    public ReplicationNetworkConfig setSSLKeyStorePasswordParams(String params) {
        this.setSSLKeyStorePasswordParamsVoid(params);
        return this;
    }

    public void setSSLKeyStorePasswordParamsVoid(String params) {
        DbConfigManager.setVal(this.props, RepParams.SSL_KEYSTORE_PASSWORD_PARAMS, params, true);
    }

    public String getSSLServerKeyAlias() {
        return DbConfigManager.getVal(this.props, RepParams.SSL_SERVER_KEY_ALIAS);
    }

    public ReplicationNetworkConfig setSSLServerKeyAlias(String alias) {
        this.setSSLServerKeyAliasVoid(alias);
        return this;
    }

    public void setSSLServerKeyAliasVoid(String alias) {
        DbConfigManager.setVal(this.props, RepParams.SSL_SERVER_KEY_ALIAS, alias, true);
    }

    public String getSSLClientKeyAlias() {
        return DbConfigManager.getVal(this.props, RepParams.SSL_CLIENT_KEY_ALIAS);
    }

    public ReplicationNetworkConfig setSSLClientKeyAlias(String alias) {
        this.setSSLClientKeyAliasVoid(alias);
        return this;
    }

    public void setSSLClientKeyAliasVoid(String alias) {
        DbConfigManager.setVal(this.props, RepParams.SSL_CLIENT_KEY_ALIAS, alias, true);
    }

    public String getSSLTrustStore() {
        return DbConfigManager.getVal(this.props, RepParams.SSL_TRUSTSTORE_FILE);
    }

    public ReplicationNetworkConfig setSSLTrustStore(String filename) {
        this.setSSLTrustStoreVoid(filename);
        return this;
    }

    public void setSSLTrustStoreVoid(String filename) {
        DbConfigManager.setVal(this.props, RepParams.SSL_TRUSTSTORE_FILE, filename, true);
    }

    public String getSSLTrustStoreType() {
        return DbConfigManager.getVal(this.props, RepParams.SSL_TRUSTSTORE_TYPE);
    }

    public ReplicationNetworkConfig setSSLTrustStoreType(String trustStoreType) {
        this.setSSLTrustStoreTypeVoid(trustStoreType);
        return this;
    }

    public void setSSLTrustStoreTypeVoid(String trustStoreType) {
        DbConfigManager.setVal(this.props, RepParams.SSL_TRUSTSTORE_TYPE, trustStoreType, true);
    }

    public String getSSLCipherSuites() {
        return DbConfigManager.getVal(this.props, RepParams.SSL_CIPHER_SUITES);
    }

    public ReplicationNetworkConfig setSSLCipherSuites(String cipherSuites) {
        this.setSSLCipherSuitesVoid(cipherSuites);
        return this;
    }

    public void setSSLCipherSuitesVoid(String cipherSuites) {
        DbConfigManager.setVal(this.props, RepParams.SSL_CIPHER_SUITES, cipherSuites, true);
    }

    public String getSSLProtocols() {
        return DbConfigManager.getVal(this.props, RepParams.SSL_PROTOCOLS);
    }

    public ReplicationNetworkConfig setSSLProtocols(String protocols) {
        this.setSSLProtocolsVoid(protocols);
        return this;
    }

    public void setSSLProtocolsVoid(String protocols) {
        DbConfigManager.setVal(this.props, RepParams.SSL_PROTOCOLS, protocols, true);
    }

    public String getSSLAuthenticator() {
        return DbConfigManager.getVal(this.props, RepParams.SSL_AUTHENTICATOR);
    }

    public ReplicationNetworkConfig setSSLAuthenticator(String authenticator) throws IllegalArgumentException {
        this.setSSLAuthenticatorVoid(authenticator);
        return this;
    }

    public void setSSLAuthenticatorVoid(String authenticator) throws IllegalArgumentException {
        DbConfigManager.setVal(this.props, RepParams.SSL_AUTHENTICATOR, authenticator, true);
    }

    public String getSSLAuthenticatorClass() {
        return DbConfigManager.getVal(this.props, RepParams.SSL_AUTHENTICATOR_CLASS);
    }

    public ReplicationNetworkConfig setSSLAuthenticatorClass(String authenticatorClass) {
        this.setSSLAuthenticatorClassVoid(authenticatorClass);
        return this;
    }

    public void setSSLAuthenticatorClassVoid(String authenticatorClass) throws IllegalArgumentException {
        DbConfigManager.setVal(this.props, RepParams.SSL_AUTHENTICATOR_CLASS, authenticatorClass, true);
    }

    public String getSSLAuthenticatorParams() {
        return DbConfigManager.getVal(this.props, RepParams.SSL_AUTHENTICATOR_PARAMS);
    }

    public ReplicationNetworkConfig setSSLAuthenticatorParams(String authenticatorParams) {
        this.setSSLAuthenticatorParamsVoid(authenticatorParams);
        return this;
    }

    public void setSSLAuthenticatorParamsVoid(String authenticatorParams) {
        DbConfigManager.setVal(this.props, RepParams.SSL_AUTHENTICATOR_PARAMS, authenticatorParams, true);
    }

    public String getSSLHostVerifier() {
        return DbConfigManager.getVal(this.props, RepParams.SSL_HOST_VERIFIER);
    }

    public ReplicationNetworkConfig setSSLHostVerifier(String hostVerifier) throws IllegalArgumentException {
        this.setSSLHostVerifierVoid(hostVerifier);
        return this;
    }

    public void setSSLHostVerifierVoid(String hostVerifier) throws IllegalArgumentException {
        DbConfigManager.setVal(this.props, RepParams.SSL_HOST_VERIFIER, hostVerifier, true);
    }

    public String getSSLHostVerifierClass() {
        return DbConfigManager.getVal(this.props, RepParams.SSL_HOST_VERIFIER_CLASS);
    }

    public ReplicationNetworkConfig setSSLHostVerifierClass(String hostVerifierClass) {
        this.setSSLHostVerifierClassVoid(hostVerifierClass);
        return this;
    }

    public void setSSLHostVerifierClassVoid(String hostVerifierClass) {
        DbConfigManager.setVal(this.props, RepParams.SSL_HOST_VERIFIER_CLASS, hostVerifierClass, true);
    }

    public String getSSLHostVerifierParams() {
        return DbConfigManager.getVal(this.props, RepParams.SSL_HOST_VERIFIER_PARAMS);
    }

    public ReplicationNetworkConfig setSSLHostVerifierParams(String hostVerifierParams) {
        this.setSSLHostVerifierParamsVoid(hostVerifierParams);
        return this;
    }

    public void setSSLHostVerifierParamsVoid(String hostVerifierParams) {
        DbConfigManager.setVal(this.props, RepParams.SSL_HOST_VERIFIER_PARAMS, hostVerifierParams, true);
    }

    @Override
    public ReplicationSSLConfig clone() {
        return (ReplicationSSLConfig)super.clone();
    }

    public PasswordSource getSSLKeyStorePasswordSource() {
        return this.sslKeyStorePasswordSource;
    }

    public ReplicationNetworkConfig setSSLKeyStorePasswordSource(PasswordSource passwordSource) {
        this.setSSLKeyStorePasswordSourceVoid(passwordSource);
        return this;
    }

    public void setSSLKeyStorePasswordSourceVoid(PasswordSource passwordSource) {
        this.sslKeyStorePasswordSource = passwordSource;
    }

    static Set<String> getRepSSLPropertySet() {
        return repSSLProperties;
    }

    @Override
    protected boolean isValidConfigParam(String paramName) {
        if (repSSLProperties.contains(paramName)) {
            return true;
        }
        return super.isValidConfigParam(paramName);
    }

    static {
        repSSLProperties.add(SSL_KEYSTORE_FILE);
        repSSLProperties.add(SSL_KEYSTORE_PASSWORD);
        repSSLProperties.add(SSL_KEYSTORE_PASSWORD_CLASS);
        repSSLProperties.add(SSL_KEYSTORE_PASSWORD_PARAMS);
        repSSLProperties.add(SSL_KEYSTORE_TYPE);
        repSSLProperties.add(SSL_SERVER_KEY_ALIAS);
        repSSLProperties.add(SSL_CLIENT_KEY_ALIAS);
        repSSLProperties.add(SSL_TRUSTSTORE_FILE);
        repSSLProperties.add(SSL_TRUSTSTORE_TYPE);
        repSSLProperties.add(SSL_CIPHER_SUITES);
        repSSLProperties.add(SSL_PROTOCOLS);
        repSSLProperties.add(SSL_AUTHENTICATOR);
        repSSLProperties.add(SSL_AUTHENTICATOR_CLASS);
        repSSLProperties.add(SSL_AUTHENTICATOR_PARAMS);
        repSSLProperties.add(SSL_HOST_VERIFIER);
        repSSLProperties.add(SSL_HOST_VERIFIER_CLASS);
        repSSLProperties.add(SSL_HOST_VERIFIER_PARAMS);
        repSSLProperties = Collections.unmodifiableSet(repSSLProperties);
        ConfigParam forceLoad = RepParams.CHANNEL_TYPE;
        ConfigParam configParam = RepParams.CHANNEL_TYPE;
    }
}

